SetNetBaleSizeEvent = {};
SetNetBaleSizeEvent_mt = Class(SetNetBaleSizeEvent, Event);

InitEventClass(SetNetBaleSizeEvent, "SetNetBaleSizeEvent");

function SetNetBaleSizeEvent:emptyNew()
	local self = Event:new(SetNetBaleSizeEvent_mt);
	self.className="SetNetBaleSizeEvent";
	return self;
end;

function SetNetBaleSizeEvent:new(vehicle, netBaleSize)
	local self = SetNetBaleSizeEvent:emptyNew()
	self.vehicle = vehicle;
	self.netBaleSize = netBaleSize;
	return self;
end;

function SetNetBaleSizeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.netBaleSize = streamReadInt16(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetNetBaleSizeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt16(streamId, self.netBaleSize);
end;

function SetNetBaleSizeEvent:run(connection)
	self.vehicle:setNetBaleSize(self.netBaleSize, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetNetBaleSizeEvent:new(self.vehicle, self.netBaleSize), nil, connection, self.vehicle);
	end;
end;

function SetNetBaleSizeEvent.sendEvent(vehicle, netBaleSize, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetNetBaleSizeEvent:new(vehicle, netBaleSize), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetNetBaleSizeEvent:new(vehicle, netBaleSize));
		end;
	end;
end;
