SetNetBaleEvent = {};
SetNetBaleEvent_mt = Class(SetNetBaleEvent, Event);

InitEventClass(SetNetBaleEvent, "SetNetBaleEvent");

function SetNetBaleEvent:emptyNew()
	local self = Event:new(SetNetBaleEvent_mt);
	self.className="SetNetBaleEvent";
	return self;
end;

function SetNetBaleEvent:new(vehicle, netBale)
	local self = SetNetBaleEvent:emptyNew()
	self.vehicle = vehicle;
	self.netBale = netBale;
	return self;
end;

function SetNetBaleEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.netBale = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetNetBaleEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.netBale);
end;

function SetNetBaleEvent:run(connection)
	self.vehicle:setNetBale(self.netBale, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetNetBaleEvent:new(self.vehicle, self.netBale), nil, connection, self.vehicle);
	end;
end;

function SetNetBaleEvent.sendEvent(vehicle, netBale, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetNetBaleEvent:new(vehicle, netBale), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetNetBaleEvent:new(vehicle, netBale));
		end;
	end;
end;
