SetHasRopesEvent = {};
SetHasRopesEvent_mt = Class(SetHasRopesEvent, Event);

InitEventClass(SetHasRopesEvent, "SetHasRopesEvent");

function SetHasRopesEvent:emptyNew()
	local self = Event:new(SetHasRopesEvent_mt);
	self.className="SetHasRopesEvent";
	return self;
end;

function SetHasRopesEvent:new(vehicle, isLoadedWithRopes)
	local self = SetHasRopesEvent:emptyNew()
	self.vehicle = vehicle;
	self.isLoadedWithRopes = isLoadedWithRopes;
	return self;
end;

function SetHasRopesEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isLoadedWithRopes = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetHasRopesEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoadedWithRopes);
end;

function SetHasRopesEvent:run(connection)   
	self.vehicle:SetHasRopes(self.isLoadedWithRopes, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetHasRopesEvent:new(self.vehicle, self.isLoadedWithRopes), nil, connection, self.vehicle);
	end;
end;

function SetHasRopesEvent.sendEvent(vehicle, isLoadedWithRopes, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes));
		end;
	end;
end;