--
-- ExtendedWheels
--
--
-- @author  Manuel Leithner
-- @date  10/12/14
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ExtendedWheels = {};

function ExtendedWheels.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function ExtendedWheels:load(xmlFile)
    for i, wheel in ipairs(self.wheels) do
        local wheelnamei = string.format("vehicle.wheels.wheel(%d)", wheel.xmlIndex);
        if hasXMLProperty(xmlFile, wheelnamei .. "#rotSpeedAnimRef") then
            local animName = getXMLString(xmlFile, wheelnamei .. "#rotSpeedAnimRef");
            if self.animations[animName] ~= nil then
                wheel.rotSpeedAnimRef = animName;
                wheel.rotSpeedDefault = wheel.rotSpeed;
                wheel.rotSpeedNegDefault = wheel.rotSpeedNeg;
                wheel.rotSpeedAnimStart = Utils.getNoNil(getXMLInt(xmlFile, wheelnamei .. "#rotSpeedAnimStart"), 0);
            end;
        end;
    end
end;

function ExtendedWheels:delete()
end;

function ExtendedWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtendedWheels:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtendedWheels:update(dt)
end;

function ExtendedWheels:updateTick(dt)
    if self:getIsActive() then
        for _, wheel in pairs(self.wheels) do
            if wheel.rotSpeedAnimRef ~= nil then
                local animTime = math.abs(wheel.rotSpeedAnimStart - self:getAnimationTime(wheel.rotSpeedAnimRef));
                wheel.rotSpeed    = wheel.rotSpeedDefault * animTime;
                wheel.rotSpeedNeg = wheel.rotSpeedNegDefault * animTime;
            end;
        end;
    end;
end;

function ExtendedWheels:draw()
end;