RotationNodes = {}

function RotationNodes.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end
function RotationNodes:load(xmlFile)
    ----------   ---
	self.RotateParts = {}
	local i = 0
	while true do
		local baseName = string.format("vehicle.RotateParts.rotatePart(%d)", i)
		local index = getXMLString(xmlFile, baseName .. "#index")
		if index == nil then
			break
		end
		local node = Utils.indexToObject(self.components, index)
		if node ~= nil then
			local entry = {}
			entry.node = node
			entry.speedX = getXMLFloat(xmlFile, baseName .. "#x")
			entry.speedY = getXMLFloat(xmlFile, baseName .. "#y")
			entry.speedZ = getXMLFloat(xmlFile, baseName .. "#z")
			entry.lastMotor = getXMLBool(xmlFile, baseName .. "#lastMotor")
			table.insert(self.RotateParts, entry)
		end
		i = i + 1		
	end
    ----------   ---
end

function RotationNodes:delete()
end

function RotationNodes:mouseEvent(posX, posY, isDown, isUp, button)
end

function RotationNodes:keyEvent(unicode, sym, modifier, isDown)
end

function RotationNodes:update(dt)
    ----------    ---	
	if self.isMotorStarted then
		for _, v in pairs(self.RotateParts) do
			if v.lastMotor then
				rotate(v.node, v.speedX*self.motor.lastMotorRpm/100, v.speedY*self.motor.lastMotorRpm/100, v.speedZ*self.motor.lastMotorRpm/100)
			else
				rotate(v.node, v.speedX, v.speedY, v.speedZ)
			end
		end	
	end;
    ----------    ---
end

function RotationNodes:updateTick(dt)
end

function RotationNodes:draw()
end
