
1	--
2	-- ArticulatedAxis
3	-- This is the specialization for vehicles which steer with an articulated axis (excavators, loaders ...)
4	--
5	-- @author  Stefan Geiger
6	-- @date  18/08/09
7	--
8	-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
9	
10	ArticulatedAxis = {};
11	
12	function ArticulatedAxis.prerequisitesPresent(specializations)
13	    return SpecializationUtil.hasSpecialization(Drivable, specializations);
14	end;
15	
16	function ArticulatedAxis:load(xmlFile)
17	    ArticulatedAxis.loadArticulatedAxis(self, xmlFile, false);
18	end;
19	
20	function ArticulatedAxis:loadArticulatedAxis(xmlFile, isInitialized)
21	    local index = getXMLInt(xmlFile, "vehicle.articulatedAxis#componentJointIndex");
22	    if index ~= nil then
23	        local componentJoint = self.componentJoints[index+1];
24	        local rotSpeed = getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotSpeed");
25	        local rotMax = getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotMax");
26	        local rotMin = getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotMin");
27	        if componentJoint ~= nil and rotSpeed ~= nil and rotMax ~= nil and rotMin ~= nil then
28	            rotSpeed = math.rad(rotSpeed);
29	            rotMax = math.rad(rotMax);
30	            rotMin = math.rad(rotMin);
31	            local entry = {};
32	
33	            entry.componentJoint = componentJoint;
34	            entry.anchorActor = Utils.getNoNil(getXMLInt(xmlFile,  "vehicle.articulatedAxis#anchorActor"), 0);
35	            if not isInitialized then
36	                entry.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.articulatedAxis#rotNode"));
37	            end;
38	            entry.rotMax = rotMax;
39	            entry.rotMin = rotMin;
40	            entry.rotSpeed = rotSpeed;
41	
42	            local maxRotTime = rotMax/rotSpeed;
43	            local minRotTime = rotMin/rotSpeed;
44	            if minRotTime > maxRotTime then
45	                local temp = minRotTime;
46	                minRotTime = maxRotTime;
47	                maxRotTime = temp;
48	            end;
49	            if maxRotTime > self.maxRotTime then
50	                self.maxRotTime = maxRotTime;
51	            end;
52	            if minRotTime < self.minRotTime then
53	                self.minRotTime = minRotTime;
54	            end;
55	
56	            entry.curRot = 0;
57	
58	            local i = 0;
59	            entry.rotatingParts = {};
60	            while true do
61	                local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.articulatedAxis.rotatingPart(%d)#index", i)));
62	                if node == nil then
63	                    break;
64	                end;
65	                local rotatingPart = {};
66	                rotatingPart.node = node;
67	                local rx, ry, rz = getRotation(node);
68	                rotatingPart.defRot = {rx, ry, rz};
69	                rotatingPart.posRot = Utils.getRadiansFromString(getXMLString(xmlFile, string.format("vehicle.articulatedAxis.rotatingPart(%d)#posRot", i)), 3);
70	                rotatingPart.negRot = Utils.getRadiansFromString(getXMLString(xmlFile, string.format("vehicle.articulatedAxis.rotatingPart(%d)#negRot", i)), 3);
71	                rotatingPart.negRotFactor = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.articulatedAxis.rotatingPart(%d)#negRotFactor", i)), 1);
72	                rotatingPart.posRotFactor = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.articulatedAxis.rotatingPart(%d)#posRotFactor", i)), 1);
73	                rotatingPart.invertSteeringAngle = Utils.getNoNil(getXMLBool(xmlFile, string.format("vehicle.articulatedAxis.rotatingPart(%d)#invertSteeringAngle", i)), false);
74	                table.insert(entry.rotatingParts, rotatingPart);
75	                i = i + 1;
76	            end;
77	
78	            self.articulatedAxis = entry;
79	        end;
80	    end;
81	
82	    self.interpolatedRotatedTime = 0;
83	end;
84	
85	function ArticulatedAxis:delete()
86	end;
87	
88	function ArticulatedAxis:mouseEvent(posX, posY, isDown, isUp, button)
89	end;
90	
91	function ArticulatedAxis:keyEvent(unicode, sym, modifier, isDown)
92	end;
93	
94	function ArticulatedAxis:update(dt)
95	    if self:getIsActive() then
96	        if self.articulatedAxis ~= nil then
97	
98	            local curRot = self.articulatedAxis.curRot;
99	            if self.interpolatedRotatedTime < self.rotatedTime then
100	                self.interpolatedRotatedTime = math.min(self.rotatedTime, self.interpolatedRotatedTime + math.abs(self.articulatedAxis.rotSpeed) * dt/500);
101	            elseif self.interpolatedRotatedTime > self.rotatedTime then
102	                self.interpolatedRotatedTime = math.max(self.rotatedTime, self.interpolatedRotatedTime - math.abs(self.articulatedAxis.rotSpeed) * dt/500);
103	            end;
104	
105	            local steeringAngle = self.interpolatedRotatedTime * self.articulatedAxis.rotSpeed;
106	            if steeringAngle > self.articulatedAxis.rotMax then
107	                steeringAngle = self.articulatedAxis.rotMax;
108	            elseif steeringAngle < self.articulatedAxis.rotMin then
109	                steeringAngle = self.articulatedAxis.rotMin;
110	            end;
111	            if self.updateArticulatedAxisRotation ~= nil then
112	                steeringAngle = self:updateArticulatedAxisRotation(steeringAngle, dt);
113	            end;
114	            if math.abs(steeringAngle - curRot) > 0.000001 then
115	                if self.isServer then
116	                    local rotNode = Utils.getNoNil(self.articulatedAxis.rotNode, self.articulatedAxis.componentJoint.jointNode);
117	                    setRotation(rotNode, 0, steeringAngle, 0);
118	                    setJointFrame(self.articulatedAxis.componentJoint.jointIndex, self.articulatedAxis.anchorActor, self.articulatedAxis.componentJoint.jointNode);
119	                    self.articulatedAxis.curRot = steeringAngle;
120	                end;
121	
122	                if self.isClient then
123	                    local percent = 0;
124	                    if steeringAngle > 0 then
125	                        percent = steeringAngle / self.articulatedAxis.rotMax;
126	                    elseif steeringAngle < 0 then
127	                        percent = steeringAngle / self.articulatedAxis.rotMin;
128	                    end;
129	                    for i,rotPart in pairs(self.articulatedAxis.rotatingParts) do
130	                        local rx,ry,rz;
131	                        if (steeringAngle > 0 and not rotPart.invertSteeringAngle) or (steeringAngle < 0 and rotPart.invertSteeringAngle) then
132	                            rx,ry,rz = Utils.vector3ArrayLerp(rotPart.defRot, rotPart.posRot, math.min(1,percent*rotPart.posRotFactor));
133	                        else
134	                            rx,ry,rz = Utils.vector3ArrayLerp(rotPart.defRot, rotPart.negRot, math.min(1,percent*rotPart.negRotFactor));
135	                        end;
136	                        setRotation(rotPart.node, rx,ry,rz);
137	                        if self.setMovingToolDirty ~= nil then
138	                            self:setMovingToolDirty(rotPart.node);
139	                        end;
140	                    end;
141	                end;
142	            end;
143	
144	        end;
145	    end;
146	end;
147	
148	function ArticulatedAxis:draw()
149	end;
150	
151	function ArticulatedAxis:developmentReloadFromXML(xmlFile)
152	    ArticulatedAxis.loadArticulatedAxis(self, xmlFile, true);
153	end;