--
-- Straw Specialization for Combines
--
-- @author  Templaer
-- @date  24/05/09


straw = {};

function straw.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function straw:load(xmlFile)
    -- Backup of Chopper Blind
    self.backupChopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));

    -- Straw Active Boolean
    self.strawActive = true;
end;

function straw:delete()
end;

function straw:mouseEvent(posX, posY, isDown, isUp, button)
end;

function straw:keyEvent(unicode, sym, modifier, isDown)
end;

function straw:update(dt)
    -- Check for input
	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
		    self.strawActive = not self.strawActive;
		end;
		
		-- Check if straw is enabled
        if not self.strawActive then
		    self.strawEmitState = false;
			self.strawEnableTime = nil;
			self.chopperActivated = true;
			self.chopperBlind = nil;
			
			-- Lower the chopper
		    local chopperBlindRotationSpeed = 0.001;
            local minRotX = -83*3.1415/180.0;
			
			if self.backupChopperBlind ~= nil then
                local x,y,z = getRotation(self.backupChopperBlind);
			
                x = x-dt*chopperBlindRotationSpeed;
                if x < minRotX then
                    x = minRotX;
                end;
			    setRotation(self.backupChopperBlind, x, y, z);
			end;
					
            -- Enable chopper particle system					
			if self.lastArea > 0 then
			    if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    disableChopperEmit = false;
			    end;
			
			    -- Chopper starting delay
			    if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
			
                    self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
			
                    if self.currentChopperParticleSystem == nil then
                        self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
                    end;
                    Utils.setEmittingState(self.currentChopperParticleSystem, true);
				
			    end;
			end;	
	    elseif self.strawActive then
		    self.chopperBlind = self.backupChopperBlind;
		end;
    end;
end;

function straw:draw()
    -- Add text to the HUD
    if self.strawActive then
        g_currentMission:addHelpButtonText(g_i18n:getText("strawCutOn"), InputBinding.IMPLEMENT_EXTRA3);
    else
	    g_currentMission:addHelpButtonText(g_i18n:getText("strawCutOff"), InputBinding.IMPLEMENT_EXTRA3);
	end;
end;
