-- train
--
-- script for a map-mover with followers
--
-- Author: sven (sven777b) Brutigam
-- Copyright (C) Halycon Media

PathTrains = {};

_G.PathTrains = PathTrains;
function PathTrains.onCreate(id)
	if _G.trains == nil then
		_G.trains = {};
	end;
	table.insert(_G.trains, Train:new(id));
end;

function PathTrains:update(dt)
	if _G.trains ~= nil then
		for k,v in pairs(_G.trains) do
			v:update(dt);
		end;
	end;
end;

function PathTrains:delete()
	_G.trains = nil;
end;
function PathTrains:loadMap(name)
end;
function PathTrains:deleteMap()
	_G.trains = nil;
end;
function PathTrains:mouseEvent(posX, posY, isDown, isUp, button)
end;
function PathTrains:keyEvent(unicode, sym, modifier, isDown)
end;
function PathTrains:draw()
end;


Train = {};
local Train_mt = Class(Train);
g_universalTipTriggerDir = g_currentModDirectory;

function Train:new(id, customMt)
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, Train_mt);
    end;
    
    local spline = getUserAttribute(id, "spline");
    local trainobj = getUserAttribute(id, "train");
    local trainid = Utils.indexToObject(id,trainobj);
	instance.spline = Utils.indexToObject(id,spline);
    	local length = getSplineLength(instance.spline);
	
	instance.trainGroup = {};
    	instance.positions = {};
	local numOfParts = getNumOfChildren(trainid);
	if numOfParts > 0 then
		for c=1, numOfParts do
			local trainpart = getChildAt(trainid,c-1);
			table.insert(instance.trainGroup, trainpart );
			local x,y,z = getTranslation(trainpart);
			local delay = -z/length;
			table.insert(instance.positions, delay);
		end;
	end;
		
    	local speed = Utils.getNoNil(getUserAttribute(id, "speed"), 10);
    	instance.timeScale = (speed/3.6) / length;

    instance.isEnabled = true;
    instance.firstRun = true;
    return instance;
end;

function Train:update(dt)
	if self.isEnabled then
		if not self.firstRun then

			for i=1, table.getn(self.trainGroup) do
        			self.positions[i] = self.positions[i] - 0.001*dt*self.timeScale;
				local x,y,z = getSplinePosition(self.spline, self.positions[i]);
				local rx,ry,rz = getSplineOrientation(self.spline, self.positions[i], 0, -1, 0);
				setTranslation(self.trainGroup[i], x-200, y, z);
				setRotation(self.trainGroup[i], rx, ry, rz);
			end;    

		else
			self.firstRun = false;
		end;
	end;
end;

addModEventListener(PathTrains);
g_onCreateUtil.addOnCreateFunction("PathTrainsOnCreate", PathTrains.onCreate);
