local metadata = {
"## Interface: FS15 1.3.0.1 1.3RC1",
"## Title: MotorizedFuelTank",
"## Notes: MotorizedFuelTank Specialization für Tankfahrzeuge",
"## Author: Farmer_Andy, Marhu",
"## Version: 1.0.0-106b",
"## Date: 12.09.2015",
"## Web: http://marhu.net"
}

MotorizedFuelTank = {};
function MotorizedFuelTank.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;
function MotorizedFuelTank:load(xmlFile)
	
	self.setIsFuelFilling = MotorizedFuelTank.setIsFuelFilling;
	self.fillFuel = MotorizedFuelTank.fillFuel;
	self.addFuelFillTrigger2 = MotorizedFuelTank.addFuelFillTrigger2
	self.addFuelFillTrigger = Utils.appendedFunction(self.addFuelFillTrigger, self.addFuelFillTrigger2);
	
	self.fakeVehicle = {}
	self.fakeVehicle.getFillLevel = function(vehicle,...) return self:getFillLevel(...); end; 
	self.fakeVehicle.setFillLevel = function(vehicle,...) return self:setFillLevel(...); end;
	self.fakeVehicle.allowFillType = function(vehicle,...) return self:allowFillType(...); end;
	
	self.fuelFillLitersPerSecond2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fuelFillLitersPerSecond"), 50);
   
	local gasStationTriggerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gasStationTrigger#index"));
    if gasStationTriggerNode ~= nil then
        self.gasStationTrigger = GasStation2:new(gasStationTriggerNode, self);
	end;
	
	self.fillTank = false;
end;
function MotorizedFuelTank:delete()
    if self.gasStationTrigger ~= nil then
        self.gasStationTrigger:delete();
        self.gasStationTrigger = nil;
    end;
end;
function MotorizedFuelTank:mouseEvent(posX, posY, isDown, isUp, button)
end;
function MotorizedFuelTank:keyEvent(unicode, sym, modifier, isDown)
end;
function MotorizedFuelTank:readStream(streamId, connection)
end;
function MotorizedFuelTank:writeStream(streamId, connection)
end;
function MotorizedFuelTank:readUpdateStream(streamId, timestamp, connection)
end;
function MotorizedFuelTank:writeUpdateStream(streamId, connection, dirtyMask)
end;
function MotorizedFuelTank:update(dt)
	if self:getIsActiveForInput() and (self.fillLevel == 0 or self:getFillLevel(Fillable.FILLTYPE_FUEL) ~= 0) then
		if InputBinding.hasEvent(InputBinding.SWITCH_FILL) then
			self.fillTank = not self.fillTank;
		end;
	end;
end;
function MotorizedFuelTank:updateTick(dt)
end;
function MotorizedFuelTank:draw()
	if self:getIsActiveForInput() and (self.fillLevel == 0 or self:getFillLevel(Fillable.FILLTYPE_FUEL) ~= 0) then
		if self.fillTank then
			g_currentMission:addHelpButtonText(g_i18n:getText("SWITCH_FILL_TRUCK"), InputBinding.SWITCH_FILL);
			g_currentMission:addExtraPrintText(g_i18n:getText("FILL_TANK_IS_ACTIVE"));
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("SWITCH_FILL_TANK"), InputBinding.SWITCH_FILL);
			g_currentMission:addExtraPrintText(g_i18n:getText("FILL_TRUCK_IS_ACTIVE"));
		end;
	end;
end;
function MotorizedFuelTank:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'fillTank="' .. tostring(self.fillTank) ..'"';
	
	return attributes;
end;

function MotorizedFuelTank:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local fillTank = Utils.getNoNil(getXMLBool(xmlFile, key .. "#fillTank"), self.fillTank);
	
	self.fillTank = fillTank;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;
function MotorizedFuelTank:setIsFuelFilling(isFilling, noEventSend)
   if isFilling ~= self.isFuelFilling then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SteerableToggleRefuelEvent:new(self, isFilling), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(SteerableToggleRefuelEvent:new(self, isFilling));
            end;
        end;
        self.isFuelFilling = isFilling;
        if isFilling then
            -- find the first trigger which is activable
           self.fuelFillTrigger = nil;
           self.fuelFillTrigger2 = nil;
		   for i=1, table.getn(self.fuelFillTriggers) do
                local trigger = self.fuelFillTriggers[i];
                if trigger:getIsActivatable(self) then
                   if self.fillTank then
						self.fuelFillTrigger = self;
						self.fuelFillTrigger2 = trigger;
					else
						self.fuelFillTrigger = trigger;
					end
                    break;
                end;
            end;
        end
        if self.isClient and self.sampleRefuel ~= nil then
            if isFilling then
                Utils.play3DSample(self.sampleRefuel);
            else
                Utils.stop3DSample(self.sampleRefuel);
            end;
        end;
    end
end
function MotorizedFuelTank:fillFuel(vehicle, delta)
	delta = delta * (self.fuelFillLitersPerSecond2/self.fuelFillLitersPerSecond);
	return self.fuelFillTrigger2:fillFuel(self.fakeVehicle, delta);
end;
function MotorizedFuelTank:addFuelFillTrigger2(trigger)
	if self.gasStationTrigger == trigger then
		self:removeFuelFillTrigger(self.gasStationTrigger)
		self.gasStationTrigger.vehiclesTriggerCount[self] = nil;
	end
end;