-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
GasStation2 = {};
local GasStation2_mt = Class(GasStation2);
function GasStation2:onCreate(id)
    g_currentMission:addNonUpdateable(GasStation2:new(id));
    -- print("created gas station trigger, id: ", id);
end;
function GasStation2:new(id, trailer, customMt)
    local self = {};
    if customMt ~= nil then
        setmetatable(self, customMt);
    else
        setmetatable(self, GasStation2_mt);
    end;
    self.triggerId = id;
    addTrigger(id, "triggerCallback", self);
    
    self.trailer = trailer;
    self.isEnabled = true;
    self.vehiclesTriggerCount = {};
    
    self.moneyChangeId = getMoneyTypeId();
    return self;
end;
function GasStation2:delete()
    -- remove the gas stations from all vehicles that are triggered by this trigger
    for vehicle,count in pairs(self.vehiclesTriggerCount) do
        if count > 0 then
            if vehicle.removeFuelFillTrigger ~= nil then
                vehicle:removeFuelFillTrigger(self);
            end;
        end;
    end;
    if self.mapHotspot ~= nil then
        g_currentMission.ingameMap:deleteMapHotspot(self.mapHotspot);
    end
    removeTrigger(self.triggerId);
end;
function GasStation2:onVehicleDeleted(vehicle)
    self.vehiclesTriggerCount[vehicle] = nil;
    g_currentMission:showMoneyChange(self.moneyChangeId);
end
function GasStation2:fillFuel(vehicle, delta)
    if self.trailer ~= nil then
        local trailerFuelFillLevel = self.trailer:getFillLevel(Fillable.FILLTYPE_FUEL);
        if trailerFuelFillLevel > 0 then
            delta = math.min(delta, trailerFuelFillLevel);
            if delta <= 0 then
                return 0;
            end
        else
            return 0;
        end
    end
    if vehicle.setFuelFillLevel ~= nil then
        local oldFillLevel = vehicle.fuelFillLevel
        vehicle:setFuelFillLevel(vehicle.fuelFillLevel + delta);
        delta = vehicle.fuelFillLevel - oldFillLevel;
    else
        if not vehicle:allowFillType(Fillable.FILLTYPE_FUEL, false) then
            return 0;
        end
        local oldFillLevel = vehicle:getFillLevel(Fillable.FILLTYPE_FUEL);
        vehicle:setFillLevel(oldFillLevel + delta, Fillable.FILLTYPE_FUEL);
        delta = vehicle:getFillLevel(Fillable.FILLTYPE_FUEL) - oldFillLevel;
    end
    if delta > 0 then
        if self.trailer ~= nil then
            self.trailer:setFillLevel(self.trailer:getFillLevel(Fillable.FILLTYPE_FUEL) - delta, Fillable.FILLTYPE_FUEL);
        else
            local price = delta * g_fuelPricePerLiter;
            g_currentMission.missionStats:updateStats("expenses", price);
            g_currentMission:addSharedMoney(-price, "vehicleRunningCost");
            g_currentMission:addMoneyChange(-price, self.moneyChangeId);
        end
    end
    return delta;
end
function GasStation2:getIsActivatable(vehicle)
    if self.trailer ~= nil then
        if self.trailer:getFillLevel(Fillable.FILLTYPE_FUEL) <= 0 then
            return false;
        end
    end
    if vehicle.setFuelFillLevel == nil and not vehicle:allowFillType(Fillable.FILLTYPE_FUEL, false) then
        return false;
    end
    return true;
end
function GasStation2:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    if self.isEnabled and (onEnter or onLeave) then
        local vehicle = g_currentMission.nodeToVehicle[otherId];
        if vehicle ~= nil and vehicle.addFuelFillTrigger ~= nil and vehicle.removeFuelFillTrigger ~= nil and vehicle ~= self then
            local count = Utils.getNoNil(self.vehiclesTriggerCount[vehicle], 0);
            if onEnter then
                self.vehiclesTriggerCount[vehicle] = count+1;
                if count == 0 then
                    vehicle:addFuelFillTrigger(self);
                end
            else -- onLeave
                self.vehiclesTriggerCount[vehicle] = count-1;
                if count == 1 then
                    self.vehiclesTriggerCount[vehicle] = nil;
                    vehicle:removeFuelFillTrigger(self);
                    g_currentMission:showMoneyChange(self.moneyChangeId);
                end
            end;
        end;
    end;
end;