--
-- FuelTrailer
--
-- @author  Stefan Geiger
-- @date  08/10/10 
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- FuelTrailer2 Specialization by Farmer_Andy 12/09/2015
-- Fix für doppelte Einträge im Hilfe Fenster

FuelTrailer2 = {};
function FuelTrailer2.prerequisitesPresent(specializations)
    return not SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function FuelTrailer2:load(xmlFile)
    self.setIsFuelFilling = SpecializationUtil.callSpecializationsFunction("setIsFuelFilling");
    self.addFuelFillTrigger = FuelTrailer2.addFuelFillTrigger;
    self.removeFuelFillTrigger = FuelTrailer2.removeFuelFillTrigger;
    self.FuelTrailer2FillActivatable = FuelTrailer2FillActivatable:new(self);
    self.fuelFillTriggers = {};
    self.isFuelFilling = false;
    self.fuelFillLitersPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fuelFillLitersPerSecond"), 50);
    local gasStationTriggerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gasStationTrigger#index"));
    if gasStationTriggerNode ~= nil then
        self.gasStationTrigger = GasStation2:new(gasStationTriggerNode, self);
    end;
    
    if self.isClient then
        self.sampleRefuel = Utils.loadSample(xmlFile, {}, "vehicle.refuelSound", "$data/maps/sounds/refuel.wav", self.baseDirectory, self.components[1].node);
    end;
end;
function FuelTrailer2:delete()
    for _, trigger in pairs(self.fuelFillTriggers) do
        trigger:onVehicleDeleted(self);
    end
    g_currentMission:removeActivatableObject(self.FuelTrailer2FillActivatable);
    if self.gasStationTrigger ~= nil then
        self.gasStationTrigger:delete();
        self.gasStationTrigger = nil;
    end;
    if self.isClient then
        Utils.deleteSample(self.sampleRefuel);    
    end;
end;
function FuelTrailer2:mouseEvent(posX, posY, isDown, isUp, button)
end;
function FuelTrailer2:keyEvent(unicode, sym, modifier, isDown)
end;
function FuelTrailer2:readStream(streamId, connection)
    local isFuelFilling = streamReadBool(streamId);
    self:setIsFuelFilling(isFuelFilling, true);
end;
function FuelTrailer2:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isFuelFilling);
end;
function FuelTrailer2:readUpdateStream(streamId, timestamp, connection)
end;
function FuelTrailer2:writeUpdateStream(streamId, connection, dirtyMask)
end;
function FuelTrailer2:update(dt)
end;
function FuelTrailer2:updateTick(dt)
    if self.isServer and self.isFuelFilling then
        local delta = 0;
        if self.fuelFillTrigger ~= nil then
            delta = self.fuelFillLitersPerSecond*dt*0.001;
            delta = self.fuelFillTrigger:fillFuel(self, delta);
        end
        if delta <= 0 then
            self:setIsFuelFilling(false);
        end
    end
end;
function FuelTrailer2:draw()
    if self.isClient then
        if self.fillLevel <= 0 and self:getCapacity() ~= 0 then
        -- g_currentMission:addExtraPrintText(g_i18n:getText("FirstFillTheTool"));
        end;
    end
end;
function FuelTrailer2:setIsFuelFilling(isFilling, noEventSend)
    if isFilling ~= self.isFuelFilling then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SteerableToggleRefuelEvent:new(self, isFilling), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(SteerableToggleRefuelEvent:new(self, isFilling));
            end;
        end;
        self.isFuelFilling = isFilling;
        if isFilling then
            -- find the first trigger which is activable
            self.fuelFillTrigger = nil;
            for i=1, table.getn(self.fuelFillTriggers) do
                local trigger = self.fuelFillTriggers[i];
                if trigger:getIsActivatable(self) then
                    self.fuelFillTrigger = trigger;
                    break;
                end;
            end;
        end
        if self.isClient and self.sampleRefuel ~= nil then
            if isFilling then
                Utils.play3DSample(self.sampleRefuel);
            else
                Utils.stop3DSample(self.sampleRefuel);
            end;
        end;
    end
end
function FuelTrailer2:addFuelFillTrigger(trigger)
    if table.getn(self.fuelFillTriggers) == 0 then
        g_currentMission:addActivatableObject(self.FuelTrailer2FillActivatable);
    end;
    table.insert(self.fuelFillTriggers, trigger);
end;
function FuelTrailer2:removeFuelFillTrigger(trigger)
    for i=1, table.getn(self.fuelFillTriggers) do
        if self.fuelFillTriggers[i] == trigger then
            table.remove(self.fuelFillTriggers, i);
            break;
        end;
    end;
    if table.getn(self.fuelFillTriggers) == 0 or trigger == self.fuelFillTrigger then
        if self.isServer then
            self:setIsFuelFilling(false);
        end;
        if table.getn(self.fuelFillTriggers) == 0 then
            g_currentMission:removeActivatableObject(self.FuelTrailer2FillActivatable);
        end
    end;
end;
FuelTrailer2FillActivatable = {}
local FuelTrailer2FillActivatable_mt = Class(FuelTrailer2FillActivatable);
function FuelTrailer2FillActivatable:new(trailer)
    local self = {};
    setmetatable(self, FuelTrailer2FillActivatable_mt);
    self.trailer = trailer;
    self.activateText = "unknown";
    return self;
end;
function FuelTrailer2FillActivatable:getIsActivatable()
    if self.trailer:getIsActiveForInput() and self.trailer:getFillLevel(Fillable.FILLTYPE_FUEL) < self.trailer:getCapacity() and self.trailer:allowFillType(Fillable.FILLTYPE_FUEL, false) then
        -- find the first trigger which is activable
        for i=1, table.getn(self.trailer.fuelFillTriggers) do
            local trigger = self.trailer.fuelFillTriggers[i];
            if trigger:getIsActivatable(self.trailer) then
                self:updateActivateText();
                return true;
            end
        end
    end
    return false;
end;
function FuelTrailer2FillActivatable:onActivateObject()
    self.trailer:setIsFuelFilling(not self.trailer.isFuelFilling);
    self:updateActivateText();
    g_currentMission:addActivatableObject(self);
end;
function FuelTrailer2FillActivatable:drawActivate()
  --  g_currentMission:enableHudIcon("refuel", 5);
end;
function FuelTrailer2FillActivatable:updateActivateText()
    if self.trailer.isFuelFilling then
        self.activateText = string.format(g_i18n:getText("stop_refill_OBJECT"), self.trailer.typeDesc);
    else
        self.activateText = string.format(g_i18n:getText("refill_OBJECT"), self.trailer.typeDesc);
    end;
end;