--
-- Addon for moveable Farmerarm
-- Addon für beweglichen Farmerarm
--
-- @author Aranea
-- @date  01/02/2013
-- @update  27/08/2014
--
-- @v1.0 basic
-- @v1.1 update
--
-- Copyright (C) Aranea, All Rights Reserved.
--

FarmerArm = {};

function FarmerArm.prerequisitesPresent(specializations)
	return true;
end;

function FarmerArm:load(xmlFile)
	self.leftArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#leftArm"));
	self.rightArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#rightArm"));
	self.body = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#body"));
end;

function FarmerArm:postLoad(xmlFile)
	if self.leftArm ~= nil then
		setVisibility(self.leftArm, false);
	end;
	if self.rightArm ~= nil then
		setVisibility(self.rightArm, false);
	end;
	if self.body ~= nil then
		setVisibility(self.body, false);
	end;
end;

function FarmerArm:delete()
end;

function FarmerArm:readStream(streamId, connection)
end;

function FarmerArm:writeStream(streamId, connection)
end;

function FarmerArm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FarmerArm:keyEvent(unicode, sym, modifier, isDown)
end;

function FarmerArm:update(dt)
end;

function FarmerArm:updateTick(dt)
end;

function FarmerArm:draw()
end;

function FarmerArm:onEnter()
	if self.leftArm ~= nil then
		setVisibility(self.leftArm, true);
	end;
	if self.rightArm ~= nil then
		setVisibility(self.rightArm, true);
	end;
	if self.body ~= nil then
		setVisibility(self.body, true);
	end;
end;

function FarmerArm:onLeave()
	if self.leftArm ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.leftArm, false);
		else
			setVisibility(self.leftArm, true);
		end;
	end;
	if self.rightArm ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.rightArm, false);
		else
			setVisibility(self.rightArm, true);
		end;
	end;
	if self.body ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.body, false);
		else
			setVisibility(self.body, true);
		end;
	end;
end;
