--
-- autor: Ziuta
-- date: 07.03.2015
-- version: 1.0
--
-- Written on the basis of MerloP417.lua
--

ChangeSter = {}

function ChangeSter.prerequisitesPresent(specializations)
    return true
end

function ChangeSter:load(xmlFile)
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode")
	self.changeWheel = 0
	self.warningTime = 0
end

function ChangeSter:delete()
end

function ChangeSter:mouseEvent(posX, posY, isDown, isUp, button)
end

function ChangeSter:keyEvent(unicode, sym, modifier, isDown)
end

function ChangeSter:update(dt)
	if self:getIsActive() then
		local x,y,z = getRotation(self.wheels[1].repr)	
		if InputBinding.hasEvent(InputBinding.WHEEL_MODE) then
			if y == 0 then
				self.changeWheel = self.changeWheel+1;
			else
				self.warningTime = g_currentMission.time + 1000
			end
		end
		
		if self.changeWheel == 0  then
			self:MPCode(0, 0)
		elseif self.changeWheel == 1  then
			self:MPCode(1, -70)
		elseif self.changeWheel == 2  then
			self:MPCode(2, 70)
		elseif self.changeWheel == 3 then
			self.changeWheel = 0
		end
	end
end

function ChangeSter:MPCode(state, angle, noEventSend)
	ChangeSterEvent.sendEvent(self, state, angle, noEventSend)
	
	self.wheels[3].rotSpeed = Utils.degToRad(angle)
	self.wheels[4].rotSpeed = Utils.degToRad(angle)
	if state == 0  then
		self.changeWheel = 0
	elseif state == 1  then
		self.changeWheel = 1
	elseif state == 2  then
		self.changeWheel = 2
	end
end

function ChangeSter:draw()
	if self.changeWheel == 0  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WHEEL_FRONT"), self.typeDesc), InputBinding.WHEEL_MODE)
	elseif self.changeWheel == 1  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WHEEL_ALL"), self.typeDesc), InputBinding.WHEEL_MODE)
	elseif self.changeWheel == 2  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("WHEEL_CRAB"), self.typeDesc), InputBinding.WHEEL_MODE)
	end
	if self.warningTime > g_currentMission.time then
		g_currentMission:addWarning(g_i18n:getText("warning"))
	end
end

function ChangeSter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.changeWheel = Utils.getNoNil(getXMLInt(xmlFile, key.."#changeWheel"),0)
	end	
	return BaseMission.VEHICLE_LOAD_OK
end

function ChangeSter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'changeWheel="'..tostring(self.changeWheel)..'"'
	return attributes
end

function ChangeSter:readStream(streamId, connection)
	self.changeWheel = streamReadInt8(streamId)
end

function ChangeSter:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.changeWheel)
end

--
-- MP
--

ChangeSterEvent = {}
ChangeSterEvent_mt = Class(ChangeSterEvent, Event)

InitEventClass(ChangeSterEvent, "ChangeSterEvent")

function ChangeSterEvent:emptyNew()
    local self = Event:new(ChangeSterEvent_mt)
    self.className="ChangeSterEvent"
    return self
end

function ChangeSterEvent:new(vehicle, state, angle)
    local self = ChangeSterEvent:emptyNew()
    self.vehicle = vehicle
	self.state = state
	self.angle = angle
    return self
end;

function ChangeSterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId)
	self.vehicle = networkGetObject(id)
	self.state = streamReadInt8(streamId)
	self.angle = streamReadFloat32(streamId)    
    self:run(connection)
end

function ChangeSterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle))
	streamWriteInt8(streamId, self.state)
	streamWriteFloat32(streamId, self.angle)
end

function ChangeSterEvent:run(connection)
	self.vehicle:MPCode(self.state, self.angle, true)
    if not connection:getIsServer() then
        g_server:broadcastEvent(ChangeSterEvent:new(self.vehicle, self.state, self.angle), nil, connection, self.vehicle)
    end
end

function ChangeSterEvent.sendEvent(vehicle, state, angle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeSterEvent:new(vehicle, state, angle), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(ChangeSterEvent:new(vehicle, state, angle))
		end
	end
end