--
-- JCBFastrac2140
-- Specialization for JCBFastrac2140
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		11/11/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--

JCBFastrac2140 = {};

function JCBFastrac2140.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JCBFastrac2140:load(xmlFile)
	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#back"));
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#front"));
	
	--[[self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;]]
end;

function JCBFastrac2140:delete()
end;

function JCBFastrac2140:readStream(streamId, connection)
end;

function JCBFastrac2140:writeStream(streamId, connection)
end;

function JCBFastrac2140:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JCBFastrac2140:keyEvent(unicode, sym, modifier, isDown)
end;

function JCBFastrac2140:update(dt)
	--[[if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then
						self.nextAction = false;
					end;
				end;
			end;
		end;
	end;]]
end;

function JCBFastrac2140:updateTick(dt)
	--[[if self:getIsActive() then
		if self.doLowering then
			local back = self.attacherJoints[1];
			local front = self.attacherJoints[2];
			if not self.loweringDone then
				self:setJointMoveDown(2, self.nextAction);
				self.loweringDone = true;
			end;
			if self.loweringDone then
				self.delay = self.delay - dt;
				if self.delay <= 0 then
					self:setJointMoveDown(1, self.nextAction);
					self.doLowering = false;
				end;
			end;
		end;
	end;]]
end;

function JCBFastrac2140:draw()
	--[[if self.implementCount == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;]]
end;

function JCBFastrac2140:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		--[[if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;]]
		-- index 1 defines back hydraulic
		if jointIndex == 1 then
			setVisibility(self.backAttacherJoint.node, false);
			setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, true);
		elseif jointIndex == 2 then
			setVisibility(self.frontAttacherJoint.node, false);
			setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 4 then
			setVisibility(self.frontAttacherJoint.node, true);
			setVisibility(self.attacherJoints[2].topArm.rotationNode, false);
		end;
		if jointIndex == 3 then
			setVisibility(self.backAttacherJoint.node, true);
			setVisibility(self.attacherJoints[1].topArm.rotationNode, false);
		end;
	end;
	--self.updateJoint = true;
end;

function JCBFastrac2140:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	--[[if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
	end;]]
	if jointIndex == 1 then
		setVisibility(self.backAttacherJoint.node, true);
		setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, false);
	elseif jointIndex == 2 then
		setVisibility(self.frontAttacherJoint.node, true);
		setVisibility(self.attacherJoints[jointIndex].topArm.rotationNode, false);
	end;
end;
--[[
function JCBFastrac2140:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;]]