-- Автор Кирюха
-- Версия 100116
-- http://vk.com/besedka_fermera

breakEngine = {};
breakEngine.modDir = g_currentModDirectory;

local break_level = 0;
local vis_distance = false;
local repair_state = false;
local hud_vis = true;

local px, py, pz;
local vx, vy, vzlocal minDistance = 4;
local distance;
local miltiplier_speed = 0;
local miltiplier_speed_back = 0;
local speed_temp_1;
local max_speed;
local text_max_speed;
local minFGR;
local rpmFactor = 0;
local fuelUsed = 0;

function breakEngine.prerequisitesPresent(specializations)
    return true;
end;

function breakEngine:load(xmlFile)
	self.engine_image_green = Overlay:new("engine_image_green", (breakEngine.modDir.."scripts/engine_green.dds"), 0.96, 0.13, 0.03, 0.03);
	self.engine_image_orange = Overlay:new("engine_image_orange", (breakEngine.modDir.."scripts/engine_orange.dds"), 0.96, 0.13, 0.03, 0.03);
	self.engine_image_red = Overlay:new("engine_image_red", (breakEngine.modDir.."scripts/engine_red.dds"), 0.96, 0.13, 0.03, 0.03);
	self.enterReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.enterReferenceNode#index"));
	
	local break_sound_file = Utils.getFilename("break.wav", breakEngine.modDir.."scripts/");
    self.break_sound = createSample("break_sound");
    loadSample(self.break_sound, break_sound_file, false);
	
	self.maxRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#maxRpm"));
	self.minForwardGearRatio = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minForwardGearRatio"));
end;

function breakEngine:delete()
end;

function breakEngine:mouseEvent(posX, posY, isDown, isUp, button)
end;

function breakEngine:keyEvent(unicode, sym, modifier, isDown)
	if Input.isKeyPressed(Input.KEY_n) then
		if hud_vis then
			hud_vis = false;
		else
			hud_vis = true;
		end;
	end;
end;

function breakEngine:update(dt)
	px, py, pz = getWorldTranslation(g_currentMission.player.rootNode);
	vx, vy, vz = getWorldTranslation(self.enterReferenceNode);
	distance = Utils.vector3Length(vx-px, vy-py, vz-pz);

	if distance < minDistance then
		if Input.isKeyPressed(Input.KEY_m) then
			if break_level > 0 then
				repair_state = true;
			end;
		end;
	end;
	if self.isMotorStarted then
		if break_level < 100 then
			break_level = break_level + 0.001;
		end;
	end;
	
	rpmFactor = math.max(0.02, (self.motor.lastMotorRpm-self.motor.minRpm)/(self.motor.maxRpm-self.motor.minRpm));
    fuelUsed = rpmFactor*(self.fuelUsage*dt);
	if break_level > 50 and break_level < 90 then
		fuelUsed = fuelUsed*2;
	end;
	if break_level > 90 and break_level < 99 then
		miltiplier_speed = break_level-90+1;
		fuelUsed = fuelUsed*4;
	elseif break_level > 99 then
		miltiplier_speed = 1000;
		self.motor.maxBackwardGearRatio = 0;
		self.motor.minBackwardGearRatio = 0;
		fuelUsed = fuelUsed*4;
	end;
	speed_temp_1 = self.maxRpm/self.minForwardGearRatio;
	max_speed = speed_temp_1*6.28/60*3.6;
	max_speed = math.ceil(max_speed);
	max_speed = max_speed/miltiplier_speed;
	max_speed = max_speed/3.6*60/6.28;
	minFGR = self.maxRpm/max_speed;
	self.motor.minForwardGearRatio = minFGR;
	self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
	
	if repair_state then
		if not self.isMotorStarted then 
			break_level = break_level - 0.01;
		end;
	end;
	if break_level <= 0 then
		repair_state = false;
	end;
	
	if g_currentMission.controlledVehicle == self then
		if hud_vis then
			local text_break_level;
			if break_level >= 100 then
				text_break_level = string.format("%d", break_level);
			elseif break_level < 100 and break_level >= 10 then
				text_break_level = string.format("0%d", break_level);
			elseif break_level < 10 then
				text_break_level = string.format("00%d", break_level);
			end;
			if break_level < 90 then
				setTextColor(0, 1, 0, 1);
			elseif break_level > 90 and break_level < 95 then
				setTextColor(1, 0.588, 0, 1);
			elseif break_level > 95 then
				setTextColor(1, 0, 0, 1);
			end;
			if break_level > 90 then
				renderText(0.35, 0.01, 0.012, "Для ремонта заглушить двигатель, выйти из машины и нажать 'M'");
			end;
			renderText(0.9685, 0.1386, 0.01, text_break_level);
		end;
		if self.isMotorStarted then
			if break_level > 90 then
				if not isSamplePlaying(self.break_sound, 1.5*dt) then
					playSample(self.break_sound, 1, 1, 0);
				end;
			elseif break_level > 10 then
				stopSample(self.break_sound);
			end;
		else
			stopSample(self.break_sound);
		end;
	else
		stopSample(self.break_sound);
	end;
end;

function breakEngine:draw()
	if hud_vis then
		if break_level < 90 then
			self.engine_image_green:render();
		elseif break_level > 90 and break_level < 95 then
			self.engine_image_orange:render();
		elseif break_level > 95 then
			self.engine_image_red:render();
		end;
	end;
end;