--
-- HardCodedRpm
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history:	v1.0 - 2015-01-05 - 
-- 

HardCodedRpm = {};

function HardCodedRpm.prerequisitesPresent(specializations)
    return true;
end;

function HardCodedRpm:load(xmlFile)
	self.getPtoRpm = Utils.overwrittenFunction(self.getPtoRpm, HardCodedRpm.getPtoRpm);
	self.getDoConsumePtoPower = Utils.overwrittenFunction(self.getDoConsumePtoPower, HardCodedRpm.getDoConsumePtoPower);
	
	self.workRpm = {};
	self.workRpm.rpm = 0;
	self.workRpm.releaseRpmTimer = 0;
	self.workRpm.maxTime = 200; -- how long rpm last after movingTool stopped
	self.workRpm.rpmOnLoad = 600; -- how high rpm will go when movingTool move
	self.workRpm.movingToolIds = {3, 4}; -- movingTool indice
end;

function HardCodedRpm:delete()
end;

function HardCodedRpm:readStream(streamId, connection)
end;

function HardCodedRpm:writeStream(streamId, connection)
end;

function HardCodedRpm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HardCodedRpm:keyEvent(unicode, sym, modifier, isDown)
end;

function HardCodedRpm:update(dt)
end;

function HardCodedRpm:updateTick(dt)
	if self:getIsActive() then
		local neededRpm = 0;
		local implementIndex = self:getImplementIndexByJointDescIndex(1);
		
		if implementIndex ~= nil then
			local obj = self.attachedImplements[implementIndex].object;
			
			if obj.getPtoRpm ~= nil then
				local rpm = obj:getPtoRpm()
				
				if rpm > 0 then
					neededRpm = self.workRpm.rpmOnLoad + rpm;
				end;
			end;
		end;
		
		if neededRpm == 0 then
			for _, toolId in ipairs(self.workRpm.movingToolIds) do
				local tool = self.movingTools[toolId];
				
				if tool.rotSpeed ~= nil then
					if tool.lastRotHistoryRPM == nil then
						tool.lastRotHistoryRPM = tool.curRot[tool.rotationAxis];
					end;
					
					if 0.00001 < math.abs(tool.lastRotHistoryRPM - tool.curRot[tool.rotationAxis]) then
						tool.lastRotHistoryRPM = tool.curRot[tool.rotationAxis];
						neededRpm = self.workRpm.rpmOnLoad;
					end;
				end;
				
				if tool.transSpeed ~= nil then
					if tool.lastTransHistoryRPM == nil then
						tool.lastTransHistoryRPM = tool.curTrans[tool.translationAxis];
					end;
					
					if 0.00001 < math.abs(tool.lastTransHistoryRPM - tool.curTrans[tool.translationAxis]) then
						tool.lastTransHistoryRPM = tool.curTrans[tool.translationAxis];
						neededRpm = self.workRpm.rpmOnLoad;
					end;
				end;
			end;
		end;
		
		if neededRpm > 0 then
			self.workRpm.rpm = neededRpm;
			self.workRpm.releaseRpmTimer = g_currentMission.time + self.workRpm.maxTime;
		else
			if g_currentMission.time > self.workRpm.releaseRpmTimer then
				self.workRpm.rpm = 0;
				self.workRpm.releaseRpmTimer = 0;
			end;
		end;
	end;
end;

function HardCodedRpm:draw()
end;

function HardCodedRpm:onLeave()
	self.workRpm.rpm = 0;
	self.workRpm.releaseRpmTimer = 0;
end;

function HardCodedRpm:getPtoRpm(oldFunc)
	return self.workRpm.rpm;
	
	-- local rpm = self.workRpm.rpm;
	
	-- if oldFunc ~= nil then
		-- rpm = rpm + oldFunc(self);
	-- end;
	
	-- return rpm;
end;

function HardCodedRpm:getDoConsumePtoPower(oldFunc)
	return self.workRpm.rpm > 0;
	
	-- if not consume and oldFunc ~= nil then
		-- return oldFunc(self);
	-- end;
	
	-- return consume;
end;