--------------------------------------------------------------------------------------
-- MOD: Inspector
-- MOD Author: edmund
-- MOD date: 26.1.2011
--
-- Copyright (C) edmund --
-- Contact via PM @ 
-- 1. http://planet-ls.de/board/index.php?page=User&userID=45283
-- 2. http://forum.landwirtschafts-simulator.de/memberlist.php?mode=viewprofile&u=9151
--------------------------------------------------------------------------------------
-- LS13 MOD: Inspector
-- by AusiMods
-----------------------------------
-- LS15 MOD: Inspector
-- by Gerol

Inspector = {};

function Inspector:loadMap(name)
	self.aPositions = {};
	local aNameSearch = {"vehicle.name." .. g_languageShort, "vehicle.name.en", "vehicle.name", "vehicle#type"};
	self.bDisplay = 1;
	
	if Steerable.load ~= nil then
		local orgSteerableLoad = Steerable.load
		
		Steerable.load = function(self,xmlFile)
			orgSteerableLoad(self,xmlFile)
			
			for nIndex,sXMLPath in pairs(aNameSearch) do 
				self.name = getXMLString(xmlFile, sXMLPath);
		
				if self.name ~= nil then 
					break; 
				end;
			end;
			if self.name == nil then 
				self.name = g_i18n:getText("UNKNOWN")
			end;
		end;
	end;
	
	if Attachable.load ~= nil then
		local orgAttachableLoad = Attachable.load
		
		Attachable.load = function(self,xmlFile)
			orgAttachableLoad(self,xmlFile)
			
			for nIndex,sXMLPath in pairs(aNameSearch) do 
				self.name = getXMLString(xmlFile, sXMLPath);
				if self.name ~= nil then
					break;
				end;
			end;
			if self.name == nil then 
				self.name = g_i18n:getText("UNKNOWN") 
			end;
		end
	end;
end;

function Inspector:deleteMap()
end;

function Inspector:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Inspector:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_a and bitAND(modifier, Input.MOD_ALT) > 0 then
		if self.bDisplay == 0 then 
			self.bDisplay = 1;
		else
			self.bDisplay = 0;
		end;
	end;
end;

function Inspector:update(dt)
end;

function Inspector:draw()
	if self.bDisplay == 0 then 
		return true; 
	end;
	
	if Input.keyPressedState[308] then
		return true;
	else
		local fPosX = 0.014;
		local fPosY = 0.60;
		local fFontSize = 0.014;
		local fLineDist = fFontSize + 0.002;
		setTextAlignment(RenderText.ALIGN_LEFT);
		local nLine = 0;
		
		local nVehicles = table.getn(g_currentMission.steerables);
				
		if nVehicles > 0 then
			for i=1,nVehicles do
				local oVehicle = g_currentMission.steerables[i];
				setTextBold(false);
				setTextColor(1,1,1,1);
				
				local sLineOutput = "";
				if oVehicle.isControlled then					
					if oVehicle.controllerName ~= nil then 
						sLineOutput = sLineOutput .. " (" .. string.sub(Utils.getNoNil(oVehicle.controllerName, g_i18n:getText("UNKNOWN")), 0, 15) .. ")"; 					
					end;
					
					if g_currentMission.controlledVehicle == oVehicle then
						setTextBold(true);
					end;
				end;
				
				sLineOutput = sLineOutput .. " " .. string.sub(oVehicle.name, 0, 50);		
				local bHasGrainInTankAttach = false;
				for nIndex,oImplement in pairs(oVehicle.attachedImplements) do
					if oImplement ~= nil and oImplement.object ~= nil then
						sLineOutput = sLineOutput .. " + " .. string.sub(oImplement.object.name, 0, 50);
														
						if oImplement.object.fillLevel ~= nil then
							if oImplement.object.fillLevel > 0 then
								bHasGrainInTankAttach = true;
								
								local nTankPercentage = oImplement.object.fillLevel / oImplement.object.capacity * 100;
								nTankPercentage = math.ceil(nTankPercentage * 10) / 10;
								
								if nTankPercentage > 100 then
									nTankPercentage = 100;
								end;
								if nTankPercentage < 0.1 then
									nTankPercentage = 0.1;
								end;
								
								local sFillType = "";
								if oImplement.object.currentFillType ~= nil then
									local aFruitType = FruitUtil.fillTypeToFruitType[oImplement.object.currentFillType];
									
									if aFruitType == nil then
										bHasGrainInTankAttach = false;
									end;
									
									sFillType = " " .. Fillable.fillTypeIndexToDesc[oImplement.object.currentFillType].nameI18N;
								end;
								
								sLineOutput = sLineOutput .. " (" .. string.format("%.1f", nTankPercentage) .. "%" .. sFillType .. ")";
																
								if nTankPercentage < 1 then
									nTankPercentage = 1;
								end;
																
								if nTankPercentage <= 65 then 
									setTextColor(0, nTankPercentage * -(0.5/65),0,1);
								elseif nTankPercentage > 90 then 
									setTextColor(1,((nTankPercentage - 90) * -(0.5/10)) + 0.5,0,1);
								elseif nTankPercentage > 65 then 
									setTextColor((nTankPercentage-65) * (1/25),0.5,0,1);
								end;
							end;
						end;
					end;					
				end;
				
				if oVehicle.isHired then 
					sLineOutput = sLineOutput .. " [H]";
					setTextColor(0,1,0,1);
				end;
				
				local bHasGrainInTank = false;
				if oVehicle.fillLevel ~= nil then
					if oVehicle.fillLevel > 0 then 
						bHasGrainInTank = true;
						local nTankPercentage = oVehicle.fillLevel / oVehicle.capacity * 100;
						nTankPercentage = math.ceil(nTankPercentage * 10) / 10;
						
						if nTankPercentage > 100 then
							nTankPercentage = 100;
						end;
						if nTankPercentage < 0.1 then
							nTankPercentage = 0.1;
						end;
						
						local sFillType = "";
						if oVehicle.currentFillType ~= nil then
							local aFruitType = FruitUtil.fillTypeToFruitType[oVehicle.currentFillType];
							
							if aFruitType == nil then
								bHasGrainInTank = false;
							end;
									
							sFillType = " " .. Fillable.fillTypeIndexToDesc[oVehicle.currentFillType].nameI18N;
						end;
												
						sLineOutput = sLineOutput .. " (" .. string.format("%.1f", nTankPercentage) .. "%" .. sFillType  .. ")";
						
						if nTankPercentage < 1 then
							nTankPercentage = 1;
						end;
						
						if nTankPercentage <= 65 then 
							setTextColor(0, nTankPercentage * -(0.5/65),0,1);
						elseif nTankPercentage > 90 then 
							setTextColor(1,((nTankPercentage - 90) * -(0.5/10)) + 0.5,0,1);
						elseif nTankPercentage > 65 then 
							setTextColor((nTankPercentage-65) * (1/25),0.5,0,1);
						end;
					end;
				end;
												
				if bHasGrainInTank or bHasGrainInTankAttach or oVehicle.isControlled or oVehicle.isHired then
					nLine = nLine + 1;
					renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, sLineOutput);
				end;
			end;
		end;
	end;
end;

addModEventListener(Inspector);
