HookLiftTrailer = {
	initSpecialization = function ()
		Vehicle.registerJointType("hookLift")

		return 
	end,
	prerequisitesPresent = function (specializations)
		return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and SpecializationUtil.hasSpecialization(Foldable, specializations)
	end
}
HookLiftTrailer.load = function (self, xmlFile)
	self.startTipping = HookLiftTrailer.startTipping
	self.stopTipping = HookLiftTrailer.stopTipping
	self.isTippingAllowed = HookLiftTrailer.isTippingAllowed
	self.getIsFoldAllowed = Utils.overwrittenFunction(self.getIsFoldAllowed, HookLiftTrailer.getIsFoldAllowed)
	self.hookJointLimits = AnimCurve:new(linearInterpolatorN)
	local i = 0

	while true do
		local key = string.format("vehicle.hookJointLimits.key(%d)", i)

		if not hasXMLProperty(xmlFile, key) then
			if i == 0 then
				self.hookJointLimits = nil
			end

			break
		end

		local t = getXMLFloat(xmlFile, key .. "#time")
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#rotLimit"))
		local tx, ty, tz = Utils.getVectorFromString(getXMLString(xmlFile, key .. "#transLimit"))
		rx = math.rad(Utils.getNoNil(rx, 0))
		ry = math.rad(Utils.getNoNil(ry, 0))
		rz = math.rad(Utils.getNoNil(rz, 0))
		tx = Utils.getNoNil(tx, 0)
		ty = Utils.getNoNil(ty, 0)
		tz = Utils.getNoNil(tz, 0)

		self.hookJointLimits:addKeyframe({
			v = {
				rx,
				ry,
				rz,
				tx,
				ty,
				tz
			},
			time = t
		})

		i = i + 1
	end

	self.checkHookJointLimits = false

	return 
end
HookLiftTrailer.delete = function (self)
	return 
end
HookLiftTrailer.mouseEvent = function (self, posX, posY, isDown, isUp, button)
	return 
end
HookLiftTrailer.keyEvent = function (self, unicode, sym, modifier, isDown)
	return 
end
HookLiftTrailer.update = function (self, dt)
	return 
end
HookLiftTrailer.updateTick = function (self, dt)
	if self.getIsActive(self) and self.attachedContainer ~= nil then
		local animTime = self.getAnimationTime(self, "unfoldHand")
		self.attachedContainer.object.allowsDetaching = 0.95 < animTime

		if (self.getIsAnimationPlaying(self, "unfoldHand") or self.checkHookJointLimits) and self.hookJointLimits ~= nil then
			local v = self.hookJointLimits:get(animTime)

			for i = 1, 3, 1 do
				setJointRotationLimit(self.attachedContainer.jointIndex, i - 1, true, -v[i], v[i])
				setJointTranslationLimit(self.attachedContainer.jointIndex, i + 2, true, -v[i + 3], v[i + 3])
			end

			self.checkHookJointLimits = false
		end
	end

	return 
end
HookLiftTrailer.draw = function (self)
	return 
end
HookLiftTrailer.attachImplement = function (self, implement)
	local object = implement.object

	if object.attacherJoint.jointType == Vehicle.JOINTTYPE_HOOKLIFT then
		local jointDesc = self.attacherJoints[implement.jointDescIndex]
		self.attachedContainer = {
			jointIndex = jointDesc.jointIndex,
			implement = implement,
			object = object
		}
		self.posDirectionText = "unload_container"
		self.negDirectionText = "load_container"
		self.aiLeftMarker = object.aiLeftMarker
		self.aiRightMarker = object.aiRightMarker
		self.aiBackMarker = object.aiBackMarker
		self.aiTrafficCollisionTrigger = object.aiTrafficCollisionTrigger
		self.aiNeedsLowering = object.aiNeedsLowering
		self.aiForceTurnNoBackward = object.aiForceTurnNoBackward
		self.aiTerrainDetailChannel1 = object.aiTerrainDetailChannel1
		self.aiTerrainDetailChannel2 = object.aiTerrainDetailChannel2
		self.aiTerrainDetailChannel3 = object.aiTerrainDetailChannel3
		self.aiTerrainDetailProhibitedMask = object.aiTerrainDetailProhibitedMask
		self.aiRequiredFruitType = object.aiRequiredFruitType
		self.aiRequiredMinGrowthState = object.aiRequiredMinGrowthState
		self.aiRequiredMaxGrowthState = object.aiRequiredMaxGrowthState
		self.aiProhibitedFruitType = object.aiProhibitedFruitType
		self.aiProhibitedMinGrowthState = object.aiProhibitedMinGrowthState
		self.aiProhibitedMaxGrowthState = object.aiProhibitedMaxGrowthState

		if self.attacherVehicle ~= nil then
			AITractor.updateToolsInfo(self.attacherVehicle)
		end
	end

	return 
end
HookLiftTrailer.detachImplement = function (self, implementIndex)
	if self.attachedContainer ~= nil then
		local implement = self.attachedImplements[implementIndex]
		jointDesc = self.attacherJoints[implement.jointDescIndex]

		if jointDesc.jointIndex == self.attachedContainer.jointIndex then
			self.posDirectionText = "unload_arm"
			self.negDirectionText = "load_arm"
			self.attachedContainer = nil
		end

		self.aiLeftMarker = nil
		self.aiRightMarker = nil
		self.aiBackMarker = nil
		self.aiTrafficCollisionTrigger = nil
		self.aiNeedsLowering = false
		self.aiForceTurnNoBackward = false
		self.aiTerrainDetailChannel1 = -1
		self.aiTerrainDetailChannel2 = -1
		self.aiTerrainDetailChannel3 = -1
		self.aiTerrainDetailProhibitedMask = 0
		self.aiRequiredFruitType = FruitUtil.FRUITTYPE_UNKNOWN
		self.aiRequiredMinGrowthState = 0
		self.aiRequiredMaxGrowthState = 0
		self.aiProhibitedFruitType = FruitUtil.FRUITTYPE_UNKNOWN
		self.aiProhibitedMinGrowthState = 0
		self.aiProhibitedMaxGrowthState = 0

		if self.attacherVehicle ~= nil then
			AITractor.updateToolsInfo(self.attacherVehicle)
		end
	end

	return 
end
HookLiftTrailer.startTipping = function (self)
	self.playAnimation(self, "unloading", 1, self.getAnimationTime(self, "unloading"), true)

	return 
end
HookLiftTrailer.stopTipping = function (self)
	self.playAnimation(self, "unloading", -2, self.getAnimationTime(self, "unloading"), true)

	return 
end
HookLiftTrailer.isTippingAllowed = function (self)
	return self.getAnimationTime(self, "unfoldHand") == 0
end
HookLiftTrailer.getIsFoldAllowed = function (self, superFunc)
	if 0 < self.getAnimationTime(self, "unloading") then
		return false
	end

	if superFunc ~= nil then
		return superFunc(self)
	end

	return true
end
HookLiftTrailer.aiTurnOn = function (self)
	if self.attachedContainer ~= nil and self.attachedContainer.object.aiTurnOn ~= nil then
		self.attachedContainer.object:aiTurnOn()
	end

	return 
end
HookLiftTrailer.aiTurnOff = function (self)
	if self.attachedContainer ~= nil and self.attachedContainer.object.aiTurnOff ~= nil then
		self.attachedContainer.object:aiTurnOff()
	end

	return 
end
HookLiftTrailer.aiLower = function (self)
	if self.attachedContainer ~= nil and self.attachedContainer.object.aiLower ~= nil then
		self.attachedContainer.object:aiLower()
	end

	return 
end
HookLiftTrailer.aiRaise = function (self)
	if self.attachedContainer ~= nil and self.attachedContainer.object.aiRaise ~= nil then
		self.attachedContainer.object:aiRaise()
	end

	return 
end
HookLiftTrailer.aiRotateLeft = function (self, force)
	if self.attachedContainer ~= nil and self.attachedContainer.object.aiRotateLeft ~= nil then
		self.attachedContainer.object:aiRotateLeft(force)
	end

	return 
end
HookLiftTrailer.aiRotateRight = function (self, force)
	if self.attachedContainer ~= nil and self.attachedContainer.object.aiRotateRight ~= nil then
		self.attachedContainer.object:aiRotateRight(force)
	end

	return 
end
HookLiftTrailer.aiInvertsMarkerOnTurn = function (self, turnLeft)
	if self.attachedContainer ~= nil and self.attachedContainer.object.aiInvertsMarkerOnTurn ~= nil then
		self.attachedContainer.object:aiInvertsMarkerOnTurn(turnLeft)
	end

	return 
end
HookLiftTrailer.loadFromAttributesAndNodes = function (self, xmlFile, key, resetVehicles)
	self.checkHookJointLimits = true

	return BaseMission.VEHICLE_LOAD_OK
end
HookLiftTrailer.getSaveAttributesAndNodes = function (self, nodeIdent)
	return "", nil
end
--[[local modFilename, isMod, isDlc, dlcsDirectoryIndex = Utils.removeModDirectory(g_currentModDirectory)

if not isDlc or g_currentModName ~= "pdlc_itRunnerPack" then
	HookLiftTrailer = nil
end]]
