ExtendedManureSpreader = {
	prerequisitesPresent = function (specializations)
		return SpecializationUtil.hasSpecialization(ManureSpreader, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations)
	end,
	load = function (self, xmlFile)
		self.manureSpreaderAnimation = getXMLString(xmlFile, "vehicle.manureSpreaderAnimation#name")

		if self.isClient then
			self.chainUVScrollParts = Utils.loadScrollers(self.components, xmlFile, "vehicle.chainUVScrollParts.chainUVScrollPart", {}, false)
			self.chainTurnedOnRotationNodes = Utils.loadRotationNodes(xmlFile, {}, "vehicle.turnedOnRotationNodes.turnedOnRotationNode", "chains", self.components)

			for _, scroller in pairs(self.chainUVScrollParts.nodes) do
				scroller.defaultScrollSpeed = scroller.scrollSpeed
			end

			for _, rotNode in pairs(self.chainTurnedOnRotationNodes.nodes) do
				rotNode.defaultRotSpeed = rotNode.rotSpeed
			end
		end

		self.chainSpeedScale = 1
		self.wasRevertAnimationRunning = false

		return 
	end,
	delete = function (self)
		return 
	end,
	mouseEvent = function (self, posX, posY, isDown, isUp, button)
		return 
	end,
	keyEvent = function (self, unicode, sym, modifier, isDown)
		return 
	end,
	update = function (self, dt)
		if self.isClient and self.manureSpreaderAnimation ~= nil then
			local isPlaying = self.getIsAnimationPlaying(self, self.manureSpreaderAnimation)

			Utils.updateRotationNodes(self, self.chainTurnedOnRotationNodes, dt*self.chainSpeedScale, isPlaying)
			Utils.updateScrollers(self.chainUVScrollParts, dt*self.chainSpeedScale, isPlaying)
		end

		return 
	end,
	updateTick = function (self, dt)
		if self.getIsActive(self) and self.manureSpreaderAnimation ~= nil then
			if self.wasRevertAnimationRunning then
				self.playAnimation(self, self.manureSpreaderAnimation, -0.2, self.getAnimationTime(self, self.manureSpreaderAnimation), true)

				self.wasRevertAnimationRunning = false
			end

			if self.getIsAnimationPlaying(self, self.manureSpreaderAnimation) then
				for _, deformer in pairs(self.fillVolumeDeformers) do
					deformer.deformerIsDirty = true
				end
			end
		end

		return 
	end,
	onDeactivate = function (self)
		if self.manureSpreaderAnimation ~= nil then
			self.wasRevertAnimationRunning = true

			self.stopAnimation(self, self.manureSpreaderAnimation, true)
		end

		return 
	end,
	draw = function (self)
		return 
	end,
	onTurnedOn = function (self, noEventSend)
		if self.manureSpreaderAnimation ~= nil then
			self.chainSpeedScale = self.sprayLitersPerSecond[Fillable.FILLTYPE_MANURE]/self.fillLevel

			self.playAnimation(self, self.manureSpreaderAnimation, self.chainSpeedScale, self.getAnimationTime(self, self.manureSpreaderAnimation), true)

			for _, scroller in pairs(self.chainUVScrollParts.nodes) do
				scroller.scrollSpeed = scroller.defaultScrollSpeed
			end

			for _, rotNode in pairs(self.chainTurnedOnRotationNodes.nodes) do
				rotNode.rotSpeed = rotNode.defaultRotSpeed
			end
		end

		return 
	end,
	onTurnedOff = function (self, noEventSend)
		if self.manureSpreaderAnimation ~= nil then
			local speedScale = -0.2
			self.chainSpeedScale = math.abs(speedScale)

			self.playAnimation(self, self.manureSpreaderAnimation, speedScale, self.getAnimationTime(self, self.manureSpreaderAnimation), true)

			for _, scroller in pairs(self.chainUVScrollParts.nodes) do
				scroller.scrollSpeed = -scroller.defaultScrollSpeed
			end

			for _, rotNode in pairs(self.chainTurnedOnRotationNodes.nodes) do
				rotNode.rotSpeed = -rotNode.defaultRotSpeed
			end
		end

		return 
	end
}
--[[local modFilename, isMod, isDlc, dlcsDirectoryIndex = Utils.removeModDirectory(g_currentModDirectory)

if not isDlc or g_currentModName ~= "pdlc_itRunnerPack" then
	ExtendedManureSpreader = nil
end]]
