-- by modelleicher
-- www.schwabenmodding.bplaced.net

TractorAnimations = {};

function TractorAnimations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function TractorAnimations:load(xmlFile)
	-- Zapfwellenstummel / Powershaft rotation
	self.stummelIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations#zapfwellenStummelIndex"));
	
	-- Temperaturzeiger / temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;

	-- Temperaturzeiger2 / temperature Display animation
	self.temperaturZeiger2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger2#zeigerIndex"));
	self.temperaturZeigerMaxRot2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger2#maxRotation"));
	self.tempCnt2 = 0;
	
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	self.blinkerLeuchte1L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte1L"));
	self.blinkerLeuchte1R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte1R"));
	self.blinkerLeuchte2L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte2L"));
	self.blinkerLeuchte2R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte2R"));
	self.hasAttachedTrailers = 0;
	setVisibility(self.blinkerLeuchte1L, false);
	setVisibility(self.blinkerLeuchte2L, false);
	setVisibility(self.blinkerLeuchte1R, false);
	setVisibility(self.blinkerLeuchte2R, false);
	
	
	-- Ladekontrollleuchte / Batterie load light
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 0;
	self.ladeTimer = 50;

	-- Hydraulic Handle
	self.PitchArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.PitchArm#Index"));
	self.PitchArmRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.PitchArm#refNode"));

	-- UpperLinkageRear --
	self.rearLinkage = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.RearLinkage#lowerLinkage"));
	self.rearLinkageTop = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.RearLinkage#upperLinkage"));
	self.rearLinkageMinRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.RearLinkage#minRotation"));
	self.rearLinkageMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.RearLinkage#maxRotation"));
	setVisibility(self.rearLinkageTop, false);
	
	-- Frontloader --
	self.loaderholder = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.Frontloader#holder"));
	self.FLJointIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TractorAnimations.Frontloader#FLJointIndex"));
	self.isFLAttached = false;

	-- IndoorCam --
	self.IndoorCam = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.IndoorCam#Index"));
	self.leanforward = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TractorAnimations.IndoorCam#leanforward"));
	self.leanback = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TractorAnimations.IndoorCam#leanback"));
	self.leanleft = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TractorAnimations.IndoorCam#leanleft"));
	self.leanright = Utils.getNoNil(getXMLString(xmlFile, "vehicle.TractorAnimations.IndoorCam#leanright"));
	self.CamMoved = 0;
	
end;
function TractorAnimations:delete()
end;
function TractorAnimations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function TractorAnimations:keyEvent(unicode, sym, modifier, isDown)
end;

function TractorAnimations:updateTick(dt)
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.lastFillDelta ~= nil then -- "catch" all trailers 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			elseif self.attachedImplements[i].object.isSprayerFilling ~= nil and self.attachedImplements[i].object.wheels[1] ~= nil then -- "catch" manure and dung spreader with wheels --> "trailers", too
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then -- maybe the trailer has also attached a trailer.. 
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.lastFillDelta ~= nil then -- "catch" attached trailer at the trailer here
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
		if self.hasAttachedTrailers == 0 then
			setVisibility(self.blinkerLeuchte1L, false);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, false);
			setVisibility(self.blinkerLeuchte2R, false);
		elseif self.hasAttachedTrailers == 1 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, false);			
		elseif self.hasAttachedTrailers == 2 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, true);	
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, true);			
		end;
	end;
	
	if self.PitchArm ~= nil then
		-- set correct rotation on PitchArm
		local x, y, z = getRotation(self.PitchArmRefNode);
		setRotation(self.PitchArm, x * (-1.5), y, z);	
	end;

end;
function TractorAnimations:update(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 50;
				end;
			end;
			
			-- Zapfwellenstummel / Powershaft rotation
			rotate(self.stummelIndex, 0,0,0.001*dt);
			
			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
			if self.tempCnt2 < 3000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = self.tempCnt2 + 0.8;
			elseif self.tempCnt2 > 3000 and self.tempCnt2 < 6000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.3, 10000);			
			else
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.04, 10000);
			end;
		end;
		-- IndoorCam --
		if self.isEntered and self.camIndex == 2 then
			if self.CamMoved == 0 then
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_forward"), InputBinding.lean_forward);
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_back"), InputBinding.lean_back);
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_left"), InputBinding.lean_left);
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_right"), InputBinding.lean_right);
			elseif self.CamMoved == 1 then
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_center"), InputBinding.lean_forward);
			elseif self.CamMoved == 2 then
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_center"), InputBinding.lean_back);
			elseif self.CamMoved == 3 then
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_center"), InputBinding.lean_left);
			elseif self.CamMoved == 4 then
				g_currentMission:addHelpButtonText(g_i18n:getText("lean_center"), InputBinding.lean_right);
			end;
			if self.IndoorCam ~= nil then
				if InputBinding.hasEvent(InputBinding.lean_forward) then
					if self.CamMoved == 0 then
						self:playAnimation(self.leanforward, 1, nil, true);
						self.CamMoved = 1;
					elseif self.CamMoved == 1 then
						self:playAnimation(self.leanforward, -1, nil, true);
						self.CamMoved = 0;
					end;
				end;
				if InputBinding.hasEvent(InputBinding.lean_back) then
					if self.CamMoved == 0 then
						self:playAnimation(self.leanback, 1, nil, true);
						self.CamMoved = 2;
					elseif self.CamMoved == 2 then
						self:playAnimation(self.leanback, -1, nil, true);
						self.CamMoved = 0;
					end;
				end;
				if InputBinding.hasEvent(InputBinding.lean_left) then
					if self.CamMoved == 0 then
						self:playAnimation(self.leanleft, 1, nil, true);
						self.CamMoved = 3;
					elseif self.CamMoved == 3 then
						self:playAnimation(self.leanleft, -1, nil, true);
						self.CamMoved = 0;
					end;
				end;
				if InputBinding.hasEvent(InputBinding.lean_right) then
					if self.CamMoved == 0 then
						self:playAnimation(self.leanright, 1, nil, true);
						self.CamMoved = 4;
					elseif self.CamMoved == 4 then
						self:playAnimation(self.leanright, -1, nil, true);
						self.CamMoved = 0;
					end;
				end;
			end;
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
		self.tempCnt2 = math.max(self.tempCnt2 - 0.1, 0);
	end;
	if self:getIsActiveForInput() then
		-- Frontloaderholder --
		if self.camIndex == 1 then
			if getVisibility(self.loaderholder) == true then
				if self.isFLAttached == false then
					g_currentMission:addHelpButtonText(g_i18n:getText("Frontloaderholder_disassemble"), InputBinding.Frontloaderholder_assemble);
					if InputBinding.hasEvent(InputBinding.Frontloaderholder_assemble) then
						setVisibility(self.loaderholder, false);
						setRotation(self.loaderholder, 180, 0, 0);
					end;
				end;
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("Frontloaderholder_assemble"), InputBinding.Frontloaderholder_assemble);
				if InputBinding.hasEvent(InputBinding.Frontloaderholder_assemble) then
					setVisibility(self.loaderholder, true);
					setRotation(self.loaderholder, 0, 0, 0);
				end;
			end;
		end;
	end;
end;
function TractorAnimations:draw()
end;

function TractorAnimations:onEnter()
	self.ladeLeuchteOn = 1;
end;
function TractorAnimations:onLeave()
	self.ladeLeuchteOn = 0;
end;

function TractorAnimations:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			if self.rearLinkageTop ~= nil then
				setVisibility(self.rearLinkageTop, true);
			end;
		end;
	end;
	if jointIndex == self.FLJointIndex then
		self.isFLAttached = true;
	end;
end;

function TractorAnimations:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	local jointType = implement.object.attacherJoint.jointType;
		
	if jointIndex == 1 then
		if self.rearLinkageTop ~= nil then
			setVisibility(self.rearLinkageTop, false);
		end;
	end;
	if jointIndex == self.FLJointIndex then
		self.isFLAttached = false;
	end;
end;