--
-- improvedSilageBunker
-- 
-- 
--
-- upsideDown project start: 11.02.2014

-- release V1.0 22.02.2014
-- save/load fix V1.01 22.02.2014

-- V1.1: bulletproof against "manuelle siloplane"; filling with grass(_windrow!) fixed.

-- V1.2 minor bugfixes, added grass-silage and high-nutrition mix with potatoes
-- date: 11.05.2014
-- V2.0 converted to LS15; changes in load order, terminal heaps are kept less steep, slight increase in original spreading by driving, shader colors adjusted to new texture
-- 

g_i18n.globalI18N.texts["compactingLocal"]    = g_i18n:getText("compactingLocal");
g_i18n.globalI18N.texts["compactingIsRotten"] = g_i18n:getText("compactingIsRotten");
g_i18n.globalI18N.texts["compactingTooMuch1"] = g_i18n:getText("compactingTooMuch1");
g_i18n.globalI18N.texts["compactingTooMuch2"] = g_i18n:getText("compactingTooMuch2");
g_i18n.globalI18N.texts["compactingTooMuch3"] = g_i18n:getText("compactingTooMuch3");
g_i18n.globalI18N.texts["open_silo"]          = g_i18n:getText("open_silo");
g_i18n.globalI18N.texts["re_blanket_silo"]          = g_i18n:getText("re_blanket_silo");


improvedSilageBunker = {};
addModEventListener(improvedSilageBunker);

function improvedSilageBunker:loadMap(name)
	print("--- loading siloExtension mod V2.0 --- (by upsidedown)")

	-- BunkerSilo.update = improvedSilageBunker.NEWupdate;
	-- BunkerSilo.setMovingPlaneFillLevel = improvedSilageBunker.NEWsetMovingPlaneFillLevel;
	-- BunkerSilo.addShovelFillLevel = improvedSilageBunker.NEWaddShovelFillLevel;
	-- BunkerSilo.setTrailerFillDelta = improvedSilageBunker.NEWsetTrailerFillDelta;
	-- BunkerSilo.getAllowShovelFillType = improvedSilageBunker.NEWgetAllowShovelFillType;
	-- BunkerSilo.setState = improvedSilageBunker.NEWsetState;
	-- BunkerSilo.getCanCloseSilo = improvedSilageBunker.NEWgetCanCloseSilo;
	-- BunkerSilo.setFillDeltaAt = improvedSilageBunker.NEWsetFillDeltaAt;
	-- BunkerSilo.calculateSilagePlaneMoveAlphaMax = improvedSilageBunker.NEWcalculateSilagePlaneMoveAlphaMax;
	-- BunkerSilo.setPlaneShader = improvedSilageBunker.NEWsetPlaneShader;
	-- BunkerSilo.getCanInteract = improvedSilageBunker.NEWgetCanInteract;
	-- BunkerSilo.loadFromAttributesAndNodes = improvedSilageBunker.NEWloadFromAttributesAndNodes;
	-- BunkerSilo.getSaveAttributesAndNodes = improvedSilageBunker.NEWgetSaveAttributesAndNodes;
	-- BunkerSilo.readUpdateStream = improvedSilageBunker.NEWreadUpdateStream;
	-- BunkerSilo.writeUpdateStream = improvedSilageBunker.NEWwriteUpdateStream;
	-- BunkerSilo.readStream = improvedSilageBunker.NEWreadStream;
	-- BunkerSilo.writeStream = improvedSilageBunker.NEWwriteStream;
	
	-- BunkerSiloActivatable.getIsActivatable = improvedSilageBunker.BSAgetIsActivatable; 
	-- BunkerSiloActivatable.updateActivateText = improvedSilageBunker.BSAupdateActivateText;
	-- BunkerSiloActivatable.onActivateObject = improvedSilageBunker.BSAonActivateObject;
	
	-- BunkerSiloShovelTrigger.fillShovel = improvedSilageBunker.BSTTfillShovel;
end;

function improvedSilageBunker:deleteMap()
end


function improvedSilageBunker:mouseEvent(posX, posY, isDown, isUp, button)
end;

function improvedSilageBunker:keyEvent(unicode, sym, modifier, isDown)
end;


function improvedSilageBunker:update(dt)
	--if g_currentMission.isRunning and g_gui.currentGui == nil then
	-- if g_currentMission.controlPlayer then
		-- if g_currentMission.player ~= nil then
end


function improvedSilageBunker:draw()   
end;

function improvedSilageBunker:NEWgetCanInteract()
    if (g_currentMission.controlPlayer and self.playerInRange) then
        return true;
    end;
    if not g_currentMission.controlPlayer then
        for vehicle in pairs(self.vehiclesInRange) do
            if vehicle:getIsActiveForInput() then
                return true;
            end;
        end;
    end;
    return false;
end;




function improvedSilageBunker:NEWupdate(dt)
	if self.improvedSilageBunkerInitDone == nil or not self.improvedSilageBunkerInitDone then
		for k,trigger in pairs(self.tipTriggers) do
			trigger.acceptedFillTypes[Fillable.FILLTYPE_POTATO] = true;
			trigger.priceMultipliers[Fillable.FILLTYPE_POTATO] = Utils.getNoNil(trigger.defaultPriceMultiplier, 0);
		end;-- funktioniert, vllt spter erst ab einem gewissen fllstand erlauben
		
		self.improvedSilageBunkerInitDone = true;
	end;


    self.showMovingPlaneFullWarningTimer = self.showMovingPlaneFullWarningTimer - dt;

    if self:getCanInteract() then
        if self.showMovingPlaneFullWarningTimer > 0 then
            g_currentMission:addWarning(g_i18n:getText("Here_is_no_space"), 0.018, 0.033);
        end;

        if self.state == BunkerSilo.STATE_FILL then
            g_currentMission:addExtraPrintText(g_i18n:getText("fill_level").." "..math.floor(self.fillLevel).." ("..math.floor(100*self.fillLevel/self.capacity).."%)");
            local compactedPercentage = 0;
            if self.fillLevel > 0 then
                compactedPercentage = math.min(self.compactedFillLevel/self.fillLevel, 1);
            end;
            g_currentMission:addExtraPrintText(g_i18n:getText("compacting").." "..math.floor(100*compactedPercentage).."%");
			
			if self.lastPlaneCompactionLevel ~= nil and self.lastPlaneCompactionLevel >= 0 then
				g_currentMission:addExtraPrintText(g_i18n:getText("compactingLocal").." "..math.floor(100*self.lastPlaneCompactionLevel).."%");
			end;
			
			if self.lastRottenState then
				g_currentMission:addExtraPrintText(g_i18n:getText("compactingIsRotten"));
			elseif self.tooMuchEffectScale ~= nil then
				if self.tooMuchEffectScale > 0.1 and self.tooMuchEffectScale <= 0.5 then
					g_currentMission:addExtraPrintText(g_i18n:getText("compactingTooMuch1")); 
				elseif self.tooMuchEffectScale > 0.5 and self.tooMuchEffectScale <= 0.75 then
					g_currentMission:addExtraPrintText(g_i18n:getText("compactingTooMuch2"));
				elseif self.tooMuchEffectScale > 0.75 then
					g_currentMission:addExtraPrintText(g_i18n:getText("compactingTooMuch3"));
				end;
			end;
			--
			
        elseif self.state == BunkerSilo.STATE_CLOSED then
            g_currentMission:addExtraPrintText(g_i18n:getText("fermenting").." "..math.floor(100*math.min(self.fermentingTime/self.fermentingDuration,1)).."%");
        elseif self.state == BunkerSilo.STATE_DRAIN then
            g_currentMission:addExtraPrintText(g_i18n:getText("fill_level").." "..math.floor(self.fillLevel).." ("..math.floor(100*self.fillLevel/self.capacity).."%)");
        end;
    end;
    if self.state == BunkerSilo.STATE_CLOSED then
        if self.silagePlaneId ~= nil then
            if self.silagePlaneMoveAlpha < self.silagePlaneMoveAlphaMax then
                self.silagePlaneMoveAlpha = math.min(self.silagePlaneMoveAlpha + dt/self.silagePlaneMoveDuration, self.silagePlaneMoveAlphaMax);
                local x,_,z = getTranslation(self.silagePlaneId);
                setTranslation(self.silagePlaneId, x, self.silagePlaneMinY + self.silagePlaneMoveAlpha*(self.silagePlaneMaxY- self.silagePlaneMinY), z);
            end;
        end;
        self.fermentingTime = self.fermentingTime + dt*0.001*g_currentMission.missionStats.timeScale;
        if self.isServer then
            if self.fermentingTime >= self.fermentingDuration then
                --self:setState(BunkerSilo.STATE_DRAIN);
            end;
        else
            self.fermentingTime = math.min(self.fermentingTime, self.fermentingDuration);
        end;
    elseif self.state == BunkerSilo.STATE_DRAIN then
		-- if self.lastRottenState then
			-- g_currentMission:addExtraPrintText(g_i18n:getText("compactingIsRotten"));
		-- end;
        if self.isServer then 
            if self.fillLevel < table.getn(self.movingPlanes)*100+250 then                
				for _,movingPlane in pairs(self.movingPlanes) do
					if movingPlane.isRotten then
						movingPlane.isRotten = false;						
					end;					
				end;
				self:setState(BunkerSilo.STATE_FILL);
            end;
        end;
    end;

    if self.isServer then
		for i,movingPlane in pairs(self.movingPlanes) do
			--print(i,"-",movingPlane.fillLevel,"-",movingPlane.openRottingCounter)
			movingPlane.openRottingCounter = Utils.getNoNil(movingPlane.openRottingCounter,0);
			movingPlane.isRotten = Utils.getNoNil(movingPlane.isRotten,false)
			if movingPlane.fillLevel > 8000 then
				if self.state == BunkerSilo.STATE_FILL then
					movingPlane.randomCheckDone = false;
					if not movingPlane.isRotten then
						local compFactor = 1 - 0.5*(movingPlane.compactFillLevel/movingPlane.fillLevel);
						movingPlane.openRottingCounter = Utils.getNoNil(movingPlane.openRottingCounter,0) + dt*compFactor*g_currentMission.missionStats.timeScale*g_currentMission.missionStats.difficulty/1000;
					end;
				elseif BunkerSilo.STATE_CLOSED then
					local compaction = Utils.getNoNil(movingPlane.compactFillLevel,0)/movingPlane.fillLevel;
					if compaction < 0.98 or true then --old condition, replaced by randomCheck
						if self.fermentingTime > self.fermentingDuration/4 then-- give the cover plane some time to come up
							--movingPlane.isRotten = true;
							if not Utils.getNoNil(movingPlane.randomCheckDone,false) then
								movingPlane.randomCheckDone = true;
								local p = (1-compaction)*1*g_currentMission.missionStats.difficulty + g_currentMission.missionStats.difficulty*0.01;
								if math.random() < p then
									movingPlane.isRotten = true;
								end;
							end;
							
						end;
					end;
				else
					movingPlane.openRottingCounter = 0;
				end;
				local rottenTime = 3600*24*6; --6 days on easy, 3 on normal, 2 days on hard
				if movingPlane.openRottingCounter > rottenTime then 
					if not movingPlane.isRotten then
						movingPlane.isRotten = true;
						self:setState(BunkerSilo.STATE_DRAIN);--self:setState(BunkerSilo.STATE_FILL);
						self:setState(BunkerSilo.STATE_FILL);
					end;
				end;
			else
				movingPlane.openRottingCounter = 0;
				if movingPlane.isRotten then
					movingPlane.isRotten = false;
					if self.state == BunkerSilo.STATE_FILL then
						setShaderParameter(movingPlane.nodeId, "colorScale", 1.0, 1.0, 1.0, 0, false);
					else
						if Utils.getNoNil(movingPlane.isRotten,false) then 
							BunkerSilo:setPlaneShader(movingPlane,"ROTTEN")
						else
							BunkerSilo:setPlaneShader(movingPlane,"SILAGE")
						end;
					end;
				end;
			end;
		end;

        if self.state == BunkerSilo.STATE_FILL then		
            for vehicle,_ in pairs(self.compactingVehicles) do
                if vehicle:getIsActive() then
                    local distance = vehicle.lastMovedDistance;
					
                    if distance > 0 then
                        local refNode = vehicle.bunkerSiloCompactingRefNode;
                        if refNode == nil then
                            refNode = vehicle.components[1].node;
                        end;
                        local scale = Utils.getNoNil(vehicle.bunkerSiloCompactingScale, 1);
						scale = Utils.clamp(scale,1.0,6.0/math.sqrt(g_currentMission.missionStats.difficulty)); -- sry, there is a limit guys... this mod is about making silage something of a driving challenge.
						scale = scale/math.sqrt(g_currentMission.missionStats.difficulty);
                        local deltaCompact = distance*scale*self.distanceToCompactedFillLevel;

                        local x,y,z = getWorldTranslation(refNode);
                        -- find the moving plane that is nearest
                        local nearestDistance = math.huge;
                        local nearestPlaneI = 1;
                        for i,movingPlane in pairs(self.movingPlanes) do
                            local wx,_,wz = getWorldTranslation(movingPlane.nodeId);
                            local distance = (wx-x)*(wx-x) + (wz-z)*(wz-z);
                            if distance < nearestDistance then
                                nearestPlaneI = i;
                                nearestDistance = distance;
                            end;
                        end;
                        local nearestPlane = self.movingPlanes[nearestPlaneI];
						nearestPlane.compactFillLevel = Utils.getNoNil(nearestPlane.compactFillLevel,0);
						--- compact planes individually:
						local oneGoAmount = 25000;
						local minCompactScale = {.5,.25,.1};
						
						local tooMuchFactor = 1.0;
						
						
						local difficulty = g_currentMission.missionStats.difficulty;
						if (nearestPlane.fillLevel - nearestPlane.compactFillLevel) > oneGoAmount then
							local span = 5 - difficulty;
							tooMuchFactor = 1 - (nearestPlane.fillLevel - nearestPlane.compactFillLevel)/(span*oneGoAmount)
						end;
						tooMuchFactor = Utils.clamp(tooMuchFactor,minCompactScale[difficulty],1.0);
						
						deltaCompact = tooMuchFactor * deltaCompact;
						
						self.tooMuchEffectScale = (1-tooMuchFactor)/(1-minCompactScale[difficulty]); -- goes between 0 (full compacting) to 1 (minimum compacting)
						
						nearestPlane.compactFillLevel = math.min(Utils.getNoNil(nearestPlane.compactFillLevel,0)+deltaCompact,nearestPlane.fillLevel);
						local compSum = 0;
						for i,movingPlane in pairs(self.movingPlanes) do
							compSum = compSum + Utils.getNoNil(movingPlane.compactFillLevel,0);
						end;
						self.compactedFillLevel = compSum;
						
						self.lastPlaneCompactionLevel = nearestPlane.compactFillLevel/nearestPlane.fillLevel;
						if nearestPlane.fillLevel < 0.1 then
							self.lastPlaneCompactionLevel = -1;
						end;
						self.lastRottenState = Utils.getNoNil(nearestPlane.isRotten,false);
						---
						
                        local plane1;
                        local plane2;
                        local delta1 = 0;
                        local delta2 = 0;
                        if nearestPlaneI > 1 then
                            plane1 = self.movingPlanes[nearestPlaneI-1];
                            delta1 = Utils.clamp(nearestPlane.fillLevel - plane1.fillLevel, 0, plane1.capacity - plane1.fillLevel);
                        end;
                        if nearestPlaneI < table.getn(self.movingPlanes) then
                            plane2 = self.movingPlanes[nearestPlaneI+1];
                            delta2 = Utils.clamp(nearestPlane.fillLevel - plane2.fillLevel, 0, plane2.capacity - plane2.fillLevel);
                        end;
                        local delta = delta1 + delta2;
                        if delta > 0 then

                            local maxDelta = math.min(distance*self.distanceToCompactedFillLevel*4, nearestPlane.fillLevel);
                            local deltaScale = math.min(delta*0.5, maxDelta)/delta; -- *0.5 because we want to match both planes in the middle
                            
							--
							--local damping_factor = 0.01;
							local damping_factor = 0.2 + (3-g_currentMission.missionStats.difficulty)*0.1;
							
							if vehicle.bunkerSiloCompactingScaleOnContact ~= nil then --support for Reck Verteiler by katsuo
								if vehicle.bunkerSiloCompactingScaleOnContact == vehicle.bunkerSiloCompactingScale and vehicle.isTurnedOn then
									damping_factor = damping_factor + 1.1;									
								end;
							end;
							
							deltaScale = deltaScale*damping_factor;
							
							delta1 = delta1*deltaScale;
                            delta2 = delta2*deltaScale;
							
                            self:setMovingPlaneFillLevel(nearestPlane, nearestPlane.fillLevel - delta1 - delta2, false);
                            if plane1 ~= nil and delta1 > 0 then
                                self:setMovingPlaneFillLevel(plane1, plane1.fillLevel + delta1, false);
                            end;
                            if plane2 ~= nil and delta2 > 0 then
                                self:setMovingPlaneFillLevel(plane2, plane2.fillLevel + delta2, false);
                            end;
                        end;

						
                    end;
                end;
            end;
        end;
    end;

    -- for chaff tutorial: always take the highest fill level of all bunker silos
    if g_currentMission ~= nil and g_currentMission.bunkerScore ~= nil then
        if g_currentMission.bunkerScore < self.fillLevel then
            g_currentMission.bunkerScore = self.fillLevel;
        end;
    end;
end;



function improvedSilageBunker:NEWsetMovingPlaneFillLevel(movingPlane, fillLevel, addWarnings)
    local oldFillLevel = movingPlane.fillLevel;
    local newFillLevel = fillLevel;

    if newFillLevel > movingPlane.capacity then
        newFillLevel = movingPlane.capacity;

        if addWarnings then
            self.showMovingPlaneFullWarningTimer = self.warningTimerTime;
            if self.isServer then
                self:raiseDirtyFlags(self.bunkerSiloDirtyFlag);
            end;
        end;
    end;
    if newFillLevel < 0 then
        newFillLevel = 0;
    end;

    local deltaFillLevel = newFillLevel - movingPlane.fillLevel;
    if deltaFillLevel > self.capacity - self.fillLevel then
        -- limit the delta such that the total fill level is not over the capacity
        deltaFillLevel = self.capacity - self.fillLevel;
    end;
    movingPlane.fillLevel = movingPlane.fillLevel + deltaFillLevel;
	movingPlane.compactFillLevel = math.min(Utils.getNoNil(movingPlane.compactFillLevel,0),movingPlane.fillLevel);

    local totalFillLevel = 0;
    for _,p in pairs(self.movingPlanes) do
        totalFillLevel = totalFillLevel + p.fillLevel;
    end;
    self.fillLevel = Utils.clamp(totalFillLevel, 0, self.capacity);
	local compSum = 0;
	for i,movingPlane in pairs(self.movingPlanes) do
		compSum = compSum + Utils.getNoNil(movingPlane.compactFillLevel,0);
	end;
	self.compactedFillLevel = compSum;
	
	
		-- local alpha = movingPlane.fillLevel/movingPlane.capacity; --old code for ref
		-- we only change the calculation of alpha:
	local alpha = (Utils.getNoNil(movingPlane.compactFillLevel,0) + (movingPlane.fillLevel-math.min(Utils.getNoNil(movingPlane.compactFillLevel,0),movingPlane.fillLevel))*2)/movingPlane.capacity;
	
	alpha = Utils.clamp(alpha,0,1.0); --better safe than sorry...
	
	--test code:
	local planeIndex = 0;
	for i,plane in pairs(self.movingPlanes) do
		if plane == movingPlane then
			planeIndex = i;
		end;
	end;
	
	if planeIndex == 1 or planeIndex == table.getn(self.movingPlanes) then
		alpha = Utils.clamp(alpha,0,0.5);
		--print("end cap capped... ;p")
	end;
	
    movingPlane.y = self.movingPlanesMinY + (alpha^self.movingPlanesYPower) * (self.movingPlanesMaxY - self.movingPlanesMinY);
    setTranslation(movingPlane.nodeId, movingPlane.x, movingPlane.y, movingPlane.z);

    if self.isServer then
        setTranslation(movingPlane.shovelTrigger.nodeId , 0, math.max(self.shovelTriggersMinY-movingPlane.y, 0), 0);
    end;
end;

function improvedSilageBunker:NEWaddShovelFillLevel(shovel, fillLevelDelta, fillType)
    if fillType == Fillable.FILLTYPE_SILAGE or true then
        local oldFillLevel = self.fillLevel;

        local x,y,z = 0,0,0;
        if shovel.shovelTipReferenceNode ~= nil then
            x,y,z = getWorldTranslation(shovel.shovelTipReferenceNode);
        end;
        self:setFillDeltaAt(x,y,z, fillLevelDelta, true,fillType); --change for different fill types etc

        return self.fillLevel - oldFillLevel;
    end;
    return 0;
end;


function improvedSilageBunker:NEWsetTrailerFillDelta(trailer, trailerFillDelta, fillType)
    if trailerFillDelta < 0 then
        local x,y,z;
        if trailer.tipReferencePoints ~= nil and trailer.tipReferencePoints[trailer.currentTipReferencePointIndex] ~= nil then
            x,y,z = getWorldTranslation(trailer.tipReferencePoints[trailer.currentTipReferencePointIndex].node);
        else
            x,y,z = getWorldTranslation(trailer.components[1].node);
        end
        self:setFillDeltaAt(x,y,z, -trailerFillDelta, true,fillType);
    end;
end;

function improvedSilageBunker:BSTTfillShovel(shovel, dt) --BunkerSiloShovelTrigger:fillShovel BSTTfillShovel
    if (self.bunkerSilo.state == BunkerSilo.STATE_DRAIN or self.bunkerSilo.state == BunkerSilo.STATE_FILL) and self.movingPlane.fillLevel > 0 then
        local fillLevel = self.movingPlane.fillLevel;
        local delta = 0;
		if Utils.getNoNil(self.movingPlane.isRotten,false) then
			if shovel.currentFillType == Fillable.FILLTYPE_MANURE or (shovel.fillLevel/shovel.capacity < 0.05 and shovel.fillLevel < 1000) then
				delta = shovel:fillShovelFromTrigger(self, math.max(fillLevel - 0*1000,0), Fillable.FILLTYPE_MANURE, dt);
			end;
		else
			if self.bunkerSilo.state == BunkerSilo.STATE_FILL then
				fillLevel = math.max(fillLevel - 0*1000,0);
				local fillType = Fillable.FILLTYPE_CHAFF;
				local grass = Utils.getNoNil(self.movingPlane.fractionGrass,0);
				local potato = Utils.getNoNil(self.movingPlane.fractionPotato,0);
				if grass > 0.5 then
					fillType = Fillable.FILLTYPE_DRYGRASS_WINDROW;
				end;
				if shovel.currentFillType == fillType or (shovel.fillLevel/shovel.capacity < 0.05 and shovel.fillLevel < 1000) then
					delta = shovel:fillShovelFromTrigger(self, fillLevel, fillType, dt);
				end;
				if fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW and delta == 0 then
					fillType = Fillable.FILLTYPE_GRASS_WINDROW;
					if shovel.currentFillType == fillType or (shovel.fillLevel/shovel.capacity < 0.05 and shovel.fillLevel < 1000) then
						delta = shovel:fillShovelFromTrigger(self, fillLevel, fillType, dt);
					end;
				end;
			elseif self.bunkerSilo.state == BunkerSilo.STATE_DRAIN then
				local fillType = Fillable.FILLTYPE_SILAGE;
				local grass = Utils.getNoNil(self.movingPlane.fractionGrass,0);
				local potato = Utils.getNoNil(self.movingPlane.fractionPotato,0);
				
				if grass > 0.5 then
					fillType = Fillable.FILLTYPE_DRYGRASS_WINDROW;
				elseif grass < 0.2 and potato > 0.1 and potato < 0.4 then
					fillType = Fillable.FILLTYPE_FORAGE;
				end;
				
				local isMixerAndOk = false;
				if shovel.fillTypeToMixerWagonFillType ~= nil then
					local mixerWagonFillType = shovel.fillTypeToMixerWagonFillType[fillType];
					if mixerWagonFillType ~= nil then
						isMixerAndOk = true;
						--print("mixer wagon!")
					end;
				end;
				
				if isMixerAndOk or shovel.currentFillType == fillType or (shovel.fillLevel/shovel.capacity < 0.05 and shovel.fillLevel < 1000) then
					delta = shovel:fillShovelFromTrigger(self, math.max(fillLevel - 0*1000,0), fillType, dt);
				end;
				if fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW and delta == 0 then
					fillType = Fillable.FILLTYPE_GRASS_WINDROW;
					if shovel.currentFillType == fillType or (shovel.fillLevel/shovel.capacity < 0.05 and shovel.fillLevel < 1000) then
						delta = shovel:fillShovelFromTrigger(self, math.max(fillLevel - 0*1000,0), fillType, dt);
					end;
				end;
				
				
			end;
		end;
        if delta > 0 then
            self.bunkerSilo:setMovingPlaneFillLevel(self.movingPlane, self.movingPlane.fillLevel - delta, false);
        end
    end
end

function improvedSilageBunker:NEWgetAllowShovelFillType(fillType)
	if self.state == BunkerSilo.STATE_DRAIN then
		return fillType == Fillable.FILLTYPE_SILAGE or fillType == Fillable.FILLTYPE_FORAGE or fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW;-- or fillType == Fillable.FILLTYPE_CHAFF;-- or fillType == Fillable.FILLTYPE_MANURE;
	else--if self.state == BunkerSilo.STATE_FILL then
		return fillType == Fillable.FILLTYPE_CHAFF or fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW;-- or fillType == Fillable.FILLTYPE_CHAFF;
	end;
end;

function improvedSilageBunker:NEWsetState(state) 
    if state ~= self.state then
        if state == BunkerSilo.STATE_FILL then
            if self.silagePlaneId ~= nil then
                self.silagePlaneMoveAlpha = 0;
                local x,_,z = getTranslation(self.silagePlaneId);
                setTranslation(self.silagePlaneId, x, self.silagePlaneMinY, z);
                setVisibility(self.silagePlaneId, false);
            end;
        elseif state == BunkerSilo.STATE_CLOSED then
            self.fermentingTime = 0;
            self:calculateSilagePlaneMoveAlphaMax();
            if self.silagePlaneId ~= nil then
                setVisibility(self.silagePlaneId, true);
            end;
        elseif state == BunkerSilo.STATE_DRAIN then
            if self.silagePlaneId ~= nil then
                self.silagePlaneMoveAlpha = 0;
                local x,_,z = getTranslation(self.silagePlaneId);
                setTranslation(self.silagePlaneId, x, self.silagePlaneMinY, z);
                setVisibility(self.silagePlaneId, false);
            end;
            -- change the color of the moving planes to silage
            
            for _,movingPlane in pairs(self.movingPlanes) do
				if Utils.getNoNil(movingPlane.isRotten,false) then 
					BunkerSilo:setPlaneShader(movingPlane,"ROTTEN")
				else
					BunkerSilo:setPlaneShader(movingPlane,"SILAGE")
				end;
            end;
        end;
        if self.state == BunkerSilo.STATE_DRAIN and state == BunkerSilo.STATE_FILL then
            -- if we switch from state drain ONLY to fill change the moving planes to chaff
            for _,movingPlane in pairs(self.movingPlanes) do
				if Utils.getNoNil(movingPlane.isRotten,false) then 
					BunkerSilo:setPlaneShader(movingPlane,"ROTTEN")
				else
					BunkerSilo:setPlaneShader(movingPlane,"CHAFF")
				end;
            end;
        end;
        self.state = state;
        if self.isServer then
            self:raiseDirtyFlags(self.bunkerSiloDirtyFlag);
        end;
    end;
end;


function improvedSilageBunker:NEWgetCanCloseSilo()
    return self.state == BunkerSilo.STATE_FILL and (self.fillLevel > 0.10*self.capacity or self.fillLevel > 120000);-- and self.compactedFillLevel >= self.fillLevel-0.01;
end;


function improvedSilageBunker:NEWsetFillDeltaAt(x,y,z, delta, addWarnings,fillType)
    if delta ~= 0 then
        -- find the moving plane that is nearest
        local nearestDistance = math.huge;
        local nearestPlaneI = 1;
        for i,movingPlane in pairs(self.movingPlanes) do
            local wx,_,wz = getWorldTranslation(movingPlane.nodeId);
            local distance = (wx-x)*(wx-x) + (wz-z)*(wz-z);
            if distance < nearestDistance then
                nearestPlaneI = i;
                nearestDistance = distance;
            end;
        end;

        local plane1 = self.movingPlanes[nearestPlaneI];
        --local weight1 = 0.8;
		local weight1 = 1.0;
        -- local weight2 = 0.1;
        -- local weight3 = 0.1;
        -- local plane2;
        -- local plane3;
		
		--plane1 abchecken gegen fillType
		local fillTypeIsOk = false;
		if Utils.getNoNil(plane1.isRotten,false) then
			if fillType == Fillable.FILLTYPE_MANURE then
				fillTypeIsOk = true;
			end;
		else			
			if self.state == BunkerSilo.STATE_FILL then	
				if fillType == Fillable.FILLTYPE_POTATO or fillType == Fillable.FILLTYPE_CHAFF or fillType == Fillable.FILLTYPE_GRASS_WINDROW or fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW or fillType == Fillable.FILLTYPE_GRASS or fillType == Fillable.FILLTYPE_DRYGRASS then
					fillTypeIsOk = true;
				end;
			elseif self.state == BunkerSilo.STATE_DRAIN then
				if fillType == Fillable.FILLTYPE_SILAGE or fillType == Fillable.FILLTYPE_GRASS_WINDROW or fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW or fillType == Fillable.FILLTYPE_FORAGE then
					fillTypeIsOk = true;
				end;				
			end;
		end;
		
		if not fillTypeIsOk then
			return;
		end;
		
      
		local grass = 0;
		local potato  = 0;		
		local oldFillLevel = 0;
		--new code for composition stats:
		if self.state == BunkerSilo.STATE_FILL then	
			grass = Utils.getNoNil(plane1.fractionGrass,0)*plane1.fillLevel;
			potato = Utils.getNoNil(plane1.fractionPotato,0)*plane1.fillLevel;
			--chaff = plane1.fillLevel - grass - potatoe;
			oldFillLevel = plane1.fillLevel;
		end;
		
        self:setMovingPlaneFillLevel(plane1, plane1.fillLevel + weight1*delta, addWarnings);
		
		--new code for composition stats:
		if self.state == BunkerSilo.STATE_FILL then				
			local deltaFill = plane1.fillLevel - oldFillLevel;
			if deltaFill > 0 then
				if fillType == Fillable.FILLTYPE_GRASS_WINDROW or fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW or fillType == Fillable.FILLTYPE_GRASS or fillType == Fillable.FILLTYPE_DRYGRASS then
					grass = grass + deltaFill;
				elseif fillType == Fillable.FILLTYPE_POTATO then
					potato = potato + deltaFill;				
				end;
				
				plane1.fractionGrass = grass/plane1.fillLevel;
				plane1.fractionPotato = potato/plane1.fillLevel;
				--print(tostring(deltaFill).."  grass: "..tostring(plane1.fractionGrass).."  potato: "..tostring(plane1.fractionPotato))
				--works so far, potato unloading needs changes on the trigger
			end;
		end;
		
    end;
end;


function improvedSilageBunker:NEWcalculateSilagePlaneMoveAlphaMax()
    self.silagePlaneMoveAlphaMax = 0;
    for _,movingPlane in pairs(self.movingPlanes) do
		local alpha = (Utils.getNoNil(movingPlane.compactFillLevel,0) + (movingPlane.fillLevel-math.min(Utils.getNoNil(movingPlane.compactFillLevel,0),movingPlane.fillLevel))*2)/movingPlane.capacity;
		alpha = Utils.clamp(alpha,0,1.0);
        self.silagePlaneMoveAlphaMax = math.max(self.silagePlaneMoveAlphaMax, alpha)
    end;
    self.silagePlaneMoveAlphaMax = self.silagePlaneMoveAlphaMax ^ self.movingPlanesYPower;
    self.silagePlaneMoveAlphaMax = math.min(self.silagePlaneMoveAlphaMax + (1-self.silagePlaneMoveAlphaMax)*self.silagePlaneMoveMinOffset, 1);
end;

--

function improvedSilageBunker:NEWsetPlaneShader(movingPlane,newState)
	if newState == "CHAFF" then
		setShaderParameter(movingPlane.nodeId, "colorScale", 1.0, 1.0, 1.0, 0, false);	
	
	elseif newState == "SILAGE" then
		local colorScale = 0.9;
		
		local colorScaleR = 255/255*colorScale;
		local colorScaleG = 190/255*colorScale;
		local colorScaleB = 255/255*colorScale;				
		setShaderParameter(movingPlane.nodeId, "colorScale", colorScaleR, colorScaleG, colorScaleB, 0, false);	
	elseif newState == "ROTTEN" then
		local colorScale = 0.25 + (math.random()-0.5)*.10;
		--local colorScale = 0.25;
		-- local colorScaleR = (105-math.random()*20)/255*colorScale;
		-- local colorScaleG = (105 + (math.random()-0.5)*20)/255*colorScale;
		-- local colorScaleB = (230 + (math.random()-0.5)*20)/255*colorScale;				
		local colorScaleR = 255/255*colorScale;
		local colorScaleG = 190/255*colorScale;
		local colorScaleB = 255/255*colorScale;	
		setShaderParameter(movingPlane.nodeId, "colorScale", colorScaleR, colorScaleG, colorScaleB, 0, false);	
	else
		print("BunkerSilo:: invalid state for movingPlane: "..tostring(Utils.getNoNil(newState,"nil")))
	end;
end;



function improvedSilageBunker:BSAgetIsActivatable() 

    if self.bunkerSilo:getCanInteract() and g_currentMission.controlPlayer then
        if self.bunkerSilo:getCanCloseSilo() then
            self:updateActivateText();
            return true;
        elseif self.bunkerSilo.state == BunkerSilo.STATE_CLOSED then
			if self.bunkerSilo.fermentingTime >= self.bunkerSilo.fermentingDuration then
				self:updateActivateText();
				return true;
			end;		
		elseif self.bunkerSilo.state == BunkerSilo.STATE_DRAIN then
			self:updateActivateText();
			return true;
		end;
    end;
    return false;
end;

function improvedSilageBunker:BSAonActivateObject()
    if self.bunkerSilo:getCanCloseSilo() then
        self.bunkerSilo:setState(BunkerSilo.STATE_CLOSED);
        if g_server == nil then
            g_client:getServerConnection():sendEvent(BunkerSiloCloseEvent:new(self.bunkerSilo));
        end;
    elseif self.bunkerSilo.state == BunkerSilo.STATE_CLOSED then
		if self.bunkerSilo.fermentingTime >= self.bunkerSilo.fermentingDuration then
			self.bunkerSilo:setState(BunkerSilo.STATE_DRAIN);
			if g_server == nil then
				g_client:getServerConnection():sendEvent(BunkerSiloOpenEvent:new(self.bunkerSilo));
			end;
		end;
	elseif self.bunkerSilo.state == BunkerSilo.STATE_DRAIN then
		self.bunkerSilo:setState(BunkerSilo.STATE_CLOSED);
		self.bunkerSilo.fermentingTime = self.bunkerSilo.fermentingDuration;
        if g_server == nil then
            g_client:getServerConnection():sendEvent(BunkerSiloCloseEvent:new(self.bunkerSilo));
        end;
	end;
    self:updateActivateText();
    g_currentMission:addActivatableObject(self);
end;

-- function BunkerSiloActivatable:drawActivate()
    ----TODO draw icon
-- end;

function improvedSilageBunker:BSAupdateActivateText()
    self.activateText = "unknown";
    if self.bunkerSilo.state == BunkerSilo.STATE_FILL then
        self.activateText = g_i18n:getText("blanket_silo");
    elseif self.bunkerSilo.state == BunkerSilo.STATE_CLOSED then
		self.activateText = g_i18n:getText("open_silo");
	elseif self.bunkerSilo.state == BunkerSilo.STATE_DRAIN then
		self.activateText = g_i18n:getText("re_blanket_silo");
	end;
end;











function improvedSilageBunker:NEWloadFromAttributesAndNodes(xmlFile, key)

    local state = getXMLInt(xmlFile, key.."#state");
    if state ~= nil then
        if state >= 0 and state < BunkerSilo.NUM_STATES then
            self:setState(state);
        end;
    end;
	
	local compactedFillLevel = getXMLFloat(xmlFile, key.."#compactedFillLevel");
    if compactedFillLevel ~= nil then
        self.compactedFillLevel = Utils.clamp(compactedFillLevel, 0, self.fillLevel);
    end;

    for i=1, table.getn(self.movingPlanes) do
        local planeKey = key..string.format(".movingPlane%d", i);
        if not hasXMLProperty(xmlFile, planeKey) then
            break;
        end;
        local fillLevel = getXMLFloat(xmlFile, planeKey.."#fillLevel");
		--local compactFillLevel = Utils.getNoNil(getXMLFloat(xmlFile, planeKey.."#compactFillLevel"),fillLevel);--change here
		local compactFillLevel = getXMLFloat(xmlFile, planeKey.."#compactFillLevel");
		if compactFillLevel == nil then --handle load from old savegame
			if state == 0 then
				local comRatio = self.compactedFillLevel/self.fillLevel;
				compactFillLevel = comRatio*fillLevel;
			else
				compactFillLevel = fillLevel;
			end;
		end;
		
		local isRotten = Utils.getNoNil(getXMLBool(xmlFile, planeKey.."#isRotten"),false);
		local randomCheckDone = Utils.getNoNil(getXMLBool(xmlFile, planeKey.."#randomCheckDone"),state > 0);
		local fractionGrass = Utils.getNoNil(getXMLFloat(xmlFile, planeKey.."#fractionGrass"),0);
		local fractionPotato = Utils.getNoNil(getXMLFloat(xmlFile, planeKey.."#fractionPotato"),0);
        if fillLevel ~= nil then            
			self.movingPlanes[i].compactFillLevel = compactFillLevel;
			self.movingPlanes[i].isRotten = isRotten;
			self.movingPlanes[i].randomCheckDone = randomCheckDone;
			self.movingPlanes[i].fractionGrass = fractionGrass;
			self.movingPlanes[i].fractionPotato = fractionPotato;
			if isRotten then
				BunkerSilo:setPlaneShader(self.movingPlanes[i],"ROTTEN");
			end;
			self:setMovingPlaneFillLevel(self.movingPlanes[i], fillLevel, false);
		end;
    end;

    

    local fermentingTime = getXMLFloat(xmlFile, key.."#fermentingTime");
    if fermentingTime ~= nil then
        self.fermentingTime = Utils.clamp(fermentingTime, 0, self.fermentingDuration);
    end;

    self:calculateSilagePlaneMoveAlphaMax();
    local silagePlaneMoveAlphaMax = getXMLFloat(xmlFile, key.."#silagePlaneMoveAlphaMax");
    if silagePlaneMoveAlphaMax ~= nil then
        self.silagePlaneMoveAlphaMax = math.max(silagePlaneMoveAlphaMax, self.silagePlaneMoveAlphaMax);
    end;

    local silagePlaneMoveAlpha = getXMLFloat(xmlFile, key.."#silagePlaneMoveAlpha");
    if silagePlaneMoveAlpha ~= nil then
        self.silagePlaneMoveAlpha = Utils.clamp(silagePlaneMoveAlpha, 0, self.silagePlaneMoveAlphaMax);
        if self.state ~= BunkerSilo.STATE_CLOSED then
            self.silagePlaneMoveAlpha = 0;
        end;
        if self.silagePlaneId ~= nil then
            local x,_,z = getTranslation(self.silagePlaneId);
            setTranslation(self.silagePlaneId, x, self.silagePlaneMinY + self.silagePlaneMoveAlpha*(self.silagePlaneMaxY- self.silagePlaneMinY), z);
        end;
    end;
    return true;
end;

function improvedSilageBunker:NEWgetSaveAttributesAndNodes(nodeIdent)

    local attributes = 'state="'..self.state..'" compactedFillLevel="'..self.compactedFillLevel..'" fermentingTime="'..self.fermentingTime..'" silagePlaneMoveAlpha="'..self.silagePlaneMoveAlpha..'" silagePlaneMoveAlphaMax="'..self.silagePlaneMoveAlphaMax..'"';

    local nodes = "";
    for i=1, table.getn(self.movingPlanes) do
        if i>1 then
            nodes = nodes.."\n";
        end;
        local movingPlane = self.movingPlanes[i];
        nodes = nodes.. nodeIdent..'<movingPlane'..i..' fillLevel="'..movingPlane.fillLevel..'" compactFillLevel="'..Utils.getNoNil(movingPlane.compactFillLevel,0)..'" isRotten="'..tostring(Utils.getNoNil(movingPlane.isRotten,false))..'" randomCheckDone="'..tostring(Utils.getNoNil(movingPlane.randomCheckDone,false))..'" fractionGrass="'..tostring(Utils.getNoNil(movingPlane.fractionGrass,0))  ..'" fractionPotato="'..tostring(Utils.getNoNil(movingPlane.fractionPotato,0))..'" />';
    end;

    return attributes, nodes;
end;


function improvedSilageBunker:NEWreadUpdateStream(streamId, timestamp, connection)
    BunkerSilo:superClass().readUpdateStream(self, streamId, timestamp, connection)
    if connection:getIsServer() then
        self.showMovingPlaneFullWarningTimer = streamReadUIntN(streamId, 4)/15*self.warningTimerTime;

        for i=1, table.getn(self.movingPlanes) do
            local movingPlane = self.movingPlanes[i];

            local fillLevel = streamReadFloat32(streamId);
			movingPlane.compactFillLevel = streamReadFloat32(streamId);
			local oldIsRotten = Utils.getNoNil(movingPlane.isRotten,false);
			movingPlane.isRotten = streamReadBool(streamId);
			if movingPlane.isRotten and not oldIsRotten then
				BunkerSilo:setPlaneShader(movingPlane,"ROTTEN");
			end;
            self:setMovingPlaneFillLevel(movingPlane, fillLevel, false);
        end;
        self.compactedFillLevel = streamReadFloat32(streamId);
        local state = streamReadUIntN(streamId, 2);
        self:setState(state);
		
		self.lastPlaneCompactionLevel = streamReadFloat32(streamId);
		self.tooMuchEffectScale = streamReadFloat32(streamId);
		self.lastRottenState = streamReadBool(streamId);
    end;
end;

function improvedSilageBunker:NEWwriteUpdateStream(streamId, connection, dirtyMask)
    BunkerSilo:superClass().writeUpdateStream(self, streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        local percent = Utils.clamp(self.showMovingPlaneFullWarningTimer / self.warningTimerTime, 0, 1);
        streamWriteUIntN(streamId, math.floor(percent*15), 4);

        for i=1, table.getn(self.movingPlanes) do
            local movingPlane = self.movingPlanes[i];

            streamWriteFloat32(streamId, movingPlane.fillLevel);
			streamWriteFloat32(streamId, Utils.getNoNil(movingPlane.compactFillLevel,0));
			streamWriteBool(streamId, Utils.getNoNil(movingPlane.isRotten,false));
        end;
        streamWriteFloat32(streamId, self.compactedFillLevel);
        streamWriteUIntN(streamId, self.state, 2);
		
		streamWriteFloat32(streamId, Utils.getNoNil(self.lastPlaneCompactionLevel,0));
		streamWriteFloat32(streamId, Utils.getNoNil(self.tooMuchEffectScale,0));
		streamWriteBool(streamId, Utils.getNoNil(self.lastRottenState,false));
		
    end;
end;


function improvedSilageBunker:NEWreadStream(streamId, connection)
    BunkerSilo:superClass().readStream(self, streamId, connection);
    if connection:getIsServer() then

        local state = streamReadUIntN(streamId, 2);
        self:setState(state);

        for i=1, table.getn(self.movingPlanes) do
            local movingPlane = self.movingPlanes[i];

            local fillLevel = streamReadFloat32(streamId);
			movingPlane.compactFillLevel = streamReadFloat32(streamId);
			movingPlane.isRotten = streamReadBool(streamId);
			movingPlane.fractionGrass = streamReadFloat32(streamId);
			movingPlane.fractionPotato = streamReadFloat32(streamId);
			if movingPlane.isRotten then
				BunkerSilo:setPlaneShader(movingPlane,"ROTTEN");
			end;
            self:setMovingPlaneFillLevel(movingPlane, fillLevel, false);
        end;

        self.compactedFillLevel = streamReadFloat32(streamId);
        self.fermentingTime = streamReadFloat32(streamId);
        self.silagePlaneMoveAlphaMax = streamReadFloat32(streamId);
        self.silagePlaneMoveAlpha = streamReadFloat32(streamId);
        if self.state ~= BunkerSilo.STATE_CLOSED then
            self.silagePlaneMoveAlpha = 0;
        end;
        if self.silagePlaneId ~= nil then
            local x,_,z = getTranslation(self.silagePlaneId);
            setTranslation(self.silagePlaneId, x, self.silagePlaneMinY + self.silagePlaneMoveAlpha*(self.silagePlaneMaxY- self.silagePlaneMinY), z);
        end;
		self.lastPlaneCompactionLevel = streamReadFloat32(streamId);
		self.tooMuchEffectScale = streamReadFloat32(streamId);
		self.lastRottenState = streamReadBool(streamId);
		
    end;
end;

function improvedSilageBunker:NEWwriteStream(streamId, connection)
    BunkerSilo:superClass().writeStream(self, streamId, connection);
    if not connection:getIsServer() then
        streamWriteUIntN(streamId, self.state, 2);
        for i=1, table.getn(self.movingPlanes) do
            local movingPlane = self.movingPlanes[i];

            streamWriteFloat32(streamId, movingPlane.fillLevel);
			streamWriteFloat32(streamId, Utils.getNoNil(movingPlane.compactFillLevel,0));
			streamWriteBool(streamId, Utils.getNoNil(movingPlane.isRotten,false));
			streamWriteFloat32(streamId, Utils.getNoNil(movingPlane.fractionGrass,0));
			streamWriteFloat32(streamId, Utils.getNoNil(movingPlane.fractionPotato,0));
        end;

        streamWriteFloat32(streamId, self.compactedFillLevel);
        streamWriteFloat32(streamId, self.fermentingTime);
        streamWriteFloat32(streamId, self.silagePlaneMoveAlphaMax);
        streamWriteFloat32(streamId, self.silagePlaneMoveAlpha);
		
		streamWriteFloat32(streamId, Utils.getNoNil(self.lastPlaneCompactionLevel,0));
		streamWriteFloat32(streamId, Utils.getNoNil(self.tooMuchEffectScale,0));
		streamWriteBool(streamId, Utils.getNoNil(self.lastRottenState,false));
		
    end;
end;




BunkerSiloOpenEvent = {};
BunkerSiloOpenEvent_mt = Class(BunkerSiloOpenEvent, Event);

InitEventClass(BunkerSiloOpenEvent, "BunkerSiloOpenEvent");

function BunkerSiloOpenEvent:emptyNew()
    local self = Event:new(BunkerSiloOpenEvent_mt);
    return self;
end;

function BunkerSiloOpenEvent:new(bunkerSilo)
    local self = BunkerSiloOpenEvent:emptyNew()
    self.bunkerSilo = bunkerSilo;
    return self;
end;

function BunkerSiloOpenEvent:readStream(streamId, connection)
    if not connection:getIsServer() then
        self.bunkerSilo = networkGetObject(streamReadInt32(streamId));
    end;
    self:run(connection);
end;

function BunkerSiloOpenEvent:writeStream(streamId, connection)
    if connection:getIsServer() then
        streamWriteInt32(streamId, networkGetObjectId(self.bunkerSilo));
    end;
end;

function BunkerSiloOpenEvent:run(connection)
    if not connection:getIsServer() then
        if self.bunkerSilo.state == BunkerSilo.STATE_CLOSED then
			if self.bunkerSilo.fermentingTime > self.bunkerSilo.fermentingDuration then
				self.bunkerSilo:setState(BunkerSilo.STATE_DRAIN);
			end;
		end;
    end;
end;



BunkerSilo.update = improvedSilageBunker.NEWupdate;
BunkerSilo.setMovingPlaneFillLevel = improvedSilageBunker.NEWsetMovingPlaneFillLevel;
BunkerSilo.addShovelFillLevel = improvedSilageBunker.NEWaddShovelFillLevel;
BunkerSilo.setTrailerFillDelta = improvedSilageBunker.NEWsetTrailerFillDelta;
BunkerSilo.getAllowShovelFillType = improvedSilageBunker.NEWgetAllowShovelFillType;
BunkerSilo.setState = improvedSilageBunker.NEWsetState;
BunkerSilo.getCanCloseSilo = improvedSilageBunker.NEWgetCanCloseSilo;
BunkerSilo.setFillDeltaAt = improvedSilageBunker.NEWsetFillDeltaAt;
BunkerSilo.calculateSilagePlaneMoveAlphaMax = improvedSilageBunker.NEWcalculateSilagePlaneMoveAlphaMax;
BunkerSilo.setPlaneShader = improvedSilageBunker.NEWsetPlaneShader;
BunkerSilo.getCanInteract = improvedSilageBunker.NEWgetCanInteract;
BunkerSilo.loadFromAttributesAndNodes = improvedSilageBunker.NEWloadFromAttributesAndNodes;
BunkerSilo.getSaveAttributesAndNodes = improvedSilageBunker.NEWgetSaveAttributesAndNodes;
BunkerSilo.readUpdateStream = improvedSilageBunker.NEWreadUpdateStream;
BunkerSilo.writeUpdateStream = improvedSilageBunker.NEWwriteUpdateStream;
BunkerSilo.readStream = improvedSilageBunker.NEWreadStream;
BunkerSilo.writeStream = improvedSilageBunker.NEWwriteStream;

BunkerSiloActivatable.getIsActivatable = improvedSilageBunker.BSAgetIsActivatable; 
BunkerSiloActivatable.updateActivateText = improvedSilageBunker.BSAupdateActivateText;
BunkerSiloActivatable.onActivateObject = improvedSilageBunker.BSAonActivateObject;

BunkerSiloShovelTrigger.fillShovel = improvedSilageBunker.BSTTfillShovel;