--
-- MultiSiloEffectss
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history:	v1.0 - 2014-10-31 - Initial implementation
-- @note:		Hard scripted for Holzhausen map!

MultiSiloEffects = {};

local MultiSiloEffects_mt = Class(MultiSiloEffects, Object);
InitObjectClass(MultiSiloEffects, "MultiSiloEffects");

function MultiSiloEffects.onCreate(id)
    local instance = MultiSiloEffects:new(g_server ~= nil, g_client ~= nil);
	if instance:load(id) then
		instance:register(true);
	else
		instance:delete();
	end;
end;
g_onCreateUtil.addOnCreateFunction("MultiSiloEffects", MultiSiloEffects.onCreate);

function MultiSiloEffects:new(isServer, isClient)
	local self = Object:new(isServer, isClient, MultiSiloEffects_mt);
    self.className = "MultiSiloEffects";
	
    return self;
end;

function MultiSiloEffects:load(id)
	self.greenNode = getChildAt(id, 0);
	self.orangeNode = getChildAt(id, 1);
	
	setVisibility(self.greenNode, false);
	setVisibility(self.orangeNode, true);
	
	local file = Utils.getFilename("$data/vehicles/tools/airBlowerLoop.wav", g_currentMission.baseDirectory);
	self.soundEffect = createAudioSource("soundEffect", file, 24, 22, 1, 0);
	link(id, self.soundEffect);
	setVisibility(self.soundEffect, false);
	
	return true;
end;

function MultiSiloEffects:delete()
end;

function MultiSiloEffects:update(dt)
end;

function MultiSiloEffects:updateTick(dt)
	if self.firstTry == nil then
		self.firstTry = false;
		
		for i, k in pairs(g_currentMission.onCreateLoadedObjects) do 
			if k.multiSiloTriggerDirtyFlag ~= nil then
				self.stationID = k.id;
				break;
			end;
		end;
	end;
	
	if self.stationID ~= nil then
		local unloadTrigger = g_currentMission.onCreateLoadedObjects[self.stationID];
		
		if unloadTrigger ~= nil then
			if self.lastUpdate ~= unloadTrigger.isFilling then
				self.lastUpdate = unloadTrigger.isFilling;
				
				setVisibility(self.soundEffect, unloadTrigger.isFilling);
				setVisibility(self.greenNode, unloadTrigger.isFilling);
				setVisibility(self.orangeNode, not unloadTrigger.isFilling);
			end;
		end;
	end;
end;