--
-- ConveyorBelts
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history		v1.0 - 2014-10-31 - Initial implementation
-- 

ConveyorBelt = {};

local ConveyorBelt_mt = Class(ConveyorBelt, Object);
InitObjectClass(ConveyorBelt, "ConveyorBelt");

function ConveyorBelt.onCreate(id)
    local instance = ConveyorBelt:new(g_server ~= nil, g_client ~= nil);
	if instance:load(id) then
		instance:register(true);
	else
		instance:delete();
	end;
end;
g_onCreateUtil.addOnCreateFunction("ConveyorBelt", ConveyorBelt.onCreate);

function ConveyorBelt:new(isServer, isClient)
	local self = Object:new(isServer, isClient, ConveyorBelt_mt);
    self.className = "ConveyorBelt";
	
	self.triggerId = 0;
	
    return self;
end;

function ConveyorBelt:load(id)
	self.triggerId = id;
	self.isEnabled = true;
	addTrigger(self.triggerId, "triggerCallback", self);
	
	local axis = Utils.getNoNil(getUserAttribute(id, "moveAxis"), 1);
	self.dirLength = Utils.getNoNil(getUserAttribute(id, "dirLenght"), 8) / 1000;
	self.targetVelocity = Utils.getNoNil(getUserAttribute(id, "targetVelocity"), 2);
	
	if axis == 1 then
		self.dirX, self.dirY, self.dirZ = localDirectionToWorld(self.triggerId, 1, 0, 0);
	elseif axis == 2 then
		self.dirX, self.dirY, self.dirZ = localDirectionToWorld(self.triggerId, 0, 1, 0);
	else
		self.dirX, self.dirY, self.dirZ = localDirectionToWorld(self.triggerId, 0, 0, 1);
	end;
	
	self.dirX = self.dirX * self.dirLength;
	self.dirY = self.dirY * self.dirLength;
	self.dirZ = self.dirZ * self.dirLength;

	self.touched = {};
	
	return true;
end;

function ConveyorBelt:delete()
	if self.triggerId ~= 0 then
		removeTrigger(self.triggerId);
	end;
end;

function ConveyorBelt:update(dt)
	for k, touched in pairs(self.touched) do
		-- local object = g_currentMission:getNodeObject(k);
		local object = getMass(k);
		
		if object ~= nil then
			local vx, vy, vz = getLinearVelocity(k);
			local dot = vx*self.dirX + vy*self.dirY + vz*self.dirZ;
			local v = dot/self.dirLength;

			if v < self.targetVelocity then
				local scale = dt*touched.mass;
				addForce(k, self.dirX*dt, self.dirY*dt, self.dirZ*dt, 0, 0, 0, true);
			end;
		else
			self.touched[k] = nil; -- fail safe if deleted..
			print("Congrats, you have sold a log!");
		end;
	end;
end;

function ConveyorBelt:updateTick(dt)
end;

function ConveyorBelt:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled then
		if onEnter then
			local touched = self.touched[otherId];
			
			if touched ~= nil then
				touched.count = touched.count+1;
			else
				local mass = getMass(otherId);
				self.touched[otherId] = {mass=mass, count=1};
			end;
			
		elseif onLeave then
			local touched = self.touched[otherId];
			
			if touched ~= nil then
				if touched.count > 1 then
					touched.count = touched.count-1;
				else
					self.touched[otherId] = nil;
				end;
			end;
		end;
	end;
end;