--
-- Holzhausen
--
-- @author  Stefan Geiger
-- @date  12/07/10
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- Holzhausen 2015 Copyright (C) Niggels, Xentro
-- 30/10/14

Holzhausen = {}

local Holzhausen_mt = Class(Holzhausen, Mission00);


function Holzhausen:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Holzhausen_mt;
    end;
    local self = Holzhausen:superClass():new(baseDirectory, mt);

    return self;
end;

function Holzhausen:delete()
    Holzhausen:superClass().delete(self);
end;

function Holzhausen:load()
    self:startLoadingTask();
	
	source(Utils.getFilename("map/scripts/HolzhausenExtension.lua", self.baseDirectory));

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;
	self.AnimationMapConfig = {"map/scripts/AnimationMap.xml", self.baseDirectory};
	
    self:loadMap(Utils.getFilename("map/Holzhausen.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
end;

print("--- loading Holzhausen 2015 by Niggels.... Have fun!");

function Holzhausen:loadCareerMap01Finished(node, arguments)
    if self.cancelLoading then
        return;
    end
	
    self.terrainDetailAngleNumChannels = 8; 
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;
	
	local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("Holzhausen.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    -- ATMs
    self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), -358, -325.5, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), 317, 47, nil, nil, false, false, false, 0, true);
	self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), -531, 447, nil, nil, false, false, false, 0, true);

    -- shops
    self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), 380, 13, nil, nil, false, false, false, 0, true);
    local gardenCenterHotspot = self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), 315, 73, nil, nil, false, false, true, 0, true);
    gardenCenterHotspot.fullViewName = g_i18n:getText("gardenCenter");

    -- egg sellpoints
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), 323.5, -54.5, nil, nil, false, false, false, 0, true);
   
    -- farm silos
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -90, 8, nil, nil, false, false, false, 0, true);
    
    -- bga
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -318, 202, nil, nil, false, false, false, 0, true);
    
    -- grass heaps
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -96, -70, nil, nil, false, false, false, 0, true);
    
    -- livestock
    self.ingameMap:createMapHotspot("Cows", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_cows.png", self.baseDirectory), -184, -65, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Chickens", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_chickens.png", self.baseDirectory), -144, 62, nil, nil, false, false, false, 0, true);
    
    

	trcScreenFlip();
    Holzhausen:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
	if _G["AnimationMapTrigger"] == nil then print("  AnimationMapTrigger - Notice: The mod AnimationMapTrigger is missing from your mods folder, get your copy at http://vertexdezign.net/"); 
	end;
end;

function Holzhausen:onStartMission()
    Holzhausen:superClass().onStartMission(self);
end;

function Holzhausen:mouseEvent(posX, posY, isDown, isUp, button)
    Holzhausen:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Holzhausen:keyEvent(unicode, sym, modifier, isDown)
    Holzhausen:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Holzhausen:update(dt)
    Holzhausen:superClass().update(self, dt);
end;

function Holzhausen:draw()
    Holzhausen:superClass().draw(self);
end;
