WheelRotations = {
	prerequisitesPresent = function (specializations)
		return true
	end,
	load = function (self, xmlFile)
		self.wheelRotations = {}
		local i = 0

		while true do
			local baseName = string.format("vehicle.wheelRotations.wheelRotation(%d)", i)

			if not hasXMLProperty(xmlFile, baseName) then
				break
			end

			local node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#index"))
			local wheelIndex = getXMLInt(xmlFile, baseName .. "#wheelIndex")

			if node ~= nil and self.wheels[wheelIndex + 1] ~= nil then
				table.insert(self.wheelRotations, {
					node = node,
					wheel = self.wheels[wheelIndex + 1]
				})
			end

			i = i + 1
		end

		self.wheelHeights = {}
		local i = 0

		while true do
			local baseName = string.format("vehicle.wheelHeights.wheelHeight(%d)", i)

			if not hasXMLProperty(xmlFile, baseName) then
				break
			end

			local node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#index"))
			local wheelIndex = getXMLInt(xmlFile, baseName .. "#wheelIndex")

			if node ~= nil and self.wheels[wheelIndex + 1] ~= nil then
				local x, y, z = getTranslation(node)

				table.insert(self.wheelHeights, {
					node = node,
					wheel = self.wheels[wheelIndex + 1],
					initialPosition = {
						x,
						y,
						z
					}
				})
			end

			i = i + 1
		end

		for i, wheel in ipairs(self.wheels) do
			local wheelnamei = string.format("vehicle.wheels.wheel(%d)", wheel.xmlIndex)

			if hasXMLProperty(xmlFile, wheelnamei .. "#rotSpeedLimit") then
				wheel.rotSpeedLimit = getXMLInt(xmlFile, wheelnamei .. "#rotSpeedLimit")
				wheel.rotSpeedDefault = wheel.rotSpeed
				wheel.rotSpeedNegDefault = wheel.rotSpeedNeg
				wheel.currentRotSpeedAlpha = 1
			end
		end

		return 
	end,
	delete = function (self)
		return 
	end,
	mouseEvent = function (self, posX, posY, isDown, isUp, button)
		return 
	end,
	keyEvent = function (self, unicode, sym, modifier, isDown)
		return 
	end,
	update = function (self, dt)
		if self.getIsActive(self) and self.firstTimeRun then
			for i, wheelRotation in pairs(self.wheelRotations) do
				_, y, _ = getRotation(wheelRotation.wheel.repr)

				setRotation(wheelRotation.node, 0, y, 0)
			end

			for i, wheelHeight in pairs(self.wheelHeights) do
				local _, y, _ = getTranslation(wheelHeight.wheel.repr)

				setTranslation(wheelHeight.node, wheelHeight.initialPosition[1], y, wheelHeight.initialPosition[3])
			end
		end

		return 
	end,
	updateTick = function (self, dt)
		if self.getIsActive(self) then
			for k, wheel in pairs(self.wheels) do
				if wheel.rotSpeedLimit ~= nil then
					local dir = -1

					if self.getLastSpeed(self) <= wheel.rotSpeedLimit then
						dir = 1
					end

					wheel.currentRotSpeedAlpha = Utils.clamp(wheel.currentRotSpeedAlpha + dir*dt/1000, 0, 1)
					wheel.rotSpeed = wheel.rotSpeedDefault*wheel.currentRotSpeedAlpha
					wheel.rotSpeedNeg = wheel.rotSpeedNegDefault*wheel.currentRotSpeedAlpha
				end
			end
		end

		return 
	end,
	draw = function (self)
		return 
	end
}