PipeMovementFreezer = {
	prerequisitesPresent = function (specializations)
		return SpecializationUtil.hasSpecialization(MouseControlsVehicle, specializations) and SpecializationUtil.hasSpecialization(Cylindered, specializations)
	end
}
PipeMovementFreezer.load = function (self, xmlFile)
	self.freezeMovingTool = PipeMovementFreezer.freezeMovingTool
	self.releaseMovingTool = PipeMovementFreezer.releaseMovingTool
	self.mouseControlsIconsDummy = {}
	self.mouseControlsIconsBackUp = self.mouseControlsIcons
	self.pipeMovementFreezer = {
		node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeMovementFreezer#index")),
		pipeStateForMoving = getXMLInt(xmlFile, "vehicle.pipeMovementFreezer#pipeStateForMoving"),
		movingTool = nil
	}

	for i, tool in pairs(self.movingTools) do
		if tool.node == self.pipeMovementFreezer.node then
			self.pipeMovementFreezer.movingTool = tool

			break
		end
	end

	self.pipeMovementFreezer.pipeNode = nil

	for i, pipeNode in pairs(self.pipeNodes) do
		if pipeNode.node == self.pipeMovementFreezer.node then
			self.pipeMovementFreezer.pipeNode = pipeNode

			break
		end
	end

	self.freezeMovingTool(self)

	return 
end
PipeMovementFreezer.delete = function (self)
	return 
end
PipeMovementFreezer.mouseEvent = function (self, posX, posY, isDown, isUp, button)
	return 
end
PipeMovementFreezer.keyEvent = function (self, unicode, sym, modifier, isDown)
	return 
end
PipeMovementFreezer.update = function (self, dt)
	if self.getIsActive(self) and self.pipeMovementFreezer.movingTool ~= nil then
		local release = self.pipeMovementFreezer.pipeStateForMoving == self.currentPipeState
		release = release and self.pipeMovementFreezer.pipeStateForMoving == self.targetPipeState

		if release and self.pipeMovementFreezer.isFreezed then
			self.releaseMovingTool(self)
		elseif not release and not self.pipeMovementFreezer.isFreezed then
			self.freezeMovingTool(self)
		end
	end

	return 
end
PipeMovementFreezer.updateTick = function (self, dt)
	return 
end
PipeMovementFreezer.draw = function (self)
	return 
end
PipeMovementFreezer.freezeMovingTool = function (self)
	if not self.pipeMovementFreezer.isFreezed then
		self.pipeMovementFreezer.isFreezed = true

		if self.pipeMovementFreezer.movingTool ~= nil then
			self.pipeMovementFreezer.movingTool.rotSpeedBackUp = self.pipeMovementFreezer.movingTool.rotSpeed
			self.pipeMovementFreezer.movingTool.rotSpeed = 0
		end
	end

	self.mouseControlsIcons = self.mouseControlsIconsDummy

	return 
end
PipeMovementFreezer.releaseMovingTool = function (self)
	if self.pipeMovementFreezer.isFreezed then
		self.pipeMovementFreezer.isFreezed = false
		local rotation = {
			getRotation(self.pipeMovementFreezer.movingTool.node)
		}

		if self.pipeMovementFreezer.movingTool ~= nil then
			self.pipeMovementFreezer.movingTool.rotSpeed = self.pipeMovementFreezer.movingTool.rotSpeedBackUp
			self.pipeMovementFreezer.movingTool.curRot = rotation
		end

		if self.pipeMovementFreezer.pipeNode ~= nil then
			self.pipeMovementFreezer.pipeNode.curRotation = rotation
		end
	end

	self.mouseControlsIcons = self.mouseControlsIconsBackUp

	return 
end
