AdvancedFillVolumeUnload = {
	prerequisitesPresent = function (specializations)
		return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(Overloading, specializations)
	end,
	load = function (self, xmlFile)
		self.fillVolumeUnloadExtra = {
			minHeight = getXMLFloat(xmlFile, "vehicle.fillVolumeUnloadExtra#minHeight"),
			maxHeight = getXMLFloat(xmlFile, "vehicle.fillVolumeUnloadExtra#maxHeight"),
			useFrontOrBackCounter = 0,
			nodeCount = 1
		}
		self.fillVolumeUnloadInfoFront = {
			node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillVolumeUnloadInfoFront#index")),
			width = getXMLFloat(xmlFile, "vehicle.fillVolumeUnloadInfoFront#width"),
			length = getXMLFloat(xmlFile, "vehicle.fillVolumeUnloadInfoFront#length")
		}

		if self.fillVolumeUnloadInfoFront.node ~= nil then
			self.fillVolumeUnloadExtra.nodeCount = self.fillVolumeUnloadExtra.nodeCount + 1
		end

		self.fillVolumeUnloadInfoBack = {
			node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillVolumeUnloadInfoBack#index")),
			width = getXMLFloat(xmlFile, "vehicle.fillVolumeUnloadInfoBack#width"),
			length = getXMLFloat(xmlFile, "vehicle.fillVolumeUnloadInfoBack#length")
		}

		if self.fillVolumeUnloadInfoBack.node ~= nil then
			self.fillVolumeUnloadExtra.nodeCount = self.fillVolumeUnloadExtra.nodeCount + 1
		end

		self.fillVolumeUnloadInfoBackUp = self.fillVolumeUnloadInfo

		return 
	end,
	delete = function (self)
		return 
	end,
	mouseEvent = function (self, posX, posY, isDown, isUp, button)
		return 
	end,
	keyEvent = function (self, unicode, sym, modifier, isDown)
		return 
	end,
	update = function (self, dt)
		if self.pipeIsUnloading then
			local height = 1
			local volumeNode = self.fillVolumes[1].volume
			local baseNode = self.fillVolumes[1].baseNode
			local x, _, z = localToLocal(self.fillVolumeUnloadInfoBackUp.node, baseNode, 0, 0, 0)
			height = getFillPlaneHeightAtLocalPos(volumeNode, x, z)

			if self.fillVolumeUnloadExtra.maxHeight < height then
				self.fillVolumeUnloadInfo = self.fillVolumeUnloadInfoBackUp
				self.fillVolumeUnloadExtra.useFrontOrBackCounter = 0
			else
				local selection = self.fillVolumeUnloadExtra.useFrontOrBackCounter%self.fillVolumeUnloadExtra.nodeCount

				if height < self.fillVolumeUnloadExtra.minHeight and selection == 0 then
					self.fillVolumeUnloadExtra.useFrontOrBackCounter = 0
					selection = 1
				end

				if selection == 0 then
					self.fillVolumeUnloadInfo = self.fillVolumeUnloadInfoBackUp
				elseif selection == 1 then
					if self.fillVolumeUnloadInfoFront.node ~= nil then
						self.fillVolumeUnloadInfo = self.fillVolumeUnloadInfoFront
					elseif self.fillVolumeUnloadInfoBack.node ~= nil then
						self.fillVolumeUnloadInfo = self.fillVolumeUnloadInfoBack
					end
				elseif selection == 2 then
					self.fillVolumeUnloadInfo = self.fillVolumeUnloadInfoBack
				end

				self.fillVolumeUnloadExtra.useFrontOrBackCounter = self.fillVolumeUnloadExtra.useFrontOrBackCounter + 1
			end
		end

		return 
	end,
	updateTick = function (self, dt)
		return 
	end,
	draw = function (self)
		return 
	end
}
