MorphPositionEffect = {}
local MorphPositionEffect_mt = Class(MorphPositionEffect, Effect)
MorphPositionEffect.STATE_OFF = 0
MorphPositionEffect.STATE_TURNING_ON = 1
MorphPositionEffect.STATE_ON = 2
MorphPositionEffect.STATE_TURNING_OFF = 3
MorphPositionEffect.new = function (self, customMt)
	if customMt == nil then
		customMt = MorphPositionEffect_mt
	end

	local self = Effect:new(customMt)
	self.state = MorphPositionEffect.STATE_OFF
	self.runningEffectNodes = 0
	self.planeFadeTime = 0

	return self
end
MorphPositionEffect.loadEffectNodeAttributes = function (self, xmlFile, key, node, effectNode, i3dNode)
	MorphPositionEffect:superClass().loadEffectNodeAttributes(self, xmlFile, key, node, effectNode, i3dNode)

	effectNode.fadeInTime = Utils.getNoNil(Utils.getNoNil(Effect.getValue(xmlFile, key, getXMLFloat, node, "fadeInTime"), Effect.getValue(xmlFile, key, getXMLFloat, node, "fadeTime")), 1)*1000
	effectNode.fadeOutTime = Utils.getNoNil(Utils.getNoNil(Effect.getValue(xmlFile, key, getXMLFloat, node, "fadeOutTime"), Effect.getValue(xmlFile, key, getXMLFloat, node, "fadeTime")), 1)*1000
	self.planeFadeTime = math.max(self.planeFadeTime, effectNode.fadeInTime, effectNode.fadeOutTime)
	effectNode.startDelay = Utils.getNoNil(Utils.getNoNil(Effect.getValue(xmlFile, key, getXMLFloat, node, "startDelay"), Effect.getValue(xmlFile, key, getXMLFloat, node, "delay")), 0)*1000
	effectNode.stopDelay = Utils.getNoNil(Utils.getNoNil(Effect.getValue(xmlFile, key, getXMLFloat, node, "stopDelay"), Effect.getValue(xmlFile, key, getXMLFloat, node, "delay")), 0)*1000
	effectNode.currentDelay = effectNode.startDelay
	effectNode.scrollSpeed = Utils.getNoNil(Effect.getValue(xmlFile, key, getXMLFloat, node, "scrollSpeed"), 1)
	effectNode.fadeCur = {
		0,
		0
	}
	effectNode.fadeDir = {
		0,
		0
	}

	setShaderParameter(effectNode.node, "morphPosition", 0, 1, 1, 0, false)

	return 
end
MorphPositionEffect.update = function (self, dt)
	MorphPositionEffect:superClass().update(self, dt)

	local runningEffectNodes = 0

	for k, effectNode in pairs(self.effectNodes) do
		effectNode.currentDelay = effectNode.currentDelay - dt

		if effectNode.currentDelay <= 0 then
			local fadeTime = effectNode.fadeInTime

			if self.state == MorphPositionEffect.STATE_TURNING_OFF then
				fadeTime = effectNode.fadeOutTime
			end

			effectNode.fadeCur[1] = math.max(0, math.min(1, effectNode.fadeCur[1] + effectNode.fadeDir[1]*dt/fadeTime))
			effectNode.fadeCur[2] = math.max(0, math.min(1, effectNode.fadeCur[2] + effectNode.fadeDir[2]*dt/fadeTime))

			setShaderParameter(effectNode.node, "morphPosition", effectNode.fadeCur[1], effectNode.fadeCur[2], 1, effectNode.scrollSpeed, false)

			local isVisible = true

			if self.state == MorphPositionEffect.STATE_TURNING_OFF and effectNode.fadeCur[1] == 1 then
				isVisible = false
				effectNode.fadeCur[1] = 0
				effectNode.fadeCur[2] = 0
			end

			setVisibility(effectNode.node, isVisible)

			if (self.state ~= MorphPositionEffect.STATE_TURNING_ON or effectNode.fadeCur[1] ~= 0 or effectNode.fadeCur[2] ~= 1) and (self.state ~= MorphPositionEffect.STATE_TURNING_OFF or effectNode.fadeCur[1] ~= 1 or effectNode.fadeCur[2] ~= 1) then
				runningEffectNodes = runningEffectNodes + 1
			end
		else
			runningEffectNodes = runningEffectNodes + 1
		end
	end

	if runningEffectNodes <= 0 then
		if self.state == MorphPositionEffect.STATE_TURNING_ON then
			self.state = MorphPositionEffect.STATE_ON
		elseif self.state == MorphPositionEffect.STATE_TURNING_OFF then
			self.state = MorphPositionEffect.STATE_OFF
		end
	end

	return 
end
MorphPositionEffect.isRunning = function (self)
	return self.state == MorphPositionEffect.STATE_TURNING_OFF or self.state == MorphPositionEffect.STATE_TURNING_ON
end
MorphPositionEffect.start = function (self)
	if self.state ~= MorphPositionEffect.STATE_TURNING_ON and self.state ~= MorphPositionEffect.STATE_ON then
		self.state = MorphPositionEffect.STATE_TURNING_ON

		for _, effectNode in pairs(self.effectNodes) do
			effectNode.fadeCur = {
				0,
				effectNode.fadeCur[2]
			}
			effectNode.fadeDir = {
				0,
				1
			}
			effectNode.currentDelay = effectNode.startDelay
		end

		return true
	end

	return false
end
MorphPositionEffect.stop = function (self)
	if self.state ~= MorphPositionEffect.STATE_TURNING_OFF and self.state ~= MorphPositionEffect.STATE_OFF then
		self.state = MorphPositionEffect.STATE_TURNING_OFF

		for _, effectNode in pairs(self.effectNodes) do
			effectNode.fadeDir = {
				1,
				1
			}
			effectNode.currentDelay = effectNode.stopDelay
		end

		return true
	end

	return false
end
MorphPositionEffect.reset = function (self)
	for _, effectNode in pairs(self.effectNodes) do
		effectNode.fadeCur = {
			0,
			0
		}
		effectNode.fadeDir = {
			0,
			1
		}

		setShaderParameter(effectNode.node, "morphPosition", effectNode.fadeCur[1], effectNode.fadeCur[2], 0, effectNode.scrollSpeed, false)
		setVisibility(effectNode.node, false)
	end

	self.state = MorphPositionEffect.STATE_OFF

	return 
end
MorphPositionEffect.setFillType = function (self, fillType)
	return 
end

return 
