HolmerHR9 = {
	prerequisitesPresent = function (specializations)
		return SpecializationUtil.hasSpecialization(FruitPreparer, specializations) and SpecializationUtil.hasSpecialization(Cutter, specializations)
	end,
	load = function (self, xmlFile)
		for i, part in ipairs(self.cutterTurnedOnRotationNodes.nodes) do
			part.turnOnOffVariance = getXMLFloat(xmlFile, string.format("vehicle.turnedOnRotationNodes.turnedOnRotationNode(%d)#turnOnOffVariance", i - 1))

			if part.turnOnOffVariance ~= nil then
				part.turnOnOffVariance = part.turnOnOffVariance*1000
				part.turnOnFadeTime = part.turnOnFadeTime + math.random(-part.turnOnOffVariance, part.turnOnOffVariance)
				part.turnOffFadeTime = part.turnOffFadeTime + math.random(-part.turnOnOffVariance, part.turnOnOffVariance)
			end
		end

		self.headersMeanTime = 135
		self.headersRandomTime = self.headersMeanTime*0.05
		self.headersNextTime = 0
		self.headersMoveSpeedPos = 0.004
		self.headersMoveSpeedNeg = 0.004
		self.lastHarvestTime = -1000
		self.headers = {}
		local i = 0

		while true do
			if not hasXMLProperty(xmlFile, string.format("vehicle.holmerHR9.headers.header(%d)", i)) then
				break
			end

			local header = {
				node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.holmerHR9.headers.header(%d)#index", i))),
				curDir = 1,
				nextTime = 1000,
				targetRot = math.rad(30)
			}

			table.insert(self.headers, header)

			i = i + 1
		end

		return 
	end,
	delete = function (self)
		return 
	end,
	mouseEvent = function (self, posX, posY, isDown, isUp, button)
		return 
	end,
	keyEvent = function (self, unicode, sym, modifier, isDown)
		return 
	end,
	update = function (self, dt)
		if self.isClient and self.getIsActive(self) then
			if self.lastCutterAreaBiggerZero == true then
				self.lastHarvestTime = g_currentMission.time
			end

			self.headersMovement = g_currentMission.time - self.lastHarvestTime < 100 and self.isLowered(self, false)

			for i, header in pairs(self.headers) do
				if header.nextTime < g_currentMission.time then
					local rx, ry, rz = getRotation(header.node)

					if header.curDir == 1 then
						rx = math.max(0, math.min(header.targetRot, rx + dt*self.headersMoveSpeedPos))
					else
						rx = math.max(0, math.min(header.targetRot, rx - dt*self.headersMoveSpeedNeg))
					end

					setRotation(header.node, rx, ry, rz)

					if rx == header.targetRot and header.curDir == 1 then
						header.curDir = -1
					end

					if rx == 0 and header.curDir == -1 and self.headersMovement then
						header.curDir = 1
						header.targetRot = math.rad(25) + math.rad(math.random(-5, 5))
						header.nextTime = g_currentMission.time + math.random(-self.headersRandomTime, self.headersRandomTime) + self.headersMeanTime
					end
				end
			end

			self.headersMeanTime = self.getLastSpeed(self, true)/3.6/450
			self.headersRandomTime = self.headersMeanTime*0.05
			self.headersMoveSpeedPos = (math.max(2, self.getLastSpeed(self, true))*0.004)/12
			self.headersMoveSpeedNeg = (math.max(2, self.getLastSpeed(self, true))*0.004)/12
		end

		return 
	end,
	draw = function (self)
		return 
	end,
	onLeave = function (self)
		return 
	end,
	onStartReel = function (self)
		self.setIsTurnedOn(self, true, true)

		for i, part in ipairs(self.cutterTurnedOnRotationNodes.nodes) do
			if part.turnOnOffVariance ~= nil then
				part.turnOffFadeTime = part.turnOffFadeTime + math.random(-part.turnOnOffVariance, part.turnOnOffVariance)
			end
		end

		for i, header in pairs(self.headers) do
			header.nextTime = g_currentMission.time
		end

		return 
	end,
	onStopReel = function (self)
		self.setIsTurnedOn(self, false, true)

		for i, part in ipairs(self.cutterTurnedOnRotationNodes.nodes) do
			if part.turnOnOffVariance ~= nil then
				part.turnOnFadeTime = part.turnOnFadeTime + math.random(-part.turnOnOffVariance, part.turnOnOffVariance)
			end
		end

		return 
	end
}

return 
