local modFilename, isMod, isDlc, dlcsDirectoryIndex = Utils.removeModDirectory(g_currentModDirectory)

if not _G.g_attacherPipeFix and isDlc and g_currentModName == "HolmerPack" then
	_G.g_attacherPipeFix = true
	local oldOnAttach = Fillable.onAttach
	Fillable.onAttach = function (self, attacherVehicle)
		local vehicle = nil

		if self.attacherPipe ~= nil then
			vehicle = Fillable.findAttacherPipeVehicle(attacherVehicle, self, true)

			if vehicle ~= nil then
				self.attachPipe(self, self, vehicle)
			end
		elseif self.attacherPipeRef ~= nil then
			vehicle = Fillable.findAttacherPipeVehicle(attacherVehicle, self, false)

			if vehicle ~= nil then
				vehicle.attachPipe(vehicle, vehicle, self)
			end
		end

		return 
	end
	local oldAttachPipe = Fillable.attachPipe
	Fillable.attachPipe = function (self, pipeVehicle, refVehicle)
		pipeVehicle.attacherPipeRefVehicle = refVehicle
		refVehicle.attacherPipeVehicle = pipeVehicle

		for _, movingPart in pairs(pipeVehicle.activeDirtyMovingParts) do
			if movingPart.node == pipeVehicle.attacherPipe then
				movingPart.referenceFrameBackUp = movingPart.referenceFrame
				movingPart.referenceFrame = refVehicle.attacherPipeRef
				movingPart.referenceFrameOffset = {
					0,
					0,
					0
				}

				Cylindered.updateMovingPart(self, movingPart, false)

				break
			end
		end

		return 
	end
	local oldFindAttacherPipeVehicle = Fillable.findAttacherPipeVehicle
	Fillable.findAttacherPipeVehicle = function (currentVehicle, lastVehicle, lookForPipeRef, ignoreVehicle)
		if lookForPipeRef then
			if currentVehicle.attacherPipeRef ~= nil and currentVehicle.attacherPipeVehicle == nil then
				return currentVehicle
			end
		elseif currentVehicle.attacherPipe ~= nil and currentVehicle.attacherPipeRefVehicle == nil then
			return currentVehicle
		end

		for _, implement in pairs(currentVehicle.attachedImplements) do
			if implement.object ~= nil and implement.object ~= lastVehicle and (ignoreVehicle == nil or ignoreVehicle ~= implement.object) then
				local ret = Fillable.findAttacherPipeVehicle(implement.object, lastVehicle, lookForPipeRef)

				if ret ~= nil then
					return ret
				end
			end
		end

		if currentVehicle.attacherVehicle ~= nil then
			return Fillable.findAttacherPipeVehicle(currentVehicle.attacherVehicle, currentVehicle, lookForPipeRef)
		end

		return nil
	end
	local oldDetachPipe = Fillable.detachPipe
	Fillable.detachPipe = function (self)
		if self.attacherPipeRefVehicle ~= nil then
			for _, movingPart in pairs(self.activeDirtyMovingParts) do
				if movingPart.node == self.attacherPipe then
					movingPart.referenceFrame = movingPart.referenceFrameBackUp

					break
				end
			end

			self.attacherPipeRefVehicle.attacherPipeVehicle = nil
			self.attacherPipeRefVehicle = nil
		end

		if self.attacherPipeVehicle ~= nil then
			for _, movingPart in pairs(self.attacherPipeVehicle.activeDirtyMovingParts) do
				if movingPart.node == self.attacherPipeVehicle.attacherPipe then
					movingPart.referenceFrame = movingPart.referenceFrameBackUp

					break
				end
			end

			self.attacherPipeVehicle.attacherPipeRefVehicle = nil
			local attacherPipeVehicle = self.attacherPipeVehicle
			self.attacherPipeVehicle = nil

			if attacherPipeVehicle.attacherVehicle ~= nil then
				local vehicle = Fillable.findAttacherPipeVehicle(attacherPipeVehicle.attacherVehicle, attacherPipeVehicle, true, self)

				if vehicle ~= nil then
					attacherPipeVehicle.attachPipe(attacherPipeVehicle, attacherPipeVehicle, vehicle)
				end
			end
		end

		return 
	end
end

return 
