--
-- Siloschild
--
-- M@D Author:  Heady
-- M@D date: 13.06.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

print("  Siloschild Script v1.0");



Siloschild = {};

function Siloschild.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Siloschild:load(xmlFile)

	self.addContactReports = Siloschild.addContactReports;
	self.removeContactReports = Siloschild.removeContactReports;
	--self.silagePlaneContactReport = Siloschild.silagePlaneContactReport;
	self.silagePlaneContactReport = SpecializationUtil.callSpecializationsFunction("silagePlaneContactReport");
	
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveFillDelta#literPerSecond"), 1500);
	
	self.contactReportNodes = {};
    local contactReportNodeFound = false;
    local i=0;
    while true do
        local baseName = string.format("vehicle.contactReportNodes.contactReportNode(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            local entry = {};
            entry.node = node;
			entry.hasGroundContact = false;
			entry.bgaSiloObject = nil;

            self.contactReportNodes[node] = entry;
            contactReportNodeFound = true;
        end;
        i = i+1;
    end;
    if not contactReportNodeFound then
        local entry = {};
        entry.node = self.components[1].node;
		entry.hasGroundContact = false;
		entry.bgaSiloObject = nil;
        self.contactReportNodes[entry.node] = entry;
    end;
	
	self.leftPlane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidePlanes#left"));
	self.rightPlane = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidePlanes#right"));
	
	self.isShovel = true;
	
	self.bgaSiloObject = nil;
	self.hasSilagePlaneContact = false;
	
	self.extendedCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.extendedCapacity"), self.capacity);
	self.backupCapacity = self.capacity;

end;


function Siloschild:delete()

	self:removeContactReports(self);

end;
	
function Siloschild:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Siloschild:keyEvent(unicode, sym, modifier, isDown)
end;

--function Siloschild:readStream(streamId, connection)
--end;

--function Siloschild:writeStream(streamId, connection)
--end;

function Siloschild:update(dt)
end;

function Siloschild:updateTick(dt)

	if self:getIsActive() then	
	
		if self.leftPlane ~= nil and self.rightPlane ~= nil then
			if self.foldAnimTime > 0.9 then
				setVisibility(self.leftPlane, true);
				setVisibility(self.rightPlane, true);
				self.capacity = self.extendedCapacity;
			else
				setVisibility(self.leftPlane, false);
				setVisibility(self.rightPlane, false);
				self.capacity = self.backupCapacity;
			end;
		end;
		
		if not self:isLowered(false) then
			self.isShovel = nil;
		else
			self.isShovel = true;
		end;

		if self.isServer then 
		
			local hasGroundContact = false;
			local bgaSiloObject = nil;
			if self.fillLevel > 0 then
			
				for k, v in pairs(self.contactReportNodes) do
					if v.hasGroundContact and v.bgaSiloObject ~= nil then
						hasGroundContact = true;
						bgaSiloObject = v.bgaSiloObject;
						break;
					end;
				end;
				if hasGroundContact and bgaSiloObject ~= nil then
				
					if self.movingDirection > 0 and self:isLowered(false) then				
						local m = self.literPerSecond * (dt/1000);					
						local fillDelta = math.min(m, self.fillLevel);	
						bgaSiloObject:updateMoving(fillDelta);					
						self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);									
					end;
					if self.movingDirection < 0 or not self:isLowered(false) then
						bgaSiloObject:updateMoving(self.fillLevel);
						self:setFillLevel(0, self.currentFillType);					
					end;
					
				end;
				
			end;
		
		end;
		
	end;	

end;

function Siloschild:draw()
end;

function Siloschild:onAttach(attacherVehicle)
	self:addContactReports();
end;

function Siloschild:onDetach()
	self:removeContactReports();
end;

function Siloschild:onEnter(isControlling)
	self:addContactReports();
end;

function Siloschild:onLeave()
	self:removeContactReports();
end;

function Siloschild:addContactReports()
	for k, v in pairs(self.contactReportNodes) do
		addContactReport(v.node, 0.0001, "silagePlaneContactReport", self);
	end;
    
end;

function Siloschild:removeContactReports()	
	for k, v in pairs(self.contactReportNodes) do
		removeContactReport(v.node);
		v.hasGroundContact = false;
	end;
end;

function Siloschild:silagePlaneContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)


	for i=1, table.getn(MapBGASilo.ModEvent.silos) do
		local silo = MapBGASilo.ModEvent.silos[i];
		
	    if otherObjectId == getParent(silo.silage.plane) then
			if silo.silage.allowFillTypes[self.currentFillType] or self.currentFillType == Fillable.FILLTYPE_UNKNOWN then 
			
			    local entry = self.contactReportNodes[objectId];
				if entry ~= nil then				
					if isStart then
						entry.hasGroundContact = true;
						entry.bgaSiloObject = silo;
					else
						entry.hasGroundContact = false;
						entry.bgaSiloObject = nil;					
					end;
				end;
			end;
		end;
	
	end;

end;
