--
--
-- TrailerHTT
--
-- # Author:  Heady
-- # date: 03.02.2015
-- # last update: 31.10.2015
--
-- > Not for commercial use  < --
-- > Not allowed for edit - Copyright (C) Heady - www.planet-ls.de < --
--


TrailerHTT = {};

local modDir = g_currentModDirectory;
TrailerHTT.version = "15.0.1";

function TrailerHTT:prerequisitesPresent(specializations)
    return true;
end;

function TrailerHTT:load(xmlFile)

	--self.toggleTipState = Utils.appendedFunction(self.toggleTipState, TrailerHTT.toggleTipState);
	--self.onStartTip = Utils.overwrittenFunction(self.onStartTip, TrailerHTT.onStartTip);	
	--self.onStartTip = Utils.appendedFunction(self.onStartTip, TrailerHTT.onStartTip);
	--self.onEndTip = Utils.appendedFunction(self.onEndTip, TrailerHTT.onEndTip);

	self.heapTipTrigger = {};

	self.heapTipTrigger.tipRefPointIndex = 1;
	
	self.heapTipTrigger.allowToCreateNext = false;
	self.heapTipTrigger.wasCreatet = false;

	self.heapTipTrigger.warningTime = 0;
	self.heapTipTrigger.printWarning = false;
	
	self.printStrg = false;
	self.createHeapTipTrigger = false;
	self.allowToHTPTip = false;
	self.toggleHTPTip = false;
	
	self.tipRefpivotNodes = {};
	for i=1, table.getn(self.tipReferencePoints) do
		local tipRef = self.tipReferencePoints[i];
		local pivot = {};
		pivot.pivotNode = getChildAt(Utils.loadSharedI3DFile("pivot.i3d", modDir), 0);
		link(tipRef.node, pivot.pivotNode);
		setVisibility(pivot.pivotNode, false);
		table.insert(self.tipRefpivotNodes, pivot);
	end;

end;


function TrailerHTT:delete()
end;
	
function TrailerHTT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TrailerHTT:keyEvent(unicode, sym, modifier, isDown)
end;

function TrailerHTT:readStream(streamId, connection)
    if connection:getIsServer() then
        self.heapTipTrigger.tipRefPointIndex = streamReadInt8(streamId);
    end
end;

function TrailerHTT:writeStream(streamId, connection)
    if not connection:getIsServer() then
        streamWriteInt8(streamId, self.heapTipTrigger.tipRefPointIndex);
    end;
end;

function TrailerHTT:update(dt)

	if table.getn(self.tipReferencePoints) > 0 then
		if self.isClient then
			--for i=1, table.getn(self.tipReferencePoints) do
			for i=1, table.getn(self.tipRefpivotNodes) do
				--local tipRef = self.tipReferencePoints[i];
				local tipRef = self.tipRefpivotNodes[i];
				setVisibility(tipRef.pivotNode, false);
			end;
			

			if self.heapTipTrigger.tipRefPointIndex > table.getn(self.tipReferencePoints) then
				self.heapTipTrigger.tipRefPointIndex = table.getn(self.tipReferencePoints);
				TrailerHTTMPEvent:updateSendEvent(self);
			end;
			
			if self:getIsActive() then
			
				if self:getIsActiveForInput(true) then
				
					if InputBinding.hasEvent(InputBinding.HEAPTIPTRIGGER_SWITCHTIPREFPOINT) then
						self.heapTipTrigger.tipRefPointIndex = self.heapTipTrigger.tipRefPointIndex +1;
						if self.heapTipTrigger.tipRefPointIndex > table.getn(self.tipReferencePoints) then
							self.heapTipTrigger.tipRefPointIndex = 1;
						end;
						TrailerHTTMPEvent:updateSendEvent(self);
					end;
					
					if ( self.tipState == Trailer.TIPSTATE_CLOSED or self.tipState == Trailer.TIPSTATE_CLOSING ) then --and not self.create_HeapTipTrigger then
						if InputBinding.hasEvent(InputBinding.HEAPTIPTRIGGER_CREATE) then
							if g_currentMission:canCreateHeapTipTrigger(self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].node) then
								local x,y,z = getWorldTranslation(self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].node);
								self.HTPObject = g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].node));
								self.toggleHTPTip = true;
							else
								self.heapTipTrigger.printWarning = true;
							end;
						end;
						if Input.isKeyPressed(Input.KEY_lctrl) then
							self.printStrg = true;
							
							--[[for i=1, table.getn(self.tipReferencePoints) do
								--local tipRef = self.tipReferencePoints[i];
								local tipRef = self.tipRefpivotNodes[i];
								setVisibility(tipRef.pivotNode, false);
							end;]]
							--setVisibility(self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].pivotNode, true);
							setVisibility(self.tipRefpivotNodes[self.heapTipTrigger.tipRefPointIndex].pivotNode, true);
							
							g_currentMission:addHelpButtonText(g_i18n:getText("HEAPTIPTRIGGER_SWITCHTIPREFPOINT"), InputBinding.HEAPTIPTRIGGER_SWITCHTIPREFPOINT);
							g_currentMission:addHelpButtonText(g_i18n:getText("HEAPTIPTRIGGER_CREATE"), InputBinding.HEAPTIPTRIGGER_CREATE);
						else
							self.printStrg = false;

						end;
					end;
					
					if self.heapTipTrigger.printWarning then 
						self.heapTipTrigger.warningTime = self.heapTipTrigger.warningTime + dt;
						g_currentMission:addWarning(g_i18n:getText("StoreInvalidPlacementPosition"));
						if self.heapTipTrigger.warningTime > 1500 then
							self.heapTipTrigger.printWarning = false;
							self.heapTipTrigger.warningTime = 0;
						end;
					end;
					
				end;
				
			end;			
		end;
		

		
		
		if self.isServer then

				if self.currentTipTrigger ~= nil then
					if self.currentTipTrigger.isHTP ~= nil then --and (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) then
						if self.currentTipTrigger.isHTP then
							if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
								self.heapTipTrigger.allowToCreateNext = true;
							else
								self.heapTipTrigger.allowToCreateNext = false;
							end;
						end;
					end;
				end;	
			if self.tipState == Trailer.TIPSTATE_CLOSED or self.fillLevel < 1 then
				self.heapTipTrigger.allowToCreateNext = false;
			end;
				
			if self.tipReferencePoints ~= nil then--
				if self.currentTipTrigger == nil and self.heapTipTrigger.allowToCreateNext then
					if g_currentMission:canCreateHeapTipTrigger(self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].node) then
						local x,y,z = getWorldTranslation(self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].node);
						self.currentTipTrigger = g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].node));
						self:onStartTip(self.currentTipTrigger, self.heapTipTrigger.tipRefPointIndex);	
						self.heapTipTrigger.allowToCreateNext = false;
						self.heapTipTrigger.wasCreatet = true;
					end;
				end;
				
				if not self.heapTipTrigger.wasCreatet then
					local trailerInTipRange, tipTrigger, tipTriggerIsAllowed, tipReferencePointIndex = g_currentMission:getTrailerInTipRange(self, self.tipReferencePoints[self.heapTipTrigger.tipRefPointIndex].width);
					--print("self == trailerInTipRange: "..tostring(self == trailerInTipRange).." tipTrigger: "..tostring(tipTrigger).." tipTriggerIsAllowed: "..tostring(tipTriggerIsAllowed))
					if self == trailerInTipRange and tipTriggerIsAllowed and tipTrigger ~= nil then
						if tipTrigger.isHTP ~= nil then
							if tipTrigger.isHTP then
								self.currentTipTrigger = tipTrigger;
							end;
						end;
					end;
				end;
			end;
			self.heapTipTrigger.wasCreatet = false;
		end;
		
	end;

	--[[if self.isServer then
		if self.createHeapTipTrigger then
			--print("createhtt")
			local trailerInTipRange, currentTipTrigger, currentTipTriggerIsAllowed, currentTipReferencePointIndex = g_currentMission:getTrailerInTipRange(self, self.tipReferencePoints[self.httTipRefPointIndex].width);
			--if g_currentMission.currentTipTrigger ~= nil and g_currentMission.currentTipTrigger ~= self.lastHeapTipTrigger then	-- client driver, g_currentMission.currentTipTrigger = nil
			if self == trailerInTipRange and currentTipTriggerIsAllowed and currentTipTrigger ~= nil then	-- client driver, g_currentMission.currentTipTrigger = nil
				if currentTipTrigger.isHTP ~= nil then
					self.currentTipTrigger = currentTipTrigger;
					--print("toggle tip heap")
					self.createHeapTipTrigger = false;
				end;
			end;
			--if self.currentTipTrigger == nil and g_currentMission:canCreateHeapTipTrigger(self.tipReferencePoints[1].node) then
			if self.currentTipTrigger == nil and g_currentMission:canCreateHeapTipTrigger(self.tipReferencePoints[self.httTipRefPointIndex].node) then
				local x,y,z = getWorldTranslation(self.tipReferencePoints[self.httTipRefPointIndex].node);
				self.currentTipTrigger = g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.tipReferencePoints[self.httTipRefPointIndex].node));
				self:onStartTip(self.currentTipTrigger, self.currentTipReferencePointIndex);
				--print("create heap + start tip")
				self.createHeapTipTrigger = false;
			end;
		end;
		
		if self.toggleHTPTip and self.HTPObject ~= nil then
			if g_currentMission.currentTipTrigger ~= nil and g_currentMission.currentTipTriggerIsAllowed then
				self:onStartTip(self.HTPObject, self.httTipRefPointIndex);
				self.toggleHTPTip = false;
				self.HTPObject = nil;
				--print("toggle start tip manuell create")
			end;
		end;
	end;]]

end;

function TrailerHTT:updateTick(dt)
end;

function TrailerHTT:draw()
end;


TrailerHTTMPEvent = {};
TrailerHTTMPEvent_mt = Class(TrailerHTTMPEvent, Event);

InitEventClass(TrailerHTTMPEvent, "TrailerHTTMPEvent");

function TrailerHTTMPEvent:emptyNew()
    local self = Event:new(TrailerHTTMPEvent_mt);
    self.className="TrailerHTTMPEvent";
    return self;
end;

function TrailerHTTMPEvent:new(object)
    local self = TrailerHTTMPEvent:emptyNew()
    self.object = object;
    return self;
end;

function TrailerHTTMPEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));	
	
	self.object.heapTipTrigger.tipRefPointIndex = streamReadInt8(streamId);
	
	if not connection:getIsServer() then -- if server read then send to clients
		g_server:broadcastEvent(TrailerHTTMPEvent:new(self.object), nil, connection, self.object);
	end;
end;

function TrailerHTTMPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteInt8(streamId, self.object.heapTipTrigger.tipRefPointIndex);	
end;

function TrailerHTTMPEvent:updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(TrailerHTTMPEvent:new(runSelf));
	else
		g_client:getServerConnection():sendEvent(TrailerHTTMPEvent:new(runSelf));
	end;

end;
