--
--
-- ShovelHTT
--
-- # Author:  Heady
-- # date: 03.02.2015
-- # last update: 03.02.2015
--
-- > Not for commercial use  < --
-- > Not allowed for edit - Copyright (C) Heady - www.planet-ls.de < --
--


ShovelHTT = {};

local modDir = g_currentModDirectory;
ShovelHTT.version = "15.0.1";

function ShovelHTT:prerequisitesPresent(specializations)
    return true;
end;

function ShovelHTT:load(xmlFile)

	self.heapTipTrigger = {};
	self.heapTipTrigger.warningTime = 0;
	self.heapTipTrigger.printWarning = false;

end;


function ShovelHTT:delete()
end;
	
function ShovelHTT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShovelHTT:keyEvent(unicode, sym, modifier, isDown)
end;

--function ShovelHTT:readStream(streamId, connection)
--end;

--function ShovelHTT:writeStream(streamId, connection)
--end;

function ShovelHTT:update(dt)
		
	if self:getIsActive() then	
		if self:getIsActiveForInput(true) then
			
			if self.shovelTipReferenceNode ~= nil then
				if InputBinding.hasEvent(InputBinding.HEAPTIPTRIGGER_CREATE) then
					if g_currentMission:canCreateHeapTipTrigger(self.shovelTipReferenceNode) then
						local x,y,z = getWorldTranslation(self.shovelTipReferenceNode);
						self.HTPObject = g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.shovelTipReferenceNode));
					else						
						self.heapTipTrigger.printWarning = true;
					end;
				end;
				if Input.isKeyPressed(Input.KEY_lctrl) then				
					g_currentMission:addHelpButtonText(g_i18n:getText("HEAPTIPTRIGGER_CREATE"), InputBinding.HEAPTIPTRIGGER_CREATE);
				end;
			end;
			if self.heapTipTrigger.printWarning then 
				self.heapTipTrigger.warningTime = self.heapTipTrigger.warningTime + dt;
				g_currentMission:addWarning(g_i18n:getText("StoreInvalidPlacementPosition"));
				if self.heapTipTrigger.warningTime > 1500 then
					self.heapTipTrigger.printWarning = false;
					self.heapTipTrigger.warningTime = 0;
				end;
			end;
			
		end;		
	end;

end;

function ShovelHTT:updateTick(dt)
end;

function ShovelHTT:draw()
end;

