--
--
-- OverloadingHTT
--
-- # Author:  Heady
-- # date: 27.10.2015
-- # last update: 30.10.2015
--
-- > Not for commercial use  < --
-- > Not allowed for edit - Copyright (C) Heady - www.planet-ls.de < --
--


OverloadingHTT = {};

local modDir = g_currentModDirectory;
OverloadingHTT.version = "15.0.1";

function OverloadingHTT:prerequisitesPresent(specializations)
    return true;
end;

function OverloadingHTT:load(xmlFile)

	self.heapTipTrigger = {};
	self.heapTipTrigger.warningTime = 0;
	self.heapTipTrigger.printWarning = false;

end;


function OverloadingHTT:delete()
end;
	
function OverloadingHTT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OverloadingHTT:keyEvent(unicode, sym, modifier, isDown)
end;

--function OverloadingHTT:readStream(streamId, connection)
--end;

--function OverloadingHTT:writeStream(streamId, connection)
--end;

function OverloadingHTT:update(dt)
		
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			 if self.pipeStateIsUnloading[self.currentPipeState] or self.numPipeStates == 0 then
			
				if self.pipeRaycastNode ~= nil then
					if InputBinding.hasEvent(InputBinding.HEAPTIPTRIGGER_CREATE) then
						if g_currentMission:canCreateHeapTipTrigger(self.pipeRaycastNode) then
							local x,y,z = getWorldTranslation(self.pipeRaycastNode);
							self.HTPObject = g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.pipeRaycastNode));
						else						
							self.heapTipTrigger.printWarning = true;
						end;
					end;
					if Input.isKeyPressed(Input.KEY_lctrl) then				
						g_currentMission:addHelpButtonText(g_i18n:getText("HEAPTIPTRIGGER_CREATE"), InputBinding.HEAPTIPTRIGGER_CREATE);
					end;
				end;
				if self.heapTipTrigger.printWarning then 
					self.heapTipTrigger.warningTime = self.heapTipTrigger.warningTime + dt;
					g_currentMission:addWarning(g_i18n:getText("StoreInvalidPlacementPosition"));
					if self.heapTipTrigger.warningTime > 1500 then
						self.heapTipTrigger.printWarning = false;
						self.heapTipTrigger.warningTime = 0;
					end;
				end;
				
			end;
		end;		
	end;

end;

function OverloadingHTT:updateTick(dt)
end;

function OverloadingHTT:draw()
end;

