--
--
--
-- # Author:  Heady
-- # date: 15.12.2014
-- # last update: 01.11.2015
--
-- > Not for commercial use  < --
-- > Not allowed for edit - Copyright (C) Heady - www.planet-ls.de < --
--

local modDir = g_currentModDirectory;

ModEvent = {};

SpecializationUtil.registerSpecialization("TrailerHTT", "TrailerHTT", modDir.."TrailerHTT.lua")
SpecializationUtil.registerSpecialization("ShovelHTT", "ShovelHTT", modDir.."ShovelHTT.lua")
SpecializationUtil.registerSpecialization("OverloadingHTT", "OverloadingHTT", modDir.."OverloadingHTT.lua")
--local version = SpecializationUtil.getSpecialization("TrailerHTT").version;
--g_i18n.globalI18N.texts["SteeringAxle"] = g_i18n:getText("SteeringAxle"); 


function ModEvent:loadMap(name)	
	
	if self.firstRun == nil then
		self.firstRun = false;
		--print("  register spec TrailerHTT v"..tostring(version));
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				local allowInsertion2 = false;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and ( vs == SpecializationUtil.getSpecialization("TrailerHTT") or vs == SpecializationUtil.getSpecialization("OverloadingHTT") ) then
						allowInsertion = false;
					end;
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("shovel") then						
						local v_name_string = v.name;
						local point_location = string.find(v_name_string, ".", nil, true);
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.ShovelHTT", _name)) then
								allowInsertion = false;
							end;
						end;
						allowInsertion2 = true;
					end;
				end;
				if allowInsertion and allowInsertion2 then
					table.insert(v.specializations, SpecializationUtil.getSpecialization("ShovelHTT"));
				end;
			end;	
		end;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				local allowInsertion2 = false;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and ( vs == SpecializationUtil.getSpecialization("TrailerHTT") or vs == SpecializationUtil.getSpecialization("ShovelHTT") ) then
						allowInsertion = false;
					end;
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("overloading") then						
						local v_name_string = v.name;
						local point_location = string.find(v_name_string, ".", nil, true);
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.OverloadingHTT", _name)) then
								allowInsertion = false;
							end;
						end;
						allowInsertion2 = true;
					end;
				end;
				if allowInsertion and allowInsertion2 then
					table.insert(v.specializations, SpecializationUtil.getSpecialization("OverloadingHTT"));
				end;
			end;	
		end;
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				local allowInsertion2 = false;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and ( vs == SpecializationUtil.getSpecialization("ShovelHTT") or vs == SpecializationUtil.getSpecialization("OverloadingHTT") )then
						allowInsertion = false;
					end;
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("trailer") then						
						local v_name_string = v.name;
						local point_location = string.find(v_name_string, ".", nil, true);
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.TrailerHTT", _name)) then
								allowInsertion = false;
							end;
						end;
						allowInsertion2 = true;
					end;
				end;
				if allowInsertion and allowInsertion2 then
					table.insert(v.specializations, SpecializationUtil.getSpecialization("TrailerHTT"));
				end;
			end;		
		end;
		
		g_i18n.globalI18N.texts["HEAPTIPTRIGGER_SWITCHTIPREFPOINT"] = g_i18n:getText("HEAPTIPTRIGGER_SWITCHTIPREFPOINT");
		g_i18n.globalI18N.texts["HEAPTIPTRIGGER_CREATE"] = g_i18n:getText("HEAPTIPTRIGGER_CREATE");
		
	end;

end;

function ModEvent:deleteMap()
end;

function ModEvent:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ModEvent:keyEvent(unicode, sym, modifier, isDown)
end;

function ModEvent:update(dt)

	--if g_currentMission:getIsClient() then
		--g_currentMission.trailerInTipRange, g_currentMission.currentTipTrigger, g_currentMission.currentTipTriggerIsAllowed, g_currentMission.currentTipReferencePointIndex = g_currentMission:getTrailerInTipRange();
	--end
	--print("trailerInTipRange: "..tostring(g_currentMission.trailerInTipRange).." currentTipTrigger: "..tostring(g_currentMission.currentTipTrigger).." currentTipTriggerIsAllowed: "..tostring(g_currentMission.currentTipTriggerIsAllowed).." currentTipReferencePointIndex: "..tostring(g_currentMission.currentTipReferencePointIndex));
end;

function ModEvent:draw()
end;

addModEventListener(ModEvent);


--local BaseMissionGetIsTrailerInTipRange = BaseMission.getIsTrailerInTipRange;
--BaseMission.getTrailerInTipRange = function(g_currentMission, trailer, tipRefWidth)

--[[BaseMission.getTrailerInTipRange = function(self, trailer, tipRefWidth)
	if tipRefWidth == nil then
		tipRefWidth = self.tipTriggerRangeThreshold;
	end
	local retTrailer, retTrigger = nil, nil;
	local retIsAllowed = false;
	local retTipReferencePointIndex = nil;
	
	local trailerTriggers = {};
	local distanceT = {};
  
	if trailer ~= nil then
		if trailer.fillRootNode ~= nil and trailer.tipReferencePoints ~= nil and table.getn(trailer.tipReferencePoints) > 0 then
			local triggers = self.trailerTipTriggers[trailer];
			if triggers ~= nil then
				for _,tipTrigger in pairs(triggers) do
					local isAllowed, distance, tipReferencePointIndex = tipTrigger:getTipInfoForTrailer(trailer);
				  
					local temp = {};
					temp[1] = trailer;
					temp[2] = tipTrigger;
					temp[3] = isAllowed;
					temp[4] = tipReferencePointIndex;
					temp[5] = distance;
					print("in trailer: "..tostring(temp[1]).." tipTrigger: "..tostring(temp[2]).." isAllowed: "..tostring(temp[3]).." tipReferencePointIndex: "..tostring(temp[4]).." distance: "..tostring(temp[5]))
					table.insert(trailerTriggers, temp);
					table.insert(distanceT, distance);
				end;
			end
		end
	end;
	if trailer == nil then
		trailer = self.controlledVehicle;
		if trailer ~= nil then
			for _,implement in pairs(trailer.attachedImplements) do
				if implement.object ~= nil then
					local tempRetTrailer, tempRetTrigger, tempRetIsAllowed, tempRetTipReferencePointIndex, newMinDistance = self:getTrailerInTipRange(implement.object, tipRefWidth);
					if tempRetTrailer ~= nil then
						local temp = {};
						temp[1] = tempRetTrailer;
						temp[2] = tempRetTrigger;
						temp[3] = tempRetIsAllowed;
						temp[4] = tempRetTipReferencePointIndex;
						temp[5] = newMinDistance;
						table.insert(trailerTriggers, temp);
						table.insert(distanceT, newMinDistance);
					end;
				end;
			end;
		end;
    end
	if table.getn(trailerTriggers) == 0 then
		return nil, nil, retIsAllowed, nil, tipRefWidth;
	end;
	local minDistance = math.min(unpack(distanceT));
	for i=1, table.getn(trailerTriggers) do
		local to = trailerTriggers[i];
		if to[5] == minDistance then			
			print("out trailer: "..tostring(to[1]).." tipTrigger: "..tostring(to[2]).." isAllowed: "..tostring(to[3]).." tipReferencePointIndex: "..tostring(to[4]).." distance: "..tostring(to[5]))
			return to[1], to[2], to[3], to[4], to[5];
		end;
	end;
end;]]


-- ls13
--[[BaseMission.getTrailerInTipRange = function(l_51_0, l_51_1, l_51_2)
  if l_51_2 == nil then
    l_51_2 = l_51_0.tipTriggerRangeThreshold
  end
  local retTrailer, retTrigger = nil, nil
  local retIsAllowed = false
  local retTipReferencePointIndex = nil
  if l_51_1 == nil then
    l_51_1 = l_51_0.controlledVehicle
  end
  if l_51_1 ~= nil then
    if l_51_1.fillRootNode ~= nil and l_51_1.tipReferencePoints ~= nil and table.getn(l_51_1.tipReferencePoints) > 0 then
      local triggers = l_51_0.trailerTipTriggers[l_51_1]
      if triggers ~= nil then
        for _,tipTrigger in pairs(triggers) do
          local isAllowed, distance, tipReferencePointIndex = tipTrigger:getTipInfoForTrailer(l_51_1)
          if tipReferencePointIndex ~= nil then
            local use = false
            if isAllowed and (distance < l_51_2 or retIsAllowed or distance < l_51_0.tipTriggerRangeThreshold) then
              use = true
              do return end
              if not retIsAllowed and distance < l_51_2 then
                use = true
              end
            end
            if use then
              retTrailer = l_51_1
              retTrigger = tipTrigger
              retIsAllowed = isAllowed
              retTipReferencePointIndex = tipReferencePointIndex
              l_51_2 = distance
            end
          end
        end
      end
    end
    for _,implement in pairs(l_51_1.attachedImplements) do
      if implement.object ~= nil then
        local tempRetTrailer, tempRetTrigger, tempRetIsAllowed, tempRetTipReferencePointIndex, newMinDistance = l_51_0:getTrailerInTipRange(implement.object, l_51_2)
        if tempRetTrailer ~= nil then
          retTrailer = tempRetTrailer
          retTrigger = tempRetTrigger
          retIsAllowed = tempRetIsAllowed
          retTipReferencePointIndex = tempRetTipReferencePointIndex
        end
        l_51_2 = newMinDistance
      end
    end
  end
  return retTrailer, retTrigger, retIsAllowed, retTipReferencePointIndex, l_51_2
end]]
