--
-- HeapTipTrigger
--
-- # Author:  Heady
-- # date: 13.06.2011
-- # update LS15: 1.11.2014
-- # last update: 19.01.2015
--
-- > Not for commercial use  < --
-- > Not allowed for edit - Copyright (C) Heady - www.planet-ls.de < --
--

print("  HeapTipTrigger v15.0.2");

local modDir = g_currentModDirectory;
g_currentModDirectoryOfHeapTipTrigger = modDir.."heapTipTrigger.xml";
BaseMission.modDirectoryOfHeapTipTrigger = modDir.."heapTipTrigger.xml";

if BaseMission.modHeapTipTriggerAddon == nil then
	BaseMission.modHeapTipTriggerAddon = {};
	print("  Register Variable: BaseMission.modHeapTipTriggerAddon");
end;

BaseMission.heapTipTriggers = {};


HeapTipTrigger = {};

function HeapTipTrigger.prerequisitesPresent(specializations)
    return true;
end;

--example: if g_currentMission.modDirectoryOfHeapTipTrigger ~= nil then g_currentMission:createNewHeapTipTrigger(x, Y offset std: 0.5, z, yRot);

function BaseMission:createNewHeapTipTrigger(positionX, offsetY, positionZ, yRot)
	if positionX ~= nil or positionZ ~= nil then	
		local yOffset = Utils.getNoNil(offsetY, 0.5);
		local yr = Utils.getNoNil(yRot, math.random(0, 2*math.pi));

		if g_server ~= nil then
			local vehicle = g_currentMission:loadVehicle(g_currentModDirectoryOfHeapTipTrigger, positionX, yOffset, positionZ, yr);
			return vehicle; --only possible return on server; if you need it on client, you must make a send event on your script
		else
			g_client:getServerConnection():sendEvent(HeapTipTriggerCreateNewMPEvent:new(positionX, yOffset, positionZ, yr));
		end;
	else
		print("HeapTipTrigger not created, positionX or positionZ is nil");
	end;
	
end;

function BaseMission:getYRotHeapTipTrigger(node)

	if node ~= nil then	
		local xd, yd, zd = localDirectionToWorld(node, 0, 0, 1);		
		return Utils.getYRotationFromDirection(xd, zd);
	end;
end;

function BaseMission:canCreateHeapTipTrigger(node)

	if node ~= nil then	
		local nearestDistance = 2.2;
		local px, py, pz = getWorldTranslation(node);
		for i=1, table.getn(g_currentMission.heapTipTriggers) do
			local trigger = g_currentMission.heapTipTriggers[i];
			local vx, vy, vz = getWorldTranslation(trigger.rootNode);
			local distance = Utils.vector2Length(px-vx, pz-vz);

			if distance < nearestDistance then
				-- not allowed to create htt
				return false;
			end;
		end;
		return true;
	end;
	return false;
end;


function HeapTipTrigger:load(xmlFile)

	self.setFillLevel = Utils.overwrittenFunction(self.setFillLevel, HeapTipTrigger.setFillLevel);
	self.tipTriggerCallback = HeapTipTrigger.tipTriggerCallback;
	self.updateMoving = HeapTipTrigger.updateMoving;
	self.shovelGetCallback = HeapTipTrigger.shovelGetCallback;
	self.getTipInfoForTrailer = HeapTipTrigger.getTipInfoForTrailer;
	self.getNoAllowedText = HeapTipTrigger.getNoAllowedText;
	self.updateTrailerTipping = HeapTipTrigger.updateTrailerTipping;
	self.setStatic = HeapTipTrigger.setStatic;
	self.getShowInfo = HeapTipTrigger.getShowInfo;

	self.isHTP = true;
	
	g_currentMission:addTipTrigger(self);
	self.triggerId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipTrigger#index"));
	
	self.triggerStartId = self.triggerId;
	self.triggerTipWidth = math.huge;
	
	local id = self.triggerId;
    self.isAreaTrigger = Utils.getNoNil(getNumOfChildren(id) > 0, false);
    if self.isAreaTrigger then
        self.triggerStartId = getChildAt(id, 0);
        self.triggerEndId = getChildAt(id, 1);
        self.triggerWidth = Utils.getNoNil(getUserAttribute(id, "triggerWidth"), 5);
    end;
	
	addTrigger(self.triggerId, "tipTriggerCallback", self);

	
	if self.priceMultipliers == nil or self.acceptedFillTypes == nil then
        self.acceptedFillTypes = {};
        self.priceMultipliers = {};

        local fillTypes = getXMLString(xmlFile, "vehicle.fillTypes#fruitTypes");
        if fillTypes ~= nil then
            local types = Utils.splitString(" ", fillTypes);
            for k,v in pairs(types) do
                local desc = Fillable.fillTypeNameToDesc[v];
                if desc ~= nil then
                    self.acceptedFillTypes[desc.index] = true;
                    self.priceMultipliers[desc.index] = 0;
                end;
            end;
        end;
    end
	
	self.moveNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fillPlanes#moveNode"));
	addTrigger(self.moveNode, "shovelGetCallback", self);
	
	g_currentMission:addNodeObject(self.moveNode, self); -- raycast callback; shovel, etc.
	
	self.trailersInTrigger = {};
	
	self.currentShovel = nil;
	self.currentShovelNode = nil;


	self.allowToRemove = false;
	self.removeTime = 2000;
	
	self.waitToStaticTime = 0;
	self.isStatic = false;
	
	self.playerInRange = false;
	

	-- add from heaptiptrigger addon	
	for i=1, table.getn(g_currentMission.modHeapTipTriggerAddon) do
		local addonModDir = g_currentMission.modHeapTipTriggerAddon[i];
		local addonxmlFile = loadXMLFile("TempConfig", addonModDir.."HeapTipTriggerAddon.xml");
		
		local fillTypes = getXMLString(addonxmlFile, "addon.addFillTypes#fillTypes");
        if fillTypes ~= nil then
            local types = Utils.splitString(" ", fillTypes);
            for k,v in pairs(types) do
                local desc = Fillable.fillTypeNameToDesc[v];
                if desc ~= nil then
					self.fillTypes[desc.index] = true;
                    self.acceptedFillTypes[desc.index] = true;
                    self.priceMultipliers[desc.index] = 0;
                end;
            end;
        end;
		
        local i = 0;
        while true do
            local key = string.format("addon.fillPlanes.fillPlane(%d)", i);
            if not hasXMLProperty(addonxmlFile, key) then
                break;
            end;
            local fillPlane = {};
            fillPlane.nodes = {};
            local fillType = getXMLString(addonxmlFile, key.."#type");
            if fillType ~= nil then
                local nodeI = 0;
                while true do
                    local nodeKey = key..string.format(".node(%d)", nodeI);
                    if not hasXMLProperty(addonxmlFile, nodeKey) then
                        break;
                    end;
					
					local i3dNode = Utils.loadSharedI3DFile("HeapTipTriggerAddon.i3d", addonModDir);
					local node = getChildAt(i3dNode, getXMLInt(addonxmlFile, nodeKey.."#index"))
					link(self.moveNode, node);
					delete(i3dNode);
							
                    if node ~= nil then
                        local defaultX, defaultY, defaultZ = getTranslation(node);
                        local defaultRX, defaultRY, defaultRZ = getRotation(node);
                        setVisibility(node, false);

                        local animCurve = AnimCurve:new(linearInterpolatorTransRotScale);
                        local keyI = 0;
                        while true do
                            local animKey = nodeKey..string.format(".key(%d)", keyI);
                            local keyTime = getXMLFloat(addonxmlFile, animKey.."#time");
                            local x,y,z = Utils.getVectorFromString(getXMLString(addonxmlFile, animKey.."#translation"));
                            if y == nil then
                                y = getXMLFloat(addonxmlFile, animKey.."#y");
                            end;
                            local rx,ry,rz = Utils.getVectorFromString(getXMLString(addonxmlFile, animKey.."#rotation"));
                            local sx,sy,sz = Utils.getVectorFromString(getXMLString(addonxmlFile, animKey.."#scale"));
                            if keyTime == nil then
                                break;
                            end;
                            local x = Utils.getNoNil(x, defaultX);
                            local y = Utils.getNoNil(y, defaultY);
                            local z = Utils.getNoNil(z, defaultZ);
                            local rx = Utils.getNoNil(rx, defaultRX);
                            local ry = Utils.getNoNil(ry, defaultRY);
                            local rz = Utils.getNoNil(rz, defaultRZ);
                            local sx = Utils.getNoNil(sx, 1);
                            local sy = Utils.getNoNil(sy, 1);
                            local sz = Utils.getNoNil(sz, 1);
                            animCurve:addKeyframe({x=x, y=y, z=z, rx=rx, ry=ry, rz=rz, sx=sx, sy=sy, sz=sz, time = keyTime});
                            keyI = keyI +1;
                        end;
                        if keyI == 0 then
                            local minY, maxY = Utils.getVectorFromString(getXMLString(addonxmlFile, nodeKey.."#minMaxY"));
                            local minY = Utils.getNoNil(minY, defaultY);
                            local maxY = Utils.getNoNil(maxY, defaultY);
                            animCurve:addKeyframe({x=defaultX, y=minY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 0});
                            animCurve:addKeyframe({x=defaultX, y=maxY, z=defaultZ, rx=defaultRX, ry=defaultRY, rz=defaultRZ, sx=1, sy=1, sz=1, time = 1});
                        end;
                        table.insert(fillPlane.nodes, {node=node, animCurve = animCurve});
                    end;
                    nodeI = nodeI +1;
                end;
                if table.getn(fillPlane.nodes) > 0 then
                    self.fillPlanes[fillType] = fillPlane;
                end;
            end;
            i = i +1;
        end;
		
		delete(addonxmlFile);
	
	end;
	
	table.insert(g_currentMission.heapTipTriggers, self);

end;

function HeapTipTrigger:delete()

	
    removeTrigger(self.triggerId);	
	removeTrigger(self.moveNode);
	
	g_currentMission:removeNodeObject(self.moveNode);
	
	g_currentMission:removeTipTrigger(self);
	for k,v in pairs(g_currentMission.trailerTipTriggers) do
		for key, tipTrigger in pairs(v) do
			if tipTrigger == self then
				v[key] = nil;
			end;
		end;
	end;
	
	for i=1, table.getn(g_currentMission.heapTipTriggers) do
		if g_currentMission.heapTipTriggers[i] == self then
			table.remove(g_currentMission.heapTipTriggers, i);
		end;
	end;	
	
end;

function HeapTipTrigger:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	if self.fillLevel <= 0 then
		self.allowToRemove = true;
	else
		self:setStatic();
		self:setFillLevel(self.fillLevel, self.currentFillType);
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function HeapTipTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HeapTipTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function HeapTipTrigger:readStream(streamId, connection)
    if connection:getIsServer() then
        if self.synchronizeFillLevel then
            local fillLevel = streamReadFloat32(streamId);
            local fillType = streamReadUIntN(streamId, Fillable.sendNumBits);
			self.isStatic = true;
            self:setFillLevel(fillLevel, fillType);
        end
    end
end;

function HeapTipTrigger:writeStream(streamId, connection)
    if not connection:getIsServer() then
        if self.synchronizeFillLevel then
            streamWriteFloat32(streamId, self.fillLevel);
            streamWriteUIntN(streamId, self.currentFillType, Fillable.sendNumBits);
        end
    end;
end;

function HeapTipTrigger:update(dt)

    if self:getShowInfo() then
		if self.currentFillType ~= nil then
			if Fillable.fillTypeIndexToDesc[self.currentFillType] ~= nil then
				g_currentMission:addExtraPrintText(g_i18n:getText("fill_level").." "..math.floor(self.fillLevel).." ("..math.floor(100*self.fillLevel/self.capacity).."%) ["..Fillable.fillTypeIndexToDesc[self.currentFillType].nameI18N.."]");
			end;
		end;
	end;	
	
	if not self.isStatic then
		if self.lastSpeed < 0.0003  then	-- km/s ?
			self.waitToStaticTime = self.waitToStaticTime + dt; -- realtime ms
			if self.waitToStaticTime > 200 then
				self:setStatic();
				self.waitToStaticTime = 0;
			end;
		end;
	end;
	
	--if table.getn(self.trailersInTrigger) >= 1 then
		--if g_currentMission.trailerInTipRange == nil then
		
		--end;
	--end;

end;

function HeapTipTrigger:updateTick(dt)

	if self.isServer then
	

		if self.currentShovel ~= nil and self.currentShovelNode ~= nil and self.fillLevel > 0 then		
			-- get the shovel object again (maybe it was deleted in the meantime)
			local shovel = g_currentMission.nodeToVehicle[self.currentShovelNode];		
			
			if shovel ~= nil then
				self.currentShovel = shovel;
				
				if shovel.fillLevel < shovel.capacity and shovel:getAllowFillShovel(self.currentFillType) then
					local deltaFillLevel = shovel:fillShovelFromTrigger(self, self.fillLevel, self.currentFillType, dt);
					
					self:setFillLevel(self.fillLevel-deltaFillLevel, self.currentFillType);
					self.allowToRemove = true;	
				end;
			
			
				local attacherRootVehicle = shovel:getRootAttacherVehicle();
				local gesMass = 0;
				for c=1, table.getn(attacherRootVehicle.components) do
					gesMass = gesMass + getMass(attacherRootVehicle.components[c].node);	
				end;
				for i=1, table.getn(attacherRootVehicle.attachedImplements) do
					local implement = attacherRootVehicle.attachedImplements[i].object;
					for ci=1, table.getn(implement.components) do
						gesMass = gesMass + getMass(implement.components[ci].node);	
					end;
				end;
				local fres = attacherRootVehicle.lastMovedDistance*8*gesMass*dt;
				if attacherRootVehicle.movingDirection == 1 then
					local worldX,worldY,worldZ = localDirectionToWorld(attacherRootVehicle.components[1].node, 0, 0, -fres);
					addForce(attacherRootVehicle.components[1].node, worldX, worldY, worldZ, attacherRootVehicle.components[1].centerOfMass[1], attacherRootVehicle.components[1].centerOfMass[2], attacherRootVehicle.components[1].centerOfMass[3], true);
				end;
			end;
		end;
		
		if self.allowToRemove then			
			if self.fillLevel <= 0 then
				self.removeTime = self.removeTime - dt;
				if self.removeTime <= 0 then
					g_currentMission.vehiclesToDelete[self] = self;
				end;
			end;
		end;
		
	end;

end;

function HeapTipTrigger:draw()
end;

function HeapTipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)


	--local fillType = self.currentFillType;
	--if self.fillLevel <= 0 then
		--fillType = self.trailersInTrigger[1].currentFillType;
	--end;
	
	local oldFillLevel = self.fillLevel - fillDelta;
	self.fillLevel = math.min(oldFillLevel, self.capacity);	
	
	self:setFillLevel(self.fillLevel, fillType);
	
	local refill = oldFillLevel - self.fillLevel;
	if refill > 0 then
		--for i=1, table.getn(self.trailersInTrigger) do
			--local trailer = self.trailersInTrigger[i];
			--trailer:setFillLevel(trailer.fillLevel + refill, trailer.currentFillType);
			trailer:onEndTip();
			trailer.fillLevel = trailer.fillLevel + refill;
		--end;
	end;

	--self.allowToRemove = false;	

end;


function HeapTipTrigger:tipTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer ~= nil and trailer.allowTipDischarge then
			if g_currentMission.trailerTipTriggers[trailer] == nil then
				g_currentMission.trailerTipTriggers[trailer] = {};
			end;
			table.insert(g_currentMission.trailerTipTriggers[trailer], self);
			table.insert(self.trailersInTrigger, trailer);
		end;
	elseif onLeave then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer ~= nil and trailer.allowTipDischarge then
			if trailer.tipState == Trailer.TIPSTATE_OPENING or trailer.tipState == Trailer.TIPSTATE_OPEN then
				trailer.createHeapTipTrigger = true;
				trailer.lastHeapTipTrigger = self;
			end;
			local triggers = g_currentMission.trailerTipTriggers[trailer];
			if triggers ~= nil then
				for i=1, table.getn(triggers) do
					if triggers[i] == self then
						table.remove(triggers, i);
						if table.getn(triggers) == 0 then
							g_currentMission.trailerTipTriggers[trailer] = nil;
						end;
						break;
					end;
				end;
			end;
			for i=1, table.getn(self.trailersInTrigger) do
				if self.trailersInTrigger[i] == trailer then
					table.remove(self.trailersInTrigger, i);
				end;
			end;
		end;
	end;
	
	if (onEnter or onLeave) then

        if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
            if onEnter then
                self.playerInRange = true;
            else
                self.playerInRange = false;
            end;
        end;
    end;

end;

function HeapTipTrigger:getShowInfo()
    if (g_currentMission.controlPlayer and self.playerInRange) then
        return true;
    end;
    if not g_currentMission.controlPlayer then 
		if self.currentShovel ~= nil then
			if self.currentShovel:getIsActiveForInput(false) then
				return true;
			end;
		end;
    end;
    return false;
end;

function HeapTipTrigger:shovelGetCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if (onEnter or onLeave) then
		local shovel = g_currentMission.nodeToVehicle[otherShapeId];
		if shovel ~= nil then
			if onLeave then
				if self.currentShovel == shovel and self.currentShovelNode == otherShapeId then
					self.currentShovel = nil;
					self.currentShovelNode = nil;
				end
			else
				if shovel.allowFillFromShovelTrigger and shovel.fillShovelFromTrigger ~= nil and (shovel.shovelNodes == nil or shovel.shovelNodes[otherShapeId]) then
					self.currentShovel = shovel;
					self.currentShovelNode = otherShapeId;
				end;
			end;
		end;
	end;

end;

function HeapTipTrigger:setStatic()

	--setRigidBodyType(self.rootNode, "Static");
	self.isStatic = true;

end;

function HeapTipTrigger:setFillLevel(superFunc, fillLevel, fillType, force)
    --if (force == nil or force == false) then -- and not self:allowFillType(fillType, false) then
       -- return
    --end;

    self.currentFillType = fillType;
    self.fillLevel = fillLevel;
    if self.fillLevel > self.capacity then
        self.fillLevel = self.capacity;
    end;
    if self.fillLevel < 0 then
        self.fillLevel = 0;
        self.currentFillType = Fillable.FILLTYPE_UNKNOWN;
    end;


    if self.isClient then
        if self.currentFillPlane ~= nil then
            for _, node in ipairs(self.currentFillPlane.nodes) do
                setVisibility(node.node, false);
            end;
            self.currentFillPlane = nil;
        end;
        if self.fillPlanes ~= nil and self.defaultFillPlane ~= nil and fillType ~= Fillable.FILLTYPE_UNKNOWN then
            local fillTypeName = Fillable.fillTypeIntToName[fillType];
            local fillPlane = self.fillPlanes[fillTypeName];
            if fillPlane == nil then
                fillPlane = self.defaultFillPlane;
            end;
            local t = self.fillLevel/self.capacity;
            for _, node in ipairs(fillPlane.nodes) do
                local x,y,z, rx,ry,rz, sx,sy,sz = node.animCurve:get(t);
				
                setTranslation(self.moveNode, x, y, z);
                setRotation(self.moveNode, rx, ry, rz);
                setScale(node.node, sx, sy, sz);
                setVisibility(node.node, self.fillLevel > 0 and self.isStatic);
            end;
            self.currentFillPlane = fillPlane;
        end;
    end;	
	
end;

function HeapTipTrigger:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	local minDistance, bestPoint = TipTrigger.getTipDistanceFromTrailer(self, trailer, tipReferencePointIndex);
	
	--local minDistance = 0;
	--local bestPoint = trailer.tipReferencePoints[1];

	local isAllowed = false;
	if self.currentFillType == trailer.currentFillType or self.fillLevel == 0 then
		isAllowed = true;
	end;
 
	return isAllowed, minDistance, bestPoint;
end;

function HeapTipTrigger:getNoAllowedText(trailer)
	if trailer.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and self.fillLevel > 0 and self.currentFillType ~= trailer.currentFillType then
		return Fillable.fillTypeIndexToDesc[trailer.currentFillType].nameI18N .. g_i18n:getText("notAcceptedHere");
	end;
	
	return nil;
end;



if BaseMission.modHeapTipTrigger == nil then
	BaseMission.modHeapTipTrigger = true;
	print("  Register Variable: BaseMission.modHeapTipTrigger = true");
	
	
	-- TRAILER --
	--[[local TrailerUpdate = Trailer.update;
	Trailer.update = function(self, dt)

		if self.printStrg == nil then
			self.printStrg = false;
		end;
		if self.createHeapTipTrigger == nil then
			self.createHeapTipTrigger = false;
		end;
		if self.allowToHTPTip == nil then
			self.allowToHTPTip = false;
		end;
		if self.toggleHTPTip == nil then
			self.toggleHTPTip = false;
		end;				

		if self:getIsActiveForInput() then
			if self.tipReferencePoints ~= nil then
				if self.tipReferencePoints[1] ~= nil then
		
					--self.printStrg = false;
				
					--if g_currentMission.trailerInTipRange == nil and ( self.tipState == Trailer.TIPSTATE_CLOSED or self.tipState == Trailer.TIPSTATE_CLOSING )  then --and ( self.tipState == Trailer.TIPSTATE_CLOSED or self.tipState == Trailer.TIPSTATE_CLOSING ) then --and not self.create_HeapTipTrigger then
					if ( self.tipState == Trailer.TIPSTATE_CLOSED or self.tipState == Trailer.TIPSTATE_CLOSING ) then --and not self.create_HeapTipTrigger then
						if Input.isKeyPressed(Input.KEY_lctrl) and InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
							if g_currentMission:canCreateHeapTipTrigger(self.tipReferencePoints[1].node) then
								local x,y,z = getWorldTranslation(self.tipReferencePoints[1].node);
								self.HTPObject = g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.tipReferencePoints[1].node));
								self.toggleHTPTip = true;
							else
								g_currentMission:addWarning(g_i18n:getText("StoreInvalidPlacementPosition"));
							end;
						end;
						if Input.isKeyPressed(Input.KEY_lctrl) then
							self.printStrg = true;
						else
							self.printStrg = false;
						end;
					end;
					
				end;
			end;			
		end;

		if self.isServer then
			if self.createHeapTipTrigger then
				--print("createhtt")
				local trailerInTipRange, currentTipTrigger, currentTipTriggerIsAllowed, currentTipReferencePointIndex = g_currentMission:getTrailerInTipRange(self);
				--if g_currentMission.currentTipTrigger ~= nil and g_currentMission.currentTipTrigger ~= self.lastHeapTipTrigger then	-- client driver, g_currentMission.currentTipTrigger = nil
				if self == trailerInTipRange and currentTipTriggerIsAllowed and currentTipTrigger ~= nil then	-- client driver, g_currentMission.currentTipTrigger = nil
					if currentTipTrigger.isHTP ~= nil then
						self.currentTipTrigger = currentTipTrigger;
						--print("toggle tip heap")
						self.createHeapTipTrigger = false;
					end;
				end;
				--if self.currentTipTrigger == nil and g_currentMission:canCreateHeapTipTrigger(self.tipReferencePoints[1].node) then
				if self.currentTipTrigger == nil and g_currentMission:canCreateHeapTipTrigger(self.tipReferencePoints[1].node) then
					local x,y,z = getWorldTranslation(self.tipReferencePoints[1].node);
					self.currentTipTrigger = g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.tipReferencePoints[1].node));
					self:onStartTip(self.currentTipTrigger, self.currentTipReferencePointIndex);
					--print("create heap + start tip")
					self.createHeapTipTrigger = false;
				end;
			end;
			
			if self.toggleHTPTip and self.HTPObject ~= nil then
				if g_currentMission.currentTipTrigger ~= nil and g_currentMission.currentTipTriggerIsAllowed then
					self:onStartTip(self.HTPObject, 1);
					self.toggleHTPTip = false;
					self.HTPObject = nil;
					--print("toggle start tip manuell create")
				end;
			end;
		end;
		
		TrailerUpdate(self, dt);
	end;

	local TrailerDraw = Trailer.draw;
	Trailer.draw = function(self)

		if self.printStrg then
			g_currentMission:addExtraPrintText("HeapTipTrigger erstellen: STRG + "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT));
		end;	

		TrailerDraw(self);
	end;]]

	-- SHOVEL --
	--[[local ShovelUpdate = Shovel.update;
	Shovel.update = function(self, dt)

		if self.printStrg == nil then
			self.printStrg = false;
		end;

		if self:getIsActiveForInput() then
			if self.shovelTipReferenceNode ~= nil then	
				self.printStrg = false;
			
				if self.fillLevel > 0 then
					if Input.isKeyPressed(Input.KEY_lctrl) and InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
						local x,y,z = getWorldTranslation(self.shovelTipReferenceNode);
						g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.shovelTipReferenceNode));
					end;
					if Input.isKeyPressed(Input.KEY_lctrl) then
						self.printStrg = true;
					else
						self.printStrg = false;
					end;
				end;

			end;			
		end;

		ShovelUpdate(self, dt);
	end;

	local ShovelDraw = Shovel.draw;
	Shovel.draw = function(self)

		if self.printStrg then
			g_currentMission:addExtraPrintText("HeapTipTrigger erstellen: STRG + "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT));
		end;	

		ShovelDraw(self);
	end;]]
	
	
	-- COMBINE --	
	--[[local CombineUpdate = Combine.update;
	Combine.update = function(self, dt)

		if self.printStrg == nil then
			self.printStrg = false;
		end;

		if self:getIsActiveForInput() then
			if self.pipeRaycastNode ~= nil then		
				self.printStrg = false;
			
				if self.pipeStateIsUnloading[self.currentPipeState] and self:getIsPipeUnloadingAllowed() and self.fillLevel > 0 then
					if Input.isKeyPressed(Input.KEY_lctrl) and InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
						local x,y,z = getWorldTranslation(self.pipeRaycastNode);
						g_currentMission:createNewHeapTipTrigger(x, 0.5, z, g_currentMission:getYRotHeapTipTrigger(self.pipeRaycastNode));
					end;
					if Input.isKeyPressed(Input.KEY_lctrl) then
						self.printStrg = true;
					else
						self.printStrg = false;
					end;
				end;
			end;			
		end;

		CombineUpdate(self, dt);
	end;

	local CombineDraw = Combine.draw;
	Combine.draw = function(self)

		if self.printStrg then
			g_currentMission:addExtraPrintText("HeapTipTrigger erstellen: STRG + "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ACTIVATE_OBJECT));
		end;	

		CombineDraw(self);
	end;]]
	
end;



HeapTipTriggerCreateNewMPEvent = {};
HeapTipTriggerCreateNewMPEvent_mt = Class(HeapTipTriggerCreateNewMPEvent, Event);

InitEventClass(HeapTipTriggerCreateNewMPEvent, "HeapTipTriggerCreateNewMPEvent");

function HeapTipTriggerCreateNewMPEvent:emptyNew()
    local self = Event:new(HeapTipTriggerCreateNewMPEvent_mt);
    self.className="HeapTipTriggerCreateNewMPEvent";
    return self;
end;

function HeapTipTriggerCreateNewMPEvent:new(positionX, yOffset, positionZ, yr)
    local self = HeapTipTriggerCreateNewMPEvent:emptyNew()
    self.positionX = positionX;
    self.yOffset = yOffset;
    self.positionZ = positionZ;
    self.yr = yr;
    return self;
end;

function HeapTipTriggerCreateNewMPEvent:readStream(streamId, connection)
	--local id = streamReadInt32(streamId)
    --self = networkGetObject(id);
	
	self.positionX = streamReadFloat32(streamId);
	self.yOffset = streamReadFloat32(streamId);
	self.positionZ = streamReadFloat32(streamId);
	self.yr = streamReadFloat32(streamId);

	--self.object.create_HeapTipTrigger = streamReadBool(streamId);
	g_currentMission:createNewHeapTipTrigger(self.positionX, self.yOffset, self.positionZ, self.yr);
end;

function HeapTipTriggerCreateNewMPEvent:writeStream(streamId, connection)
	--streamWriteInt32(streamId, networkGetObjectId(self));
	
	streamWriteFloat32(streamId, self.positionX);
	streamWriteFloat32(streamId, self.yOffset);
	streamWriteFloat32(streamId, self.positionZ);
	streamWriteFloat32(streamId, self.yr);
	--streamWriteBool(streamId, self.object.create_HeapTipTrigger);
end;
