--
-- T150K
-- Specialization for T150K
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick

--23:24 25.09.2011
--by Northern_Strike(RUS) for LSSA MT 
--

T150K = {};

function T150K.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T150K:load(xmlFile)
	
	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#node"));
	self.backAttacherJoint.lowRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#lowRot"));
	self.backAttacherJoint.upRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#upRot"));
	
	self.implementAdapter = {};
	self.implementAdapter.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#adapter"));
	self.implementAdapter.attacherJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#attacherJoint"));
	self.implementAdapter.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#topReferenceNode"));
	self.implementAdapter.backup = {};
	local x,y,z = getTranslation(self.implementAdapter.node);
	self.implementAdapter.backup.trans = {x,y,z};
	self.implementAdapter.backup.attacherJoint = nil;
    self.implementAdapter.backup.topReferenceNode = nil;	
	
	local shaftCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.drivingPowerShafts#count"), 0);
    self.drivingPowerShafts = {};
    for i=1, shaftCount do
		local shaft = {};
        local shaftName = string.format("vehicle.drivingPowerShafts.powerShaft%d", i);
		shaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, shaftName .. "#index"));		
		shaft.trans = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#translation"), 0);
		local x,y,z = getTranslation(getParent(shaft.node));
		shaft.orgTrans = {x,y,z};
		shaft.rot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#rotation"), 0));	
		shaft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#speedFactor"), 2);
		table.insert(self.drivingPowerShafts, shaft);        
    end;
	
	self.topArm = {};
	self.topArm.node = getChildAt(self.attacherJoints[1].topArm.rotationNode, 0);
	self.topArm.rotation = {getRotation(self.topArm.node)};
	
	self.updateJoint = false;
	
    if not self.isServer then
		self.articulatedAxis = {};
		self.articulatedAxis.rotSpeed = math.rad(getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotSpeed"));
		self.articulatedAxis.rotMax = math.rad(getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotMax"));
		self.articulatedAxis.rotMin = math.rad(getXMLFloat(xmlFile, "vehicle.articulatedAxis#rotMin"));
    end;
	self.maxNumRealLights = 2;
	self.gearShifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter#index"));
	self.gearShifter2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter2#index"));
	
	self.motor1Active = false;
    self.motor2Active = false;		
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayKurs1 = 0;
    self.delayKurs2 = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.deltafo = 0;
	
	local motor1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motor1#index"));
    if motor1Node ~= nil then
        self.motor1 = {};
        self.motor1.node = motor1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor1#minRot"));
        self.motor1.minRot = {};
        self.motor1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor1#maxRot"));
        self.motor1.maxRot = {};
        self.motor1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.motor1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor1#rotTime"), 2)*70;
        self.motor1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor1#touchRotLimit"), 10));
    end;
	local motor2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motor2#index"));
    if motor2Node ~= nil then
        self.motor2 = {};
        self.motor2.node = motor2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor2#minRot"));
        self.motor2.minRot = {};
        self.motor2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor2#maxRot"));
        self.motor2.maxRot = {};
        self.motor2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.motor2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor2#rotTime"), 2)*70;
        self.motor2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor2#touchRotLimit"), 10));
    end;
	
	self.controlpath = Utils.getFilename("Textures/info.dds", self.baseDirectory);
    self.helpPoxX = 0.18;
    self.helpPoxY = 0.35;
    self.helpWidth = 0.65;
    self.helpHeight = 0.4;
    self.helpOverlay = Overlay:new("info", self.controlpath, self.helpPoxX, self.helpPoxY, self.helpWidth, self.helpHeight);
    self.bcActive = false;
	
end;

function T150K:delete()
end;

function T150K:readStream(streamId, connection)
end;

function T150K:writeStream(streamId, connection)
end;

function T150K:mouseEvent(posX, posY, isDown, isUp, button)
end;

function T150K:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_KP_period then
		self.bcActive = not self.bcActive;
	end;

end;

function T150K:update(dt)

local speed = self.lastSpeed*3600;
     if self.gearShifter2 ~= nil then
          if self.movingDirection < 0 then
               setRotation(self.gearShifter2, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActiveN = false;
				self.bcActiveZ = true;
				self.bcActive2d = false;
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
          else     
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActiveN = true;
				self.bcActiveZ = false;
				self.bcActive2d = false;
          elseif speed >= 0.5 then
               setRotation(self.gearShifter2, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(-10));
				self.bcActiveN = false;
				self.bcActiveZ = false;
				self.bcActive2d = true;
          end;
     end;
  end;

     if self.gearShifter ~= nil then
          if speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(0));
          else     
--0--
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--1---
          elseif speed >= 0.5 and speed <11 then
               setRotation(self.gearShifter, Utils.degToRad(-25), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--2---
          elseif speed >= 11 and speed < 16 then
               setRotation(self.gearShifter, Utils.degToRad(-35), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
--3---	

          elseif speed >= 16 and speed < 25.8 then
               setRotation(self.gearShifter, Utils.degToRad(-45), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
--4---
          elseif speed >= 25.8 then
               setRotation(self.gearShifter, Utils.degToRad(-55), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
--Back---
          elseif speed < -0.5 then
               setRotation(self.gearShifter, Utils.degToRad(30), Utils.degToRad(0), Utils.degToRad(0));
-- -1---
          elseif speed <= -0.5 and speed > -8 then
               setRotation(self.gearShifter, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(0));
-- -2---
          elseif speed <= -8 and speed > -16 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
-- -3---
          elseif speed <= -16 and speed > -24 then
               setRotation(self.gearShifter, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(0));
-- -4---
          elseif speed <= -24 then
               setRotation(self.gearShifter, Utils.degToRad(-30), Utils.degToRad(0), Utils.degToRad(0));
          end;
     end;
  end;
  
	    if self.motor1Active ~= nil and self.isMotorStarted then
			if self.delayKurs1 >= 0 then
				self.delayKurs1 = self.delayKurs1 -dt;
			end;
			   if self.delayKurs2 >= 0 then
				self.delayKurs2 = self.delayKurs2 -dt;
			end;
		if not self.motor1Max then
			if self.delayKurs1 < 0 then
				self.delayKurs2 = 70;
				self.motor1Max = true;
				self.motor2Max = true;
			end;
		end;
		if self.motor1Max then
			if self.delayKurs2 < 0 then
				self.delayKurs1 = 70;
				self.motor1Max = false;
				self.motor2Max = false;
			end;
		end;
	else
		self.motor1Max = false;
		self.motor2Max = false;
	end;

    if self.motor1 ~= nil then
       	local x, y, z = getRotation(self.motor1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.motor1.maxRot, self.motor1.minRot, 3, self.motor1.rotTime, dt, not self.motor1Max);
        setRotation(self.motor1.node, unpack(newRot));
    end;

    if self.motor2 ~= nil then
        local x, y, z = getRotation(self.motor2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.motor2.maxRot, self.motor2.minRot, 3, self.motor2.rotTime, dt, not self.motor2Max);
        setRotation(self.motor2.node, unpack(newRot));
    end;
end;

function T150K:updateTick(dt)

	if self:getIsActive() then
		local steeringAngle;
		if self.isServer then
			steeringAngle = self.articulatedAxis.curRot;
		else
			steeringAngle = self.rotatedTime * self.articulatedAxis.rotSpeed;
			if steeringAngle > self.articulatedAxis.rotMax then
				steeringAngle = self.articulatedAxis.rotMax;
			elseif steeringAngle < self.articulatedAxis.rotMin then
				steeringAngle = self.articulatedAxis.rotMin;
			end;
		end;
	
		for _, shaft in pairs(self.drivingPowerShafts) do
			local x,y,z = getRotation(self.wheels[1].driveNode);
			setRotation(shaft.node, 0 ,0, x*shaft.speedFactor);

			if shaft.trans ~= 0 then
				local newTrans = shaft.trans * steeringAngle/self.articulatedAxis.rotMax;
				local x,y,z = unpack(shaft.orgTrans);
				setTranslation(getParent(shaft.node), x + newTrans,y,z);
			end;
			if shaft.rot ~= 0 then
				newRot = shaft.rot * steeringAngle/self.articulatedAxis.rotMax;
				setRotation(getParent(shaft.node), 0, newRot, 0);
			end;			
		end;		
	end;
end;

function T150K:draw()

	if self.helpOverlay ~= nil then
		if self.bcActive then
		self.helpOverlay:render();
		end;
	end;

end;