--
-- Silageklappe2
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

silageklappeee = {};

function silageklappeee.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function silageklappeee:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local silageklappeee = {};
    silageklappeee.name = getXMLString(xmlFile, "vehicle.silageklappeee#name");
    silageklappeee.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappeee#upSpeedScale"), 1);
    silageklappeee.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappeee#downSpeedScale"), -silageklappeee.openSpeedScale);
    if silageklappeee.name ~= nil then
        self.silageklappeee = silageklappeee;
    end;
	self.silageklappeee.active = false;
	
	
	self.jointmove = false;

	
end;

function silageklappeee:delete()
end;

function silageklappeee:mouseEvent(posX, posY, isDown, isUp, button)
end;

function silageklappeee:keyEvent(unicode, sym, modifier, isDown)
end;

function silageklappeee:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local silageklappeeeAnimTime = streamReadFloat32(streamId);
	
	if silageklappeeeAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.silageklappeee.name);
		local speed = 1;
		if currentTime > silageklappeeeAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.silageklappeee.name, speed, currentTime, true);
		self:setAnimationStopTime(self.silageklappeee.name, silageklappeeeAnimTime);
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function silageklappeee:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.silageklappeee.name));
end;

function silageklappeee:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local issilageklappeeeActive = false;
		if InputBinding.isPressed(InputBinding.POETTINGER_KLAPPEE1a_OPEN) then
			self.jointmove = true;		
			issilageklappeeeActive = true;
			if InputBinding.hasEvent(InputBinding.POETTINGER_KLAPPEE1a_OPEN) then
				self:playAnimation(self.silageklappeee.name, self.silageklappeee.openSpeedScale, self:getAnimationTime(self.silageklappeee.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.POETTINGER_KLAPPEE1a_CLOSE) then
			self.jointmove = true;	
			issilageklappeeeActive = true;	
			if InputBinding.hasEvent(InputBinding.POETTINGER_KLAPPEE1a_CLOSE) then
				self:playAnimation(self.silageklappeee.name, self.silageklappeee.closeSpeedScale, self:getAnimationTime(self.silageklappeee.name)); 
			end;			
		end;
			
		if self.silageklappeee.active and not issilageklappeeeActive then
			self:stopAnimation(self.silageklappeee.name);	
			self.jointmove = false;
		end;
		self.silageklappeee.active = issilageklappeeeActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function silageklappeee:updateTick(dt)
	--[[if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;]]--
end;

function silageklappeee:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETTINGER_KLAPPEE1a_OPEN).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETTINGER_KLAPPEE1a_CLOSE)..": Duengerbereich");
	
end;

function silageklappeee:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


