--
-- Silageklappe2
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

silageklappee = {};

function silageklappee.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function silageklappee:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local silageklappee = {};
    silageklappee.name = getXMLString(xmlFile, "vehicle.silageklappee#name");
    silageklappee.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappee#upSpeedScale"), 1);
    silageklappee.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappee#downSpeedScale"), -silageklappee.openSpeedScale);
    if silageklappee.name ~= nil then
        self.silageklappee = silageklappee;
    end;
	self.silageklappee.active = false;
	
	
	self.jointmove = false;

	
end;

function silageklappee:delete()
end;

function silageklappee:mouseEvent(posX, posY, isDown, isUp, button)
end;

function silageklappee:keyEvent(unicode, sym, modifier, isDown)
end;

function silageklappee:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local silageklappeeAnimTime = streamReadFloat32(streamId);
	
	if silageklappeeAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.silageklappee.name);
		local speed = 1;
		if currentTime > silageklappeeAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.silageklappee.name, speed, currentTime, true);
		self:setAnimationStopTime(self.silageklappee.name, silageklappeeAnimTime);
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function silageklappee:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.silageklappee.name));
end;

function silageklappee:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local issilageklappeeActive = false;
		if InputBinding.isPressed(InputBinding.POETTINGER_KLAPPEE1_OPEN) then
			self.jointmove = true;		
			issilageklappeeActive = true;
			if InputBinding.hasEvent(InputBinding.POETTINGER_KLAPPEE1_OPEN) then
				self:playAnimation(self.silageklappee.name, self.silageklappee.openSpeedScale, self:getAnimationTime(self.silageklappee.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.POETTINGER_KLAPPEE1_CLOSE) then
			self.jointmove = true;	
			issilageklappeeActive = true;	
			if InputBinding.hasEvent(InputBinding.POETTINGER_KLAPPEE1_CLOSE) then
				self:playAnimation(self.silageklappee.name, self.silageklappee.closeSpeedScale, self:getAnimationTime(self.silageklappee.name)); 
			end;			
		end;
			
		if self.silageklappee.active and not issilageklappeeActive then
			self:stopAnimation(self.silageklappee.name);	
			self.jointmove = false;
		end;
		self.silageklappee.active = issilageklappeeActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function silageklappee:updateTick(dt)
	--[[if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;]]--
end;

function silageklappee:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETTINGER_KLAPPEE1_OPEN).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETTINGER_KLAPPEE1_CLOSE)..": Teil 2 auf / zu");
	
end;

function silageklappee:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


