--
-- TipperCover
-- 
--
-- @author  Sven777b
-- @date  21/01/11
--

TipperCover = {};

function TipperCover.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function TipperCover:load(xmlFile)
	self.setCoverState = SpecializationUtil.callSpecializationsFunction("setCoverState");
	local openid = getXMLString(xmlFile, "vehicle.cover#open");
	local closeid = getXMLString(xmlFile, "vehicle.cover#closed");
	if openid ~= nil and closeid ~= nil then
		self.cover = {};
		self.cover.opened = Utils.indexToObject(self.components, openid);
		self.cover.closed = Utils.indexToObject(self.components, closeid);
		self:setCoverState(false,true);
	end;
end;

function TipperCover:delete()
end;

function TipperCover:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TipperCover:keyEvent(unicode, sym, modifier, isDown)
end;

function TipperCover:readStream(streamId, connection)
	local coverState = streamReadBool(streamId);
	self:setCoverState(coverState,true);
end;

function TipperCover:writeStream(streamId, connection)
	streamWriteBool(streamId, self.cover.state);
end;

function TipperCover:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local coverState = Utils.getNoNil(getXMLBool(xmlFile,key.."#cover"),false);
		self:setCoverState(coverState);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function TipperCover:getSaveAttributesAndNodes(nodeIdent)
    local attributes = ' cover="'..tostring(self.cover.state)..'"';
    local node = nil;
    return attributes, node;
end;

function TipperCover:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.openCover) and self.cover ~= nil then
			self:setCoverState(not self.cover.state);
		end;
	end;
end;

function TipperCover:updateTick(dt)
end;

function TipperCover:setCoverState(coverState,noEventSend)
	if self.cover ~= nil then
		if self.cover.state ~= coverState then
			CoverStateEvent.sendEvent(self, coverState, noEventSend)
			self.cover.state = coverState;
		end;
		setVisibility(self.cover.opened, not self.cover.state);
		setVisibility(self.cover.closed, self.cover.state);
		self.allowFillFromAir = not self.cover.state;
	end;
end;

function TipperCover:draw()
	if self:getIsActiveForInput() then
		g_currentMission:addHelpButtonText(g_i18n:getText("openCover"), InputBinding.openCover);
	end;
end;

-----------------------------------------------------------------------------------------------------

CoverStateEvent = {};
CoverStateEvent_mt = Class(CoverStateEvent, Event);
InitEventClass(CoverStateEvent, "CoverStateEvent");

function CoverStateEvent:emptyNew()
    local self = Event:new(CoverStateEvent_mt);
    self.className="CoverStateEvent";
    return self;
end;

function CoverStateEvent:new(object, coverState)
    local self = CoverStateEvent:emptyNew()
    self.object = object;
	self.coverState = coverState;
    return self;
end;

function CoverStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.coverState = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function CoverStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.coverState);
end;

function CoverStateEvent:run(connection)
	self.object:setCoverState(self.coverState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(CoverStateEvent:new(self.object, self.coverState), nil, connection, self.object);
    end;	
end;

function CoverStateEvent.sendEvent(vehicle, coverState, noEventSend)
	if coverState ~= vehicle.cover.state then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(CoverStateEvent:new(vehicle, coverState), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(CoverStateEvent:new(vehicle, coverState));
			end;
		end;
	end;
end;
