local metadata = {
"## Interface: 2.0.0.9",
"## Title: LiveTicker",
"## Notes: Show Mod Msg on top of Screen",
"## Author: Marhu",
"## Version: 1.1.5",
"## Date: 06.11.2014",
}

local function Debug(printDebug,...)
	if printDebug then
		local text, TITLE, VERSION = "","Marhus Mod",""
		for i = 1, select("#", ...) do
			if type(select(i, ...)) == "boolean" then
				text = text..(select(i, ...) and "true" or "false").." ";
			else text = text..(select(i, ...) or "nil").." "; end;
		end
		for i = 1, table.getn(metadata) do
			local nBeginn, nEnde = string.find(metadata[i],"## Title: ");
			if nEnde then TITLE = string.sub (metadata[i], nEnde); end;
			local nBeginn, nEnde = string.find(metadata[i],"## Version: ");
			if nEnde then VERSION = " v"..string.sub (metadata[i], nEnde); end;
		end;
		print(TITLE..VERSION..": "..text);
	end;
end;

LiveTicker = {};
LiveTicker.version = 0;  -- read from Metadata
LiveTicker.dir = g_currentModDirectory;

function LiveTicker:loadMap(name)

	for i = 1, table.getn(metadata) do
		local nBeginn, nEnde = string.find(metadata[i],"## Version: ");
		if nEnde then
			local VSplit = Utils.splitString(".",string.sub (metadata[i], nEnde));
			self.version = (tonumber(VSplit[1])*10000)+(tonumber(VSplit[2])*100)+tonumber(VSplit[3])
			break;
		end;
	end;
	
	if g_currentMission.LiveTicker == nil or g_currentMission.LiveTicker.version < self.version then
		g_currentMission.LiveTicker = {}
		g_currentMission.LiveTicker.version = self.version
		g_currentMission.LiveTicker.Add = function(sender,text) self:Add(sender,text); end;
	
		self.db = {
			name = "LiveTicker",
			debug = false
		};
		
		if g_currentMission.DatenBank then
			g_currentMission.DatenBank.Add(self,self.db);
		end;
		
		self.optionen = {
			name = "LiveTicker",
			desc = "LiveTicker",
			type = 'group',
			args = {
				lastPost = {
					name = "Post",
					desc = "Post last 10 MSG",
					type = 'button',
					set = function() self.ReloadLast = not self.ReloadLast end
				},
				debuging = {
					name = "Debug",
					desc = "Print Debug info in Log",
					type = 'toggle',
					get = function() return self.db.debug end,
					set = function(info, newValue)
						self.db.debug = newValue
					end
				}
			}
		}
		
		Debug(self.db.debug,"Load");
	end;
	
	self.textH = 0.02;
	self.MSG = {}
	self.lastMSG = {};
	self.overlay = createImageOverlay("dataS2/menu/white.png");
	self.sample = createSample("NewMSGSound");
    loadSample(self.sample,  Utils.getFilename(self.dir.."map/sounds/pdaBeep.wav", self.baseDirectory), false);
	
	self.ReloadLast = false;
	self.ReloadWait = 0;
	self.setReloadLast = LiveTicker.setReloadLast

	
end;
function LiveTicker:deleteMap()
	self.menueaddet = nil;
end;
function LiveTicker:mouseEvent(posX, posY, isDown, isUp, button)
end;
function LiveTicker:keyEvent(unicode, sym, modifier, isDown)
end;

function LiveTicker:update(dt)

	if not self.menueaddet then
		self.menueaddet = true;
		if g_currentMission.LiveTicker and g_currentMission.LiveTicker.version == self.version then
			if g_currentMission.ModMenue then
				g_currentMission.ModMenue:Add(self.optionen);
			end;
		end;
	end;
	
	for k,v in pairs(self.MSG) do
		if v.pos + v.width <= 0 then
			table.remove(self.MSG,k);
		end;
	end;
	
	for i = 1, table.getn(self.MSG) do
		self.MSG[i].pos = self.MSG[i].pos - (dt / 20000)
	end
	
	if table.getn(self.lastMSG) > 10 then
		table.remove(self.lastMSG,1);
	end
	
	if self.ReloadLast then
		self.ReloadWait = self.ReloadWait + dt;
		if self.ReloadWait >= 3000 then
			self.ReloadLast = false;
			self.ReloadWait = 0;
			self:setReloadLast()
		end;
	end;
	
end;

function LiveTicker:draw()
	if table.getn(self.MSG) > 0 then
		setOverlayColor(self.overlay, 0,0,0,0.4);
		renderOverlay(self.overlay, 0, 1-self.textH, 1, self.textH);
		setTextColor(1, 1, 1, 1);
		for i = 1, table.getn(self.MSG) do
			renderText(self.MSG[i].pos, 1-self.textH, self.textH, self.MSG[i].text);
		end
		if not self.SoundPlay then
			self.SoundPlay = true;
			playSample(self.sample, 1, 1, 0);
		end
	else
		self.SoundPlay = nil;
	end;
end;

function LiveTicker:Add(sender,text,last)
	
	local pos = 1
	local num = table.getn(self.MSG)
	if num > 0 then
		pos = self.MSG[num].pos + self.MSG[num].width;
		if pos < 1 then
			local t = {}
			t.text = " +++ "
			t.width = getTextWidth(self.textH ,tostring(t.text));
			if pos + (t.width * 2) < 1 then
				t.pos = 1
				pos = t.pos + t.width
				table.insert(self.MSG,t)
			else
				pos = 1;
			end;
		end;
	else
		local t = {}
		t.text = " +++ "
		t.pos = pos
		t.width = getTextWidth(self.textH ,tostring(t.text));
		table.insert(self.MSG,t)
		pos = self.MSG[1].pos + self.MSG[1].width
	end
	
	if last ~= true then
		table.insert(self.lastMSG,text)
	end;
	
	local t = {}
	t.text = text
	t.pos = pos
	t.width = getTextWidth(self.textH ,tostring(t.text));
	table.insert(self.MSG,t)
	
	num = table.getn(self.MSG)
	pos = self.MSG[num].pos + self.MSG[num].width
	local t = {}
	t.text = " +++ "
	t.pos = pos
	t.width = getTextWidth(self.textH ,tostring(t.text));
	table.insert(self.MSG,t)
	
end;

function LiveTicker:setReloadLast()
	for i = 1, table.getn(self.lastMSG) do
		self:Add(self,self.lastMSG[i],true);
	end;
end

addModEventListener(LiveTicker);

