--
-- AnimationMap
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history		v1.0   - 2014-11-08 - Initial implementation
-- 				v1.0.1 - 2014-12-18 - Warning if adding one of the default text to globalText
-- 				v1.0.2 - 2015-06-02 - Minor updates
-- 

AnimationMap = {};
AnimationMap.baseDirectory = g_currentModDirectory;

addModEventListener(AnimationMap);

function AnimationMap:loadMap(name)
	local mapFile, gotConfigFile, baseDir = nil, g_currentMission.AnimationMapConfig ~= nil, {AnimationMap.baseDirectory};
	
	if gotConfigFile then
		if table.getn(g_currentMission.AnimationMapConfig) == 2 then
			mapFile = Utils.getFilename(g_currentMission.AnimationMapConfig[1], g_currentMission.AnimationMapConfig[2]); -- XML, path
			baseDir[2] = g_currentMission.AnimationMapConfig[2];
			
			local words = Utils.splitString("/", baseDir[2]);
			g_currentMission.AnimationMapConfig["mapName"] = words[table.getn(words) - 1];
			g_currentMission.AnimationMapConfig["mapDir"] = baseDir[2];
		else
			print("");
			print("AnimationMapTrigger - Warning: self.AnimationMapConfig in your map lua have been improperly set.");
			print('It needs to be similar to this, self.AnimationMapConfig = {"AnimationMap.xml", self.baseDirectory};');
			print("");
		end;
	end;
	
	g_currentMission.AnimationMapHuds = {};
	local xmlFiles = {Utils.getFilename("AnimationMap.xml", AnimationMap.baseDirectory), mapFile};
	
	self.g_i18Names = {};
	
	for k, file in pairs(xmlFiles) do
		if fileExists(file) then
			local xmlFile = loadXMLFile("fileXMLTemp", file);
			
			if gotConfigFile and g_currentMission.AnimationMapConfig["debug"] == nil then
				g_currentMission.AnimationMapConfig["debug"] = Utils.getNoNil(getXMLBool(xmlFile, "AnimationMap.Config#debug"), false);
			end;
			
			if k == 2 then -- only check file from map
				local i = 0;
				while true do
					local key = string.format("AnimationMap.GlobalTexts.text(%d)", i);
					if not hasXMLProperty(xmlFile, key) then break; end;
					
					local name = getXMLString(xmlFile, key .. "#name");
					
					if name ~= nil and gotConfigFile then
						if not g_i18n:hasText(name) then
							table.insert(self.g_i18Names, name);
							g_i18n.globalI18N.texts[name] = _G[g_currentMission.AnimationMapConfig["mapName"]].g_i18n:getText(name);
						else
							print("AnimationMapTrigger - Warning: GlobalTexts.text (" .. name .. ") is set by the AnimtionMapTrigger mod, remove it from GlobalTexts,text within your map (" .. tostring(g_currentMission.AnimationMapConfig["mapName"]) .. ")");
						end;
					end;
					
					i = i + 1;
				end;
			end;
			
			local i = 0;
			while true do
				local key = string.format("AnimationMap.Huds.Hud(%d)", i);
				if not hasXMLProperty(xmlFile, key) then break; end;
				
				local hudName = getXMLString(xmlFile, key .. "#name");
				
				if hudName ~= nil then 
					local filename = Utils.getFilename(getXMLString(xmlFile, key .. "#filename"), baseDir[k]);
					
					if fileExists(filename) then
						local x = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#x"), 0.92);
						local y = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#y"), 0.185);
						local width = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#width"), 0.056);
						local height = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#height"), 0.08);
						
						if gotConfigFile and g_currentMission.AnimationMapConfig["debug"] then
							if g_currentMission.AnimationMapHuds[hudName] ~= nil then
								print("AnimationMapTrigger - Debug: overlay hud " .. tostring(hudName) .. " have been replaced.");
							end;
						end;
						
						g_currentMission.AnimationMapHuds[hudName] = Overlay:new(hudName, filename, x, y, width, height);
						
						i = i + 1;
					else
						print("AnimationMapTrigger - Error: Hud file (" .. tostring(filename) .. ") can't be found!");
						break;
					end;
				else
					print("AnimationMapTrigger - Error: Invalid hud name (" .. tostring(hudName) .. ")");
					break;
				end;
			end;

			delete(xmlFile);
		else
			print("AnimationMapTrigger - Warning: xml file couldn't be found! " .. tostring(file));
		end;
	end;
	
	if g_currentMission.AnimationMapTriggers ~= nil then
		for name, trigger in pairs(g_currentMission.AnimationMapTriggers) do
			if trigger.finishLoad ~= nil then
				trigger:finishLoad(trigger);
			end;
		end;
	end;
end;

function AnimationMap:deleteMap()
	if self.g_i18Names ~= nil then
		for _, name in ipairs(self.g_i18Names) do
			g_i18n.globalI18N.texts[name] = nil;
		end;
	end;
	
	if g_currentMission.AnimationMapHuds ~= nil then
		for i, hud in pairs(g_currentMission.AnimationMapHuds) do
			hud:delete();
		end;
	end;
	
	g_currentMission.AnimationMapHuds = nil;
	g_currentMission.AnimationMapTriggers = nil;
	g_currentMission.AnimationMapConfig = nil;
end;

function AnimationMap:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimationMap:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimationMap:update(dt)
end;

function AnimationMap:draw()
	if g_gui.currentGui == nil and g_currentMission.AnimationMapTriggers ~= nil then
		for name, trigger in pairs(g_currentMission.AnimationMapTriggers) do
			if trigger.draw ~= nil then
				trigger:draw(trigger);
			end;
		end;
	end;
end;