--author: igor29381 from S.W.I.K. modding team vk.com/stasenko100
--co-author: Decker_MMIV - fs-uk.com, forum.farming-simulator.com, modhoster.com

terrainControl = {};
terrainControl.cutFruitsByWheels = true; 	--if true all transport with wheels can destroy crop on fields
											-- true,          
terrainControl.bumpySimulating = true; 		--if true wheels are simulate bumps on terrain
											-- true,      

function terrainControl.prerequisitesPresent(specializations)
	return true;
end;

function terrainControl:load(xmlFile)

    if FruitUtil.modFoliageId_Dirty == nil then
        FruitUtil.modFoliageId_Dirty = Utils.getNoNil(getChild(g_currentMission.terrainRootNode, "dirty"), 0);
    end;
	self.getAllStatesFruitArea = terrainControl.getAllStatesFruitArea;

	if #self.wheels>0 then
		for c,wheel in pairs(self.wheels) do
			if wheel.tireType ~= 4 then
				if terrainControl.dirtWave then
					wheel.dirtWave = clone(terrainControl.dirtWave, true);
					setVisibility(wheel.dirtWave, false);
				end;
				local psData = {};
				psData.psFile = "dirtPS/dirt2.i3d";
				psData.posX = wheel.positionX;
				psData.posY = wheel.positionY-wheel.radius;
				psData.posZ = wheel.positionZ;
				psData.forceNoWorldSpace = true;
				wheel.dirt2ParticleSystems = {};
				Utils.loadParticleSystemFromData(psData, wheel.dirt2ParticleSystems, nil, false, nil, Terrain_And_Dirt_Control.terrainAndDirtControl.curModDir, wheel.node);
				setScale(wheel.dirt2ParticleSystems[1].shape, wheel.radius, wheel.radius, wheel.radius);
				wheel.dirt3ParticleSystems = {};
				Utils.loadParticleSystemFromData(psData, wheel.dirt3ParticleSystems, nil, false, nil, Terrain_And_Dirt_Control.terrainAndDirtControl.curModDir, wheel.node);
				setScale(wheel.dirt3ParticleSystems[1].shape, wheel.radius, wheel.radius, wheel.radius);
				wheel.enableDrift = false;
				wheel.driftCoeff = 1;
			end;
			wheel.wasInDirtS = false;
			wheel.wasInDirtC = false;
			wheel.inDirt = false;
			wheel.lastRot,_,_ = getRotation(wheel.driveNode);
			wheel.lastForce = 0;
			wheel.realRadius = wheel.radius;
			wheel.newRadius = wheel.radius;
			wheel.minRadius = wheel.radius/4;
			wheel.newPosition = 0;
		end;
		self.movedDistance = 0;
		self.distanceToChange = math.random(2, 10)/10;
		self.lineDamp = 0;
	end;
end;

function terrainControl:delete()
end;

function terrainControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function terrainControl:keyEvent(unicode, sym, modifier, isDown)
end;

function terrainControl:update(dt)
	if #self.wheels > 0 then
		local speed = self:getLastSpeed();
		local enableChanges = false;
		self.movedDistance = self.movedDistance + self.lastMovedDistance;
		if self.movedDistance > self.distanceToChange and speed > 0.5 then
			enableChanges = true;
			self.movedDistance = 0;
			self.distanceToChange = math.random(2, 10)/10;
		end;
		if self.isServer then
			local LineDamp = 0;
			local dirtAmount = 0;
			local mass = self:getTotalMass();
			mass = mass/#self.wheels;
			for c=1, #self.wheels do
				local wheel = self.wheels[c];
				if wheel.inDirt then
					wheel.wasInDirtS = true;
					g_currentMission.tyreTrackSystem:cutTrack(wheel.tyreTrackIndex);
					local AxleSpeed = math.abs(getWheelShapeAxleSpeed(wheel.node, wheel.wheelShape));
					dirtAmount = dirtAmount + (AxleSpeed/3000)/#self.wheels;
					if self.motor then
						local damp = (speed/15)/#self.wheels;
						LineDamp = Utils.clamp(LineDamp + damp, 0.3, 0.8);
					end;
					if enableChanges then
						if wheel.tireType ~= 4 then
							local frictionCoeff;
							if wheel.onDirtyBorder then
								wheel.newRadius = math.max(wheel.realRadius-math.random(10, 20+mass)/100, wheel.minRadius);
								wheel.driftCoeff = math.random(1, 5);
								frictionCoeff = math.random(20, 40)/100;
							else
								wheel.newRadius = math.max(wheel.realRadius-math.random(20, 45+mass)/100, wheel.minRadius);
								wheel.driftCoeff = math.random(1, 10);
								frictionCoeff = math.random(15, 32)/100;
							end;
							local wx,wy,wz = getTranslation(wheel.driveNode);
							addForce(self.rootNode,wx*frictionCoeff*50,0,0,wx,wy,wz,true);
							setWheelShapeTireFriction(wheel.node, wheel.wheelShape, wheel.maxLongStiffness, wheel.maxLatStiffness, wheel.maxLatStiffnessLoad, frictionCoeff);
						else
							wheel.newRadius = wheel.realRadius-math.random(10, 20)/100;
						end;
					end;
					if wheel.tireType ~= 4 then
						wheel.enableDrift = (AxleSpeed > speed and AxleSpeed > 5);
						if wheel.enableDrift then
							wheel.newRadius = math.max(wheel.newRadius - 0.00001*wheel.driftCoeff*dt, wheel.minRadius);
						end;
					end;
					if AxleSpeed > 2 then
						if wheel.radius < wheel.newRadius then
							wheel.radius = math.min(wheel.radius + 0.0003*dt, wheel.newRadius);
							self:updateWheelBase(wheel, true);
						else
							wheel.radius = math.max(wheel.radius - 0.0003*dt, wheel.newRadius);
							self:updateWheelBase(wheel, true);
						end;
					end;
				end;
				if wheel.wasInDirtS and not wheel.inDirt then
					local AxleSpeed = math.abs(getWheelShapeAxleSpeed(wheel.node, wheel.wheelShape));
					if AxleSpeed > 2 then
						wheel.radius = math.min(wheel.radius + 0.001*dt, wheel.realRadius);
						self:updateWheelBase(wheel, true);
						if wheel.radius >= wheel.realRadius then
							wheel.wasInDirtS = false;
							if wheel.tireType ~= 4 then
								setWheelShapeTireFriction(wheel.node, wheel.wheelShape, wheel.maxLongStiffness, wheel.maxLatStiffness, wheel.maxLatStiffnessLoad, wheel.tireGroundFrictionCoeff);
							end;
						end;
					end;
				end;
				if terrainControl.bumpySimulating and not wheel.inDirt and not wheel.wasInDirtS then
					if enableChanges then
						local x, _, z = getWorldTranslation(wheel.driveNode);
						local bits = getDensityAtWorldPos(g_currentMission.terrainDetailId, x,z);
						if bits == 0 and wheel.lastColor[4] < 0.8 then
							wheel.newRadius = wheel.realRadius;
						end;
						if wheel.tireType ~= 4 then
							if bits > 0 or wheel.lastColor[4] > 0.8 then
								local delta = 0.01-math.random(0, 2)/100;
								wheel.newRadius = wheel.realRadius - delta;
								if self.motor then LineDamp = LineDamp + 0.1/#self.wheels; end;
							end;
							if bits == 2 or bits == 18 or bits == 34 or bits == 66 or bits == 98 then
								wheel.newRadius = wheel.realRadius-math.random(15, 30)/100;
								if self.motor then LineDamp = LineDamp + 0.1/#self.wheels; end;
							end;
							if bits == 2^g_currentMission.cultivatorChannel then
								wheel.newRadius = wheel.realRadius-math.random(5, 9)/100;
								if self.motor then LineDamp = LineDamp + 0.05/#self.wheels; end;
							end;
							if bits == 2^g_currentMission.sowingChannel then
								wheel.newRadius = wheel.realRadius-math.random(5, 9)/100;
								if self.motor then LineDamp = LineDamp + 0.05/#self.wheels; end;
							end;
							if bits == 2^g_currentMission.sowingWidthChannel then
								wheel.newRadius = wheel.realRadius-math.random(5, 9)/100;
								if self.motor then LineDamp = LineDamp + 0.05/#self.wheels; end;
							end;
						else
							wheel.newRadius = wheel.realRadius;
							if bits == 2 or bits == 18 or bits == 34 or bits == 66 or bits == 98 then
								wheel.newRadius = wheel.realRadius-math.random(5, 10)/100;
								LineDamp = LineDamp + 0.075/#self.wheels;
							end;
							if bits == 2^g_currentMission.cultivatorChannel then
								wheel.newRadius = wheel.realRadius-math.random(3, 6)/100;
								LineDamp = LineDamp + 0.05/#self.wheels;
							end;
							if bits == 2^g_currentMission.sowingChannel then
								wheel.newRadius = wheel.realRadius-math.random(0, 5)/100;
								LineDamp = LineDamp + 0.025/#self.wheels;
							end;
							if bits == 2^g_currentMission.sowingWidthChannel then
								wheel.newRadius = wheel.realRadius-math.random(0, 5)/100;
								LineDamp = LineDamp + 0.025/#self.wheels;
							end;
						end;
					end;
					if wheel.radius > wheel.newRadius then
						wheel.radius = math.max(wheel.radius - 0.00075*dt, wheel.newRadius);
						self:updateWheelBase(wheel, true);
					elseif wheel.radius < wheel.newRadius then
						wheel.radius = math.min(wheel.radius + 0.00075*dt, wheel.newRadius);
						self:updateWheelBase(wheel, true);
					end;
				end;
			end;
			if enableChanges and self.lineDamp ~= LineDamp then
				setLinearDamping(self.rootNode, LineDamp);
				self.lineDamp = LineDamp;
			end;
			if dirtAmount > 0 and self.dirtAmount then
				self.dirtAmount = math.min(self.dirtAmount + dirtAmount, 1);
				if self.attachedImplements ~= nil then
					for i=1, #self.attachedImplements do
						local object = self.attachedImplements[i].object;
						if object.dirtAmount then object.dirtAmount = math.min(object.dirtAmount + dirtAmount, 1); end;
					end;
				end;
			end;
		end;
		for c=1, #self.wheels do
			local wheel = self.wheels[c];
			if wheel.tireType ~= 4 then
				if wheel.inDirt then
					wheel.wasInDirtC = true;
					setVisibility(wheel.dirtWave, true);
					local x,y,_ = getRotation(wheel.driveNode);
					local forwardDirection = x < wheel.lastRot;
					wheel.lastRot = x;
					local scale = math.min(speed/15, wheel.realRadius);
					setScale(wheel.dirtWave, scale, scale, scale);
					local dx,dy,dz = getWorldTranslation(wheel.driveNode);
					local dirtY = dy-wheel.radius;
					setTranslation(wheel.dirtWave, dx, dirtY, dz);
					if (wheel.enableDrift and self.isMotorStarted) or speed > 15 then
						Utils.setEmittingState(wheel.dirt2ParticleSystems, not forwardDirection);
						Utils.setEmittingState(wheel.dirt3ParticleSystems, forwardDirection);
					else
						Utils.setEmittingState(wheel.dirt2ParticleSystems, false);
						Utils.setEmittingState(wheel.dirt3ParticleSystems, false);
					end;
					setRotation(wheel.dirt2ParticleSystems[1].shape, math.rad(45),y,0);
					setRotation(wheel.dirt3ParticleSystems[1].shape, math.rad(45),y-math.rad(180),0);
				end;
				if wheel.wasInDirtC and not wheel.inDirt then
					local s1,s2,s3 = getScale(wheel.dirtWave);
					setScale(wheel.dirtWave, s1-0.1, s2-0.1, s3-0.1);
					Utils.setEmittingState(wheel.dirt2ParticleSystems, false);
					Utils.setEmittingState(wheel.dirt3ParticleSystems, false);
					if s1 < 0.1 then
						setVisibility(wheel.dirtWave, false);
						wheel.wasInDirtC = false;
					end;
				end;
			end;
		end;
	end;
end;

function terrainControl:updateTick(dt)
	if self:getLastSpeed(true) > 0 or self:getIsActive() then
		if #self.wheels > 0 then
			local enableCutting = terrainControl.cutFruitsByWheels;
			if enableCutting then
				if self.isAITractorActivated or self.isAIThreshing then
					enableCutting = false;
				end;
				if self.cp then
					if self.cp.isDriving then
						enableCutting = false;
					elseif self.cp.isDriving == nil then
						if self.attacherVehicle and self.attacherVehicle.cp.isDriving ~= nil then
							enableCutting = not self.attacherVehicle.cp.isDriving;
							self.cp.isAVDriving = self.attacherVehicle.cp.isDriving;
						end;
						if self.attacherVehicle and self.attacherVehicle.cp.isAVDriving ~= nil then
							enableCutting = not self.attacherVehicle.cp.isAVDriving;
							self.cp.isAVDriving = self.attacherVehicle.cp.isAVDriving;
						end;
					end;
				end;
			end;
			for c=1, #self.wheels do
				local wheel = self.wheels[c];
				local wx,wy,wz = getWorldTranslation(wheel.driveNode);
				local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, wx, 0, wz);
				local cx1 = wx+wheel.width/3;
				local cz1 = wz+wheel.width/3;
				local cx2 = wx-wheel.width/3;
				local cz2 = wz-wheel.width/3;
				if self.isServer then
					wheel.inDirt = false;
					wheel.onDirtyBorder = false;
					if wheel.contact > 0 and wy-wheel.radius-terrainHeight < 1 then
						local growing, readyToHarvest = terrainControl.getDirtyArea(cx1, cz1, cx2, cz1, cx2, cz2);
						if growing or readyToHarvest then
							wheel.inDirt = true;
							g_currentMission.tyreTrackSystem:eraseParallelogram(cx1, cz1, cx2, cz1, cx2, cz2);
							if growing then
								wheel.onDirtyBorder = true;
							end;
						end;
					end;
				end;
				if enableCutting then
					if wheel.contact == 0 or wheel.inDirt or wheel.wasInDirtS then
						enableCutting = false;
					end;
					if enableCutting then
						for f=1, #terrainControl.fruitTypes do
							local fruitType = terrainControl.fruitTypes[f];
							if fruitType == FruitUtil.FRUITTYPE_GRASS then
								Utils.cutFruitArea(fruitType, cx1, cz1, cx2, cz1, cx2, cz2, true, true);
							else
								local growing, readyToHarvest, withered = self.getAllStatesFruitArea(fruitType, cx1, cz1, cx2, cz1, cx2, cz2);
								if growing then
									Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, cx1, cz1, cx2, cz1, cx2, cz2, 1, true);
								end;
								if readyToHarvest then
									if fruitType == FruitUtil.FRUITTYPE_WHEAT or fruitType == FruitUtil.FRUITTYPE_BARLEY or fruitType == FruitUtil.FRUITTYPE_RYE or fruitType == FruitUtil.FRUITTYPE_OAT then
										Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_WHEAT, cx1, cz1, cx2, cz1, cx2, cz2, 1, true);
									end;
								end;
								if growing or readyToHarvest or withered then
									Utils.cutAllStatesFruitArea(fruitType, cx1, cz1, cx2, cz1, cx2, cz2);
									break;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function terrainControl:readUpdateStream(streamId, timestamp, connection)
	if connection.isServer then
		for c=1, #self.wheels do
			local wheel = self.wheels[c];
			wheel.inDirt = streamReadBool(streamId);
			wheel.enableDrift = streamReadBool(streamId);
		end;
	end;
end;

function terrainControl:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection.isServer then
		for c=1, #self.wheels do
			local wheel = self.wheels[c];
			streamWriteBool(streamId, wheel.inDirt);
			streamWriteBool(streamId, wheel.enableDrift);
		end;
	end;
end;

function terrainControl:draw()
end;

function terrainControl.getAllStatesFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	local ids = g_currentMission.fruits[fruitId];
	if ids == nil or ids.id == 0 then
		return false, false, false;
	end;
	local id = ids.id;
	local growing = false;
	local readyToHarvest = false;
	local withered = false;
	local desc = FruitUtil.fruitIndexToDesc[fruitId];
	setDensityReturnValueShift(id, -1);
	setDensityCompareParams(id, "between", desc.minHarvestingGrowthState, desc.minHarvestingGrowthState);
	local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	local ret = getDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
	if ret > 0 then growing = true; end;
	setDensityCompareParams(id, "between", desc.minHarvestingGrowthState+1, desc.maxHarvestingGrowthState+1);
	local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	local ret = getDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
	if ret > 0 then readyToHarvest = true; end;
	setDensityCompareParams(id, "between", desc.maxHarvestingGrowthState+1, desc.maxHarvestingGrowthState+2);
	local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	local ret = getDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
	if ret > 0 then withered = true; end;
	setDensityCompareParams(id, "greater", -1);
	setDensityReturnValueShift(id, 0);
	return growing, readyToHarvest, withered;
end;

function terrainControl.getDirtyArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
    if FruitUtil.modFoliageId_Dirty == 0 then
        return false,false
    end
    local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(FruitUtil.modFoliageId_Dirty, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
    local sumPixels,numPixels,totPixels = getDensityParallelogram(FruitUtil.modFoliageId_Dirty, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
    if sumPixels <= 0 or totPixels <= 0 then
        return false, false
    end
    local ret = totPixels / sumPixels   -- Calculate a percentage of the 'density'.
    --print(string.format("%.2f %d %d %d", ret, sumPixels, numPixels, totPixels))
    return (ret <= 0.5), (ret > 0.5)
end;
