--author: igor29381 from S.W.I.K. modding team https://vk.com/stasenko100
--co-author: Decker_MMIV - fs-uk.com, forum.farming-simulator.com, modhoster.com

terrainAndDirtControl = {};
terrainAndDirtControl.curModDir = g_currentModDirectory;
terrainAndDirtControl.loaded = false;

function terrainAndDirtControl:loadMap(name)
	SpecializationUtil.registerSpecialization("terrainControl", "terrainControl", terrainAndDirtControl.curModDir.."terrainControl.lua");
	if not terrainAndDirtControl.loaded then
		for k,v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				table.insert(v.specializations, SpecializationUtil.getSpecialization("terrainControl"));
			end;
		end;
		local i3dFilename = terrainAndDirtControl.curModDir.."dirtPS/dirt_1.i3d";
		if fileExists(i3dFilename) then
			local dirtRoot = Utils.loadSharedI3DFile(i3dFilename);
			terrainControl.dirtWave = getChildAt(dirtRoot, 0);
			link(getRootNode(), terrainControl.dirtWave);
			delete(dirtRoot);
			setVisibility(terrainControl.dirtWave, false);
		end;
	end;
	terrainControl.fruitTypes = {
	FruitUtil.FRUITTYPE_WHEAT,
	FruitUtil.FRUITTYPE_BARLEY,
	FruitUtil.FRUITTYPE_RAPE,
	--       
	--here you can add another fruitTypes for destroy them by wheels
	FruitUtil.FRUITTYPE_MAIZE};
	if WheelLanes then
		terrainControl.cutFruitsByWheels = false;
	end;
	if g_currentMission.driveControl and g_currentMission.driveControl.useModules then
		g_currentMission.driveControl.useModules.groundResponse = false;
		g_currentMission.driveControl.useModules.fruitDestruction = false;
	end;
	terrainAndDirtControl.loaded = true;
end;

function terrainAndDirtControl:deleteMap()
	FruitUtil.modFoliageId_Dirty = nil;
end;

function terrainAndDirtControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function terrainAndDirtControl:keyEvent(unicode, sym, modifier, isDown)
end;

function terrainAndDirtControl:update(dt)
end;

function terrainAndDirtControl:draw(dt)
end;

addModEventListener(terrainAndDirtControl);

function WheelsUtil.updateWheelsGraphics(self, dt)
	if self.isServer then
		self.hasWheelGroundContact = false;
	end;
	for i, wheel in pairs(self.wheels) do
		WheelsUtil.updateWheelSteeringAngle(self, wheel, dt);
		if self.isServer then
			WheelsUtil.updateWheelHasGroundContact(wheel);
			if wheel.hasGroundContact then
				self.hasWheelGroundContact = true;
			end;
			local x,y,z, xDrive = getWheelShapePosition(wheel.node, wheel.wheelShape);
			WheelsUtil.updateWheelGraphics(self, wheel, x, y, z, xDrive);
			--fill netinfo (on server)
			wheel.netInfo.x = x;
			wheel.netInfo.y = y;
			wheel.netInfo.z = z;
			wheel.netInfo.xDrive = xDrive;
		else
			-- client code
			local x, y, z = wheel.netInfo.x, wheel.netInfo.y, wheel.netInfo.z;
			if self:getLastSpeed(true) > 0 and wheel.tireType ~= 4 then
				if wheel.lastYnetInfo then
					if math.abs(math.abs(wheel.lastYnetInfo)-math.abs(y)) > 0.02 then
						if wheel.lastYnetInfo < y then
							y = wheel.lastYnetInfo+0.02;
						else
							y = wheel.lastYnetInfo-0.02;
						end;
					end;
				end;
				wheel.lastYnetInfo = y;
			end;
			local xDrive = wheel.netInfo.xDrive;
			WheelsUtil.updateWheelGraphics(self, wheel, x, y, z, xDrive);
		end;
	end;
end;

function Vehicle:updateWheelBase(wheel, dirt)
    local inDirt = Utils.getNoNil(dirt, false);
	local positionY = wheel.positionY+wheel.deltaY;
    if self.isServer then
        local collisionMask = 255 - 4; -- all up to bit 8, except bit 2 which is set by the players kinematic object
        wheel.wheelShape = createWheelShape(wheel.node, wheel.positionX, positionY, wheel.positionZ, wheel.radius, wheel.suspTravel, wheel.spring, wheel.damper, wheel.mass, collisionMask, wheel.wheelShape);
        local forcePointY = positionY - wheel.radius * wheel.forcePointRatio;
        setWheelShapeForcePoint(wheel.node, wheel.wheelShape, wheel.positionX, forcePointY, wheel.positionZ);
    end;
	if not inDirt then
		wheel.netInfo = {};
		wheel.netInfo.xDrive = 0;
		wheel.netInfo.x = wheel.positionX;
		wheel.netInfo.y = positionY;
		wheel.netInfo.z = wheel.positionZ;
		-- The suspension elongates by 20% of the specified susp travel
		wheel.netInfo.yMin = positionY-1.2*wheel.suspTravel;
		wheel.netInfo.yRange = 1.2*wheel.suspTravel;
		if wheel.netInfo.yRange < 0.001 then
			-- avoid division by 0
			wheel.netInfo.yRange = 0.001;
		end;
	end;
    if wheel.driveGroundParticleSystem ~= nil then
        local wx, wy, wz = worldToLocal(wheel.node, getWorldTranslation(wheel.driveNode));
        setTranslation(wheel.driveGroundParticleSystem.rootNode, wx + wheel.driveGroundParticleSystem.offsets[1], wy - wheel.radius + wheel.driveGroundParticleSystem.offsets[2], wz + wheel.driveGroundParticleSystem.offsets[3]);
    end;
end;

function Vehicle:getDriveGroundParticleSystemsScale(particleSystem)
    local wheel = particleSystem.wheel;
    if wheel ~= nil then
        if (particleSystem.onlyActiveOnGroundContact and wheel.contact ~= Vehicle.WHEEL_GROUND_CONTACT) or wheel.inDirt then
            return 0;
        end;
        if math.abs(wheel.lastColor[1]-0.275) <= 0.001 and math.abs(wheel.lastColor[2]-0.212) <= 0.001 and math.abs(wheel.lastColor[3]-0.160) <= 0.001 then
            return 0;
        end;
    end;
    local minSpeed = particleSystem.minSpeed;
    local direction = particleSystem.direction;
	if self.lastSpeedReal > minSpeed and (direction == 0 or (direction > 0) == (self.movingDirection > 0)) then
		local maxSpeed = particleSystem.maxSpeed;
		local alpha = math.min((self.lastSpeedReal - minSpeed) / (maxSpeed - minSpeed), 1);
		local scale = Utils.lerp(particleSystem.minScale, particleSystem.maxScale, alpha);
		return scale;
	end;
    return 0;
end;

function Utils.cutAllStatesFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	local ids = g_currentMission.fruits[fruitId];
	if ids == nil or ids.id == 0 then
		return;
	end;
	local id = ids.id;
	local desc = FruitUtil.fruitIndexToDesc[fruitId];
	local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	setDensityReturnValueShift(id, -1);
	setDensityCompareParams(id, "greater", desc.minHarvestingGrowthState);
	setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, 0);
	setDensityCompareParams(id, "greater", -1);
	setDensityReturnValueShift(id, 0);
end;
