--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		setTextColor(1,0.847,0,1);
		renderText(0.78, 0.29, 0.022, InputBinding.getKeyNamesOfDigitalAction(InputBinding.TOGGLE_SHOW_HELP)..": Info Ein");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.78, 0.29, 0.022, InputBinding.getKeyNamesOfDigitalAction(InputBinding.TOGGLE_SHOW_HELP)..": Info Aus");
		renderText(0.76, 0.71, 0.023, "- VW ELW Info -");
		renderText(0.76, 0.65, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.Horn1)..": Land Horn Ein/Aus");
		renderText(0.76, 0.63, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.Horn2)..": Stadt Horn Ein/Aus");
		renderText(0.76, 0.61, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.Markiese)..": Markiese Rein/Raus");
		renderText(0.76, 0.59, 0.018, InputBinding.getKeyNamesOfDigitalAction(InputBinding.Blaulicht)..": Blaulicht Ein/Aus");

	end;
end;  

function ShowHelp:onLeave()
	self.showHelp = false;
end;




