-- Oryginał --
-- Animacja ktora wprawia w ruch pasy, gdy jest aktywna komenda [self.isTurnedOn] --
-- Autor: Grzegorz056 --


-- Modyfikacja --
-- Animacja plandeki dla kosiarki rotacyjnej [zmiana parametrow shadera przy danej predkosci] --
-- Autor: Rockstar94 --



AnimacjaPlandeki = {};

function AnimacjaPlandeki.prerequisitesPresent(specializations)
    return true
end;

function AnimacjaPlandeki:load(xmlFile)
	self.plandeka = {};
	
    local i = 0;
    while true do
        local key = string.format("vehicle.plandeka.plandeka_kosiarka(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node ~= nil then
            table.insert(self.plandeka, {node=node});
        end;
	    i = i +1;
    end;
end;

function AnimacjaPlandeki:delete()
end;

function AnimacjaPlandeki:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimacjaPlandeki:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimacjaPlandeki:update(dt)
    if self:getIsActive() then
	    if self.isTurnedOn then
	    	for _, part in pairs(self.plandeka) do
				 if self.lastSpeed*3600 > 3 then
					setShaderParameter(part.node, "displacementSpeedFrequencyAndTexOff", 0.01, 10, 1, 0.26, false);
				end;
				 if self.lastSpeed*3600 > 6 then
					setShaderParameter(part.node, "displacementSpeedFrequencyAndTexOff", 0.015, 10, 1, 0.26, false);
				end;
				 if self.lastSpeed*3600 > 9 then
					setShaderParameter(part.node, "displacementSpeedFrequencyAndTexOff", 0.02, 10, 1, 0.26, false);
				end;
				 if self.lastSpeed*3600 > 12 then
					setShaderParameter(part.node, "displacementSpeedFrequencyAndTexOff", 0.025, 10, 1, 0.26, false);
				end;
				 if self.lastSpeed*3600 > 15 then
					setShaderParameter(part.node, "displacementSpeedFrequencyAndTexOff", 0.03, 10, 1, 0.26, false);
				end;
				if self.lastSpeed*3600 < 3 then
					setShaderParameter(part.node, "displacementSpeedFrequencyAndTexOff", 0.005, 10, 1, 0.26, false);
				end;
	    	end;		
	    elseif not self.isTurnedOn then
	        for _, part in pairs(self.plandeka) do
            	setShaderParameter(part.node, "displacementSpeedFrequencyAndTexOff", 0, 0, 0, 0, false);
  	    	end;	
        end;	
    end;
end;

function AnimacjaPlandeki:onLeave()
end;

function AnimacjaPlandeki:onEnter()
end;

function AnimacjaPlandeki:onDeactivate()
end;

function AnimacjaPlandeki:draw()
end;