--
-- BritishFarmStyle
--
-- @author  Mike LSNG
-- @date  11/11/14
--
-- Copyright (C) LS-NG Modteam, www.ls-nextgeneration.com

BritishFarmStyle = {}

local BritishFarmStyle_mt = Class(BritishFarmStyle, Mission00);


function BritishFarmStyle:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = BritishFarmStyle_mt;
    end;
    local self = BritishFarmStyle:superClass():new(baseDirectory, mt);

    return self;
end;

function BritishFarmStyle:delete()
    BritishFarmStyle:superClass().delete(self);
end;

function BritishFarmStyle:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("BFS.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
end;

function BritishFarmStyle:loadCareerMap01Finished(node, arguments)
    if self.cancelLoading then
        return;
    end
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("BritishFarmStyle.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    -- ATMs
    self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), 558.42474365234, -397.28216552734, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), 361.59826660156, 130.29161071777, nil, nil, false, false, false, 0, true);

    -- shops
    self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), 568.13726806641, -369.64007568359, nil, nil, false, false, false, 0, true);
    --local gardenCenterHotspot = self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), -572, 366, nil, nil, false, false, true, 0, true);
    --gardenCenterHotspot.fullViewName = g_i18n:getText("gardenCenter");

    -- egg sellpoints
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), 355.26113891602, 110.37953948975, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), -741.5, -187, nil, nil, false, false, false, 0, true);
    
    -- farm silos
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), -8.8534889221191, 75.332122802734, nil, nil, false, false, false, 0, true);
    
    -- bga
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 493.78726196289, -396.0832824707, nil, nil, false, false, false, 0, true);
    
    -- grass heaps
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -62.408115386963, 32.487701416016, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -730.5, 140, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -144.5, 264.5, nil, nil, false, false, false, 0, true);
    --self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -297, -595.5, nil, nil, false, false, false, 0, true);
    
    -- livestock
    self.ingameMap:createMapHotspot("Cows", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_cows.png", self.baseDirectory), -7.8279132843018, -21.177318572998, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Sheep", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_sheep.png", self.baseDirectory), -142.38803100586, -91.695266723633, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Chickens", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_chickens.png", self.baseDirectory), 39.78727722168, 22.628755569458, nil, nil, false, false, false, 0, true);
    
    -- spinnery
    self.ingameMap:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_spinnery.png", self.baseDirectory), 522.40930175781, -269.88354492188, nil, nil, false, false, false, 0, true);

	trcScreenFlip();
    BritishFarmStyle:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
end;

function BritishFarmStyle:onStartMission()
    BritishFarmStyle:superClass().onStartMission(self);
end;

function BritishFarmStyle:mouseEvent(posX, posY, isDown, isUp, button)
    BritishFarmStyle:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function BritishFarmStyle:keyEvent(unicode, sym, modifier, isDown)
    BritishFarmStyle:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function BritishFarmStyle:update(dt)
    BritishFarmStyle:superClass().update(self, dt);
end;

function BritishFarmStyle:draw()
    BritishFarmStyle:superClass().draw(self);
end;
