-- Fortuna
-- 
--
-- @ Autor  FireAndIce (www.bm-modding.de)
-- @ Last Edit  20/10/2013

-- some stuff by Stefan Maurus (Graindoor)


Fortuna = {};

function Fortuna.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations); 
end;

function Fortuna:load(xmlFile)
	self.axle1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index1"));
	self.axle2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index2"));
	
	self.sampleFillSoundTemp = {};
	self.sampleFillSoundTemp.isPlaying = self.sampleFillSound.isPlaying;
	self.sampleFillSoundTemp.sample = self.sampleFillSound.sample;
	self.sampleFillSoundTemp.volume = self.sampleFillSound.volume;
	self.sampleFillSound.sample = nil;
end;

function Fortuna:delete()
	if self.sampleFillSoundTemp.sample ~= nil then
		delete(self.sampleFillSoundTemp.sample);
	end;
end;

function Fortuna:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fortuna:keyEvent(unicode, sym, modifier, isDown)
end;

function Fortuna:update(dt)
	if self.fillLevel > 0 and self.tipState > 0 and self.tipState < 3 and self.isClient then
		local animTime = self:getAnimationTime("tipAnimationGrainDoor");
		local animTime1 = self:getAnimationTime("tipAnimationBack") == 0;
		if self.sampleFillSoundTemp.isPlaying and animTime < 0.05 and animTime1 then
			stopSample(self.sampleFillSoundTemp.sample);
			self.sampleFillSoundTemp.isPlaying = false;
		elseif not self.sampleFillSoundTemp.isPlaying and animTime > 0.05 and animTime1 and self:getIsActiveForSound() then
			playSample(self.sampleFillSoundTemp.sample, 0, self.sampleFillSoundTemp.volume, 0);
			self.sampleFillSoundTemp.isPlaying = true;
		elseif not self.sampleFillSoundTemp.isPlaying and not animTime1 and self:getIsActiveForSound() then
			playSample(self.sampleFillSoundTemp.sample, 0, self.sampleFillSoundTemp.volume, 0);
			self.sampleFillSoundTemp.isPlaying = true;		
		end;
	else
		stopSample(self.sampleFillSoundTemp.sample);
		self.sampleFillSoundTemp.isPlaying = false;
	end;
	
	if self:getIsActive() then
		local xr1,_,_ = getRotation(self.axle1);
		local xr2,_,_ = getRotation(self.axle2);
		if xr1 ~= 0 or xr2 ~= 0 then 
			local xrw1,yrw1,zrw1 = getRotation(self.wheels[1].repr);
			local xrw2,yrw2,zrw2 = getRotation(self.wheels[2].repr);
			local xrw3,yrw3,zrw3 = getRotation(self.wheels[3].repr);
			local xrw4,yrw4,zrw4 = getRotation(self.wheels[4].repr);
			local newRot1 = zrw1 - xr1;
			local newRot2 = zrw3 - xr2;
			setRotation(self.wheels[1].repr, xrw1,yrw1,newRot1)
			setRotation(self.wheels[2].repr, xrw2,yrw2,newRot1)
			setRotation(self.wheels[3].repr, xrw3,yrw3,newRot2)
			setRotation(self.wheels[4].repr, xrw4,yrw4,newRot2)
		end;
	elseif self.tipState ~= 0 then
		for _, part in pairs(self.activeDirtyMovingParts) do
			Cylindered.setDirty(self, part);
		end;
	end;
end;

function Fortuna:updateTick(dt)
	local animTime = self:getAnimationTime("tipAnimationGrainDoor");
	if animTime > 0 and (self.currentFillType == Fillable.fillTypeNameToInt["chaff"] or self.currentFillType == Fillable.fillTypeNameToInt["potato"] or self.currentFillType == Fillable.fillTypeNameToInt["sugarBeet"] or self.currentFillType == Fillable.fillTypeNameToInt["silage"] or self.currentFillType == Fillable.fillTypeNameToInt["woodChips"]) then
		self:onEndTip();
	end;
end;

function Fortuna:draw()	
end;

function Fortuna:onAttach()
end;

function Fortuna:onDetach()
end;