--
-- workLights
-- Specialization for workLights.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

workLights = {};

function workLights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function workLights:load(xmlFile)
	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workLights#count"), 0);
    self.workLights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.workLights.workLight%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	self.workLightsActive = false;
	
	  self.numjumWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.jumWheels#count"), 0);
    self.jumWheels = {};
    for i=1, self.numjumWheels do
        local jumWheelnamei = string.format("vehicle.jumWheels.jumWheel" .. "%d", i);
        self.jumWheels[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, jumWheelnamei .. "#index"));
        setVisibility(self.jumWheels[i], false);        
    end;
    self.jumelagesActive = false;	
end;

function workLights:delete()
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
end;

function workLights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function workLights:keyEvent(unicode, sym, modifier, isDown)
end;

function workLights:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.WORKLIGHTS) then
			self.workLightsActive = not self.workLightsActive;
		end;
		if InputBinding.hasEvent(InputBinding.FORDJUMELAGE) then
			self.jumelagesActive = not self.jumelagesActive;
		end;
	
		for k, worklight in pairs(self.workLights) do
			setVisibility(worklight, self.workLightsActive);
		end;
		    for k, jumWheel in pairs(self.jumWheels) do
				setVisibility(jumWheel, self.jumelagesActive);
			end;
	end;
end;

function workLights:onLeave()
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
end;

function workLights:draw()
	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("WORKLIGHT"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.WORKLIGHTS));
	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("FORDJUMELAGE"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.FORDJUMELAGE));
end;

