local metadata = {
"## Interface:FS15 1.1.0.0 RC12",
"## Title: FoerderBandStatusEvent",
"## Notes: Event für Status änderungen",
"## Author: Marhu",
"## Version: 1.0.3",
"## Date: 21.01.2015",
"## Web: http://marhu.net"
}

FoerderBandStatusEvent = {};
FoerderBandStatusEvent_mt = Class(FoerderBandStatusEvent, Event);

InitEventClass(FoerderBandStatusEvent, "FoerderBandStatusEvent");

function FoerderBandStatusEvent:emptyNew()
    local self = Event:new(FoerderBandStatusEvent_mt);
    return self;
end;
    
function FoerderBandStatusEvent:new(object)
	local self = FoerderBandStatusEvent:emptyNew()
	self.object = object;
	self.IsOn = object.IsOn;
	self.TrailerFindLight = object.TrailerFindLight_Time and true or false;
	self.inRange = object.inRange and true or false;
	return self;
end;

function FoerderBandStatusEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.IsOn);
	streamWriteBool(streamId, self.TrailerFindLight);
	streamWriteBool(streamId, self.inRange);
end;

function FoerderBandStatusEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.IsOn = streamReadBool(streamId);
	self.TrailerFindLight = streamReadBool(streamId);
	self.inRange = streamReadBool(streamId);
	
	self:run(connection);
end;

function FoerderBandStatusEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:setOn(self.IsOn, true);
		if connection:getIsServer() then
			self.object.TrailerFindLight_Time = self.TrailerFindLight and 2000 or nil;
			self.object.inRange = self.inRange;
		end;
	end;
end;

function FoerderBandStatusEvent.sendEvent(vehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(FoerderBandStatusEvent:new(vehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(FoerderBandStatusEvent:new(vehicle));
		end;
	end;
end;